/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CodeConverter;
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.FieldInfo;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.SignatureAttribute;
/*     */ import javassist.expr.ExprEditor;
/*     */ import javassist.expr.FieldAccess;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.InterceptionMarkers;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.util.Advisable;
/*     */ 
/*     */ public abstract class FieldAccessTransformer
/*     */   implements CodeConversionObserver
/*     */ {
/*     */   static final String FIELD_INFO_CLASS_NAME = "org.jboss.aop.FieldInfo";
/*     */   Instrumentor instrumentor;
/*     */   boolean optimize;
/*     */   private Codifier codifier;
/*     */   private JoinpointClassifier classifier;
/*  64 */   protected static final String[] transformations = { "get", "set" };
/*     */   protected static final int GET_INDEX = 0;
/*     */   protected static final int SET_INDEX = 1;
/*  67 */   protected static final WrapperTransformer wrapper = new WrapperTransformer(transformations);
/*     */ 
/*     */   protected FieldAccessTransformer(Instrumentor instrumentor)
/*     */   {
/*  72 */     this.instrumentor = instrumentor;
/*  73 */     this.optimize = AspectManager.optimize;
/*  74 */     this.codifier = new Codifier();
/*  75 */     this.classifier = instrumentor.joinpointClassifier;
/*     */   }
/*     */ 
/*     */   protected void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor, boolean shouldReplaceArrayAccess)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  82 */     List fields = Instrumentor.getAdvisableFields(clazz);
/*     */ 
/*  84 */     int fieldIndex = fieldOffset(clazz.getSuperclass());
/*  85 */     boolean skipFieldInterception = true;
/*  86 */     if (fields.size() > 0)
/*     */     {
/*  88 */       Iterator it = fields.iterator();
/*  89 */       for (int index = 0; it.hasNext(); fieldIndex++)
/*     */       {
/*  91 */         CtField field = (CtField)it.next();
/*  92 */         JoinpointClassification classificationGet = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
/*  93 */         JoinpointClassification classificationSet = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
/*  94 */         if ((isPrepared(classificationGet)) || (isPrepared(classificationSet)))
/*     */         {
/*  99 */           if (!Modifier.isPrivate(field.getModifiers()))
/*     */           {
/* 101 */             skipFieldInterception = false;
/*     */           }
/*     */ 
/* 104 */           doBuildFieldWrappers(clazz, field, fieldIndex, shouldReplaceArrayAccess, classificationGet, classificationSet);
/*     */         }
/*  89 */         index++;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 108 */     if (skipFieldInterception)
/*     */     {
/* 111 */       if (superClassHasAdvisedFields(clazz.getSuperclass()))
/*     */       {
/* 113 */         skipFieldInterception = false;
/*     */       }
/*     */     }
/*     */ 
/* 117 */     if (skipFieldInterception)
/*     */     {
/* 119 */       advisor.getManager().getInterceptionMarkers().skipFieldAccess(clazz.getName());
/*     */     }
/*     */     else
/*     */     {
/* 123 */       advisor.getManager().getInterceptionMarkers().addFieldInterceptionMarker(clazz.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean superClassHasAdvisedFields(CtClass superClass)
/*     */     throws NotFoundException
/*     */   {
/* 130 */     if ((superClass == null) || (superClass.getName().indexOf("java.") == 0))
/*     */     {
/* 132 */       return false;
/*     */     }
/*     */ 
/*     */     ClassAdvisor advisor;
/*     */     try
/*     */     {
/* 139 */       advisor = this.instrumentor.getManager().getTempClassAdvisor(superClass);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 143 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 146 */     List fields = Instrumentor.getAdvisableFields(superClass);
/*     */     Iterator it;
/* 147 */     if (fields.size() > 0)
/*     */     {
/* 149 */       for (it = fields.iterator(); it.hasNext(); )
/*     */       {
/* 151 */         CtField field = (CtField)it.next();
/* 152 */         if (Modifier.isPrivate(field.getModifiers()))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 157 */         JoinpointClassification classificationGet = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
/* 158 */         if (isPrepared(classificationGet))
/*     */         {
/* 160 */           return true;
/*     */         }
/*     */ 
/* 163 */         JoinpointClassification classificationSet = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
/* 164 */         if (isPrepared(classificationSet))
/*     */         {
/* 166 */           return true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 174 */     return superClassHasAdvisedFields(superClass.getSuperclass());
/*     */   }
/*     */ 
/*     */   protected boolean isPrepared(JoinpointClassification classification)
/*     */   {
/* 182 */     return classification != JoinpointClassification.NOT_INSTRUMENTED;
/*     */   }
/*     */ 
/*     */   protected abstract void doBuildFieldWrappers(CtClass paramCtClass, CtField paramCtField, int paramInt, boolean paramBoolean, JoinpointClassification paramJoinpointClassification1, JoinpointClassification paramJoinpointClassification2) throws NotFoundException, CannotCompileException;
/*     */ 
/*     */   protected String getArrayWriteRegistration(boolean shouldReplaceArrayAccess, String target, CtField field, String oldValue, String newValue) throws NotFoundException {
/* 189 */     if ((shouldReplaceArrayAccess) && ((field.getType().isArray()) || (field.getType().getName().equals("java.lang.Object"))))
/*     */     {
/* 191 */       return "org.jboss.aop.array.ArrayAdvisor.updateArrayField(" + target + ", \"" + field.getName() + "\", " + oldValue + ", " + newValue + ");";
/*     */     }
/* 193 */     return "";
/*     */   }
/*     */ 
/*     */   public boolean replaceFieldAccess(List fields, CtClass clazz, ClassAdvisor fieldsAdvisor)
/*     */     throws NotFoundException
/*     */   {
/* 207 */     CodeConverter converter = this.instrumentor.getCodeConverter();
/* 208 */     boolean converted = false;
/* 209 */     Iterator it = fields.iterator();
/* 210 */     while (it.hasNext())
/*     */     {
/* 212 */       CtField field = (CtField)it.next();
/* 213 */       if ((!Modifier.isPrivate(field.getModifiers())) && (Advisable.isAdvisable(field)))
/*     */       {
/* 215 */         JoinpointClassification fieldGetClassification = this.classifier.classifyFieldGet(field, fieldsAdvisor);
/*     */ 
/* 217 */         if (fieldGetClassification.equals(JoinpointClassification.WRAPPED))
/*     */         {
/* 219 */           converted = true;
/* 220 */           converter.replaceFieldRead(field, clazz, fieldRead(field.getName()));
/*     */         }
/* 222 */         JoinpointClassification fieldSetClassification = this.classifier.classifyFieldSet(field, fieldsAdvisor);
/* 223 */         if (fieldSetClassification.equals(JoinpointClassification.WRAPPED))
/*     */         {
/* 225 */           converted = true;
/* 226 */           converter.replaceFieldWrite(field, clazz, fieldWrite(field.getName()));
/*     */         }
/*     */       }
/*     */     }
/* 230 */     return converted;
/*     */   }
/*     */ 
/*     */   public void wrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 243 */     List advisableFields = Instrumentor.getAdvisableFields(clazz);
/* 244 */     CtField[] fields = new CtField[advisableFields.size()];
/* 245 */     fields = (CtField[])(CtField[])advisableFields.toArray(fields);
/* 246 */     for (Iterator iterator = fieldsGet.iterator(); iterator.hasNext(); )
/*     */     {
/* 248 */       int fieldIndex = ((Integer)iterator.next()).intValue();
/* 249 */       CtField field = fields[fieldIndex];
/* 250 */       if (wrapper.isNotPrepared(field, 0))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 255 */       wrapper.wrap(field, 0);
/*     */ 
/* 257 */       String code = "{" + field.getType().getName() + " var; return var;}";
/* 258 */       CtMethod method = getWrapperReadMethod(field, clazz);
/* 259 */       method.setBody(code);
/* 260 */       code = getWrapperBody(clazz, field, true, fieldIndex);
/* 261 */       if (!Modifier.isPrivate(field.getModifiers()))
/*     */       {
/* 263 */         this.instrumentor.converter.replaceFieldRead(field, clazz, fieldRead(field.getName()));
/* 264 */         this.codifier.addPendingCode(method, code);
/*     */       }
/*     */       else
/*     */       {
/* 268 */         replaceFieldAccessInternally(clazz, field, true, false, fieldIndex);
/* 269 */         method.setBody(code);
/*     */       }
/*     */     }
/* 272 */     for (Iterator iterator = fieldsSet.iterator(); iterator.hasNext(); )
/*     */     {
/* 274 */       int fieldIndex = ((Integer)iterator.next()).intValue();
/* 275 */       CtField field = fields[fieldIndex];
/* 276 */       if (wrapper.isNotPrepared(field, 1))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 281 */       wrapper.wrap(field, 1);
/*     */ 
/* 283 */       String code = "{  }";
/* 284 */       CtMethod method = getWrapperWriteMethod(field, clazz);
/* 285 */       method.setBody(code);
/* 286 */       code = getWrapperBody(clazz, field, false, fieldIndex);
/* 287 */       if (!Modifier.isPrivate(field.getModifiers()))
/*     */       {
/* 289 */         this.instrumentor.converter.replaceFieldWrite(field, clazz, fieldWrite(field.getName()));
/* 290 */         this.codifier.addPendingCode(method, code);
/*     */       }
/*     */       else
/*     */       {
/* 294 */         replaceFieldAccessInternally(clazz, field, false, true, fieldIndex);
/* 295 */         method.setBody(code);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected CtMethod getWrapperReadMethod(CtField field, CtClass clazz)
/*     */     throws NotFoundException
/*     */   {
/* 303 */     return clazz.getDeclaredMethod(fieldRead(field.getName()));
/*     */   }
/*     */ 
/*     */   protected CtMethod getWrapperWriteMethod(CtField field, CtClass clazz) throws NotFoundException
/*     */   {
/* 308 */     return clazz.getDeclaredMethod(fieldWrite(field.getName()));
/*     */   }
/*     */ 
/*     */   public void unwrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 321 */     ClassPool classPool = this.instrumentor.getClassPool();
/* 322 */     List advisableFields = Instrumentor.getAdvisableFields(clazz);
/* 323 */     CtField[] fields = new CtField[advisableFields.size()];
/* 324 */     fields = (CtField[])(CtField[])advisableFields.toArray(fields);
/*     */ 
/* 326 */     for (Iterator iterator = fieldsGet.iterator(); iterator.hasNext(); )
/*     */     {
/* 328 */       int fieldIndex = ((Integer)iterator.next()).intValue();
/* 329 */       CtField field = fields[fieldIndex];
/* 330 */       if (wrapper.isNotPrepared(field, 0))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 335 */       wrapper.unwrap(field, 0);
/*     */ 
/* 337 */       CtMethod method = clazz.getDeclaredMethod(fieldRead(field.getName()));
/* 338 */       String target = "((" + clazz.getName() + ")$1)";
/* 339 */       method.setBody("return " + target + "." + field.getName() + ";");
/*     */     }
/*     */ 
/* 342 */     for (Iterator iterator = fieldsSet.iterator(); iterator.hasNext(); )
/*     */     {
/* 344 */       int fieldIndex = ((Integer)iterator.next()).intValue();
/* 345 */       CtField field = fields[fieldIndex];
/* 346 */       if (wrapper.isNotPrepared(field, 1))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 351 */       wrapper.unwrap(field, 1);
/*     */ 
/* 354 */       CtMethod method = clazz.getDeclaredMethod(fieldWrite(field.getName()));
/* 355 */       String target = "((" + clazz.getName() + ")$1)";
/* 356 */       method.setBody(target + "." + field.getName() + "=$2" + ";");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void codeConverted()
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 364 */     this.codifier.codifyPending();
/*     */   }
/*     */ 
/*     */   protected int fieldOffset(CtClass clazz) throws NotFoundException
/*     */   {
/* 369 */     if (clazz == null)
/* 370 */       return 0;
/* 371 */     if (clazz.getName().equals("java.lang.Object"))
/* 372 */       return 0;
/* 373 */     int offset = fieldOffset(clazz.getSuperclass());
/*     */ 
/* 375 */     CtField[] fields = clazz.getDeclaredFields();
/* 376 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 378 */       if (!Advisable.isAdvisable(fields[i]))
/*     */         continue;
/* 380 */       offset++;
/*     */     }
/*     */ 
/* 383 */     return offset;
/*     */   }
/*     */ 
/*     */   protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException
/*     */   {
/* 388 */     return addFieldReadInfoFieldWithAccessors(modifiers, addTo, field, null);
/*     */   }
/*     */ 
/*     */   protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 396 */     String name = getFieldReadInfoFieldName(field.getName());
/* 397 */     TransformerCommon.addInfoField(this.instrumentor, "org.jboss.aop.FieldInfo", name, modifiers, addTo, addInfoAsWeakReference(), init);
/* 398 */     return name;
/*     */   }
/*     */ 
/*     */   protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException
/*     */   {
/* 403 */     return addFieldWriteInfoField(modifiers, addTo, field, null);
/*     */   }
/*     */ 
/*     */   protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field, CtField.Initializer init)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 411 */     String name = getFieldWriteInfoFieldName(field.getName());
/* 412 */     TransformerCommon.addInfoField(this.instrumentor, "org.jboss.aop.FieldInfo", name, modifiers, addTo, addInfoAsWeakReference(), init);
/* 413 */     return name;
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/* 418 */     return true;
/*     */   }
/*     */ 
/*     */   public static String getFieldReadInfoFieldName(String fieldName)
/*     */   {
/* 423 */     return "aop$FieldInfo_r_" + fieldName;
/*     */   }
/*     */ 
/*     */   public static String getFieldWriteInfoFieldName(String fieldName)
/*     */   {
/* 428 */     return "aop$FieldInfo_w_" + fieldName;
/*     */   }
/*     */ 
/*     */   public static String fieldRead(String fieldName)
/*     */   {
/* 433 */     return fieldName + "_r_" + "$aop";
/*     */   }
/*     */ 
/*     */   public static String fieldWrite(String fieldName)
/*     */   {
/* 438 */     return fieldName + "_w_" + "$aop";
/*     */   }
/*     */ 
/*     */   protected static String fieldInfoFromWeakReference(String localName, String fieldInfoName)
/*     */   {
/* 443 */     return TransformerCommon.infoFromWeakReference("org.jboss.aop.FieldInfo", localName, fieldInfoName);
/*     */   }
/*     */ 
/*     */   protected int getStaticModifiers(CtField field)
/*     */   {
/* 448 */     int mod = 8;
/* 449 */     if ((field.getModifiers() & 0x1) != 0)
/*     */     {
/* 451 */       mod |= 1;
/*     */     }
/* 453 */     else if ((field.getModifiers() & 0x4) != 0)
/*     */     {
/* 455 */       mod |= 4;
/*     */     }
/* 457 */     else if ((field.getModifiers() & 0x2) != 0)
/*     */     {
/* 459 */       mod |= 2;
/*     */     }
/*     */     else
/*     */     {
/* 463 */       mod |= 1;
/*     */     }
/*     */ 
/* 466 */     return mod;
/*     */   }
/*     */ 
/*     */   protected abstract void replaceFieldAccessInternally(CtClass paramCtClass, CtField paramCtField, boolean paramBoolean1, boolean paramBoolean2, int paramInt)
/*     */     throws CannotCompileException;
/*     */ 
/*     */   protected void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 491 */     if (doGet)
/*     */     {
/* 493 */       buildReadWrapperPlaceHolder(clazz, field, fieldRead(field.getName()), mod);
/*     */     }
/* 495 */     if (doSet)
/*     */     {
/* 497 */       buildWriteWrapperPlaceHolder(clazz, field, fieldWrite(field.getName()), mod);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected CtMethod buildReadWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 512 */     AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
/*     */ 
/* 514 */     String name = field.getName();
/* 515 */     CtClass ftype = field.getType();
/* 516 */     CtClass[] readParam = { classPool.get("java.lang.Object") };
/*     */ 
/* 520 */     String code = "{" + ftype.getName() + " var = ";
/* 521 */     if (ftype.isPrimitive())
/*     */     {
/* 523 */       if (ftype == CtClass.booleanType)
/*     */       {
/* 525 */         code = code + false;
/*     */       }
/* 527 */       else if (ftype == CtClass.byteType)
/*     */       {
/* 529 */         code = code + "(byte)0";
/*     */       }
/* 531 */       else if (ftype == CtClass.charType)
/*     */       {
/* 533 */         code = code + "(char)0";
/*     */       }
/* 535 */       else if (ftype == CtClass.doubleType)
/*     */       {
/* 537 */         code = code + "0.0";
/*     */       }
/* 539 */       else if (ftype == CtClass.floatType)
/*     */       {
/* 541 */         code = code + "(float)0.0";
/*     */       }
/* 543 */       else if (ftype == CtClass.intType)
/*     */       {
/* 545 */         code = code + "0";
/*     */       }
/* 547 */       else if (ftype == CtClass.longType)
/*     */       {
/* 549 */         code = code + "(long)0";
/*     */       }
/* 551 */       else if (ftype == CtClass.shortType)
/*     */       {
/* 553 */         code = code + "(short)0";
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 558 */       code = code + "null";
/*     */     }
/* 560 */     code = code + "; return var;}";
/* 561 */     CtMethod rmethod = CtNewMethod.make(ftype, wrapperName, readParam, null, code, clazz);
/* 562 */     rmethod.setModifiers(mod);
/* 563 */     clazz.addMethod(rmethod);
/*     */ 
/* 565 */     return rmethod;
/*     */   }
/*     */ 
/*     */   protected CtMethod buildWriteWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 579 */     AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
/*     */ 
/* 581 */     String name = field.getName();
/* 582 */     CtClass ftype = field.getType();
/*     */ 
/* 585 */     CtClass[] writeParam = new CtClass[2];
/* 586 */     writeParam[0] = classPool.get("java.lang.Object");
/* 587 */     writeParam[1] = ftype;
/*     */ 
/* 592 */     CtMethod wmethod = CtNewMethod.make(CtClass.voidType, wrapperName, writeParam, null, "{}", clazz);
/* 593 */     wmethod.setModifiers(mod);
/* 594 */     clazz.addMethod(wmethod);
/*     */ 
/* 596 */     SignatureAttribute ai = (SignatureAttribute)field.getFieldInfo2().getAttribute("Signature");
/* 597 */     if (ai != null)
/*     */     {
/* 599 */       MethodInfo wrapperInfo = wmethod.getMethodInfo2();
/* 600 */       SignatureAttribute methodAtt = new SignatureAttribute(wrapperInfo.getConstPool(), "(" + ai.getSignature() + ")V");
/* 601 */       wrapperInfo.addAttribute(methodAtt);
/*     */     }
/*     */ 
/* 604 */     return wmethod;
/*     */   }
/*     */ 
/*     */   protected abstract String getWrapperBody(CtClass paramCtClass, CtField paramCtField, boolean paramBoolean, int paramInt)
/*     */     throws NotFoundException, CannotCompileException;
/*     */ 
/*     */   protected abstract class FieldAccessExprEditor extends ExprEditor
/*     */   {
/*     */     CtClass clazz;
/*     */     CtField field;
/*     */     boolean doGet;
/*     */     boolean doSet;
/*     */     int fieldIndex;
/*     */ 
/*     */     public FieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index)
/*     */     {
/* 628 */       this.clazz = clazz;
/* 629 */       this.field = field;
/* 630 */       this.doGet = doGet;
/* 631 */       this.doSet = doSet;
/* 632 */       this.fieldIndex = index;
/*     */     }
/*     */ 
/*     */     public void edit(FieldAccess fieldAccess) throws CannotCompileException
/*     */     {
/* 637 */       if (!fieldAccess.getClassName().equals(this.clazz.getName())) return;
/* 638 */       if (!fieldAccess.getFieldName().equals(this.field.getName())) return;
/* 639 */       if (calledByInvocationClass(fieldAccess)) return;
/*     */ 
/* 641 */       if ((fieldAccess.isReader()) && (this.doGet))
/*     */       {
/* 643 */         replaceRead(fieldAccess);
/*     */       }
/* 645 */       if ((fieldAccess.isWriter()) && (this.doSet))
/*     */       {
/* 647 */         replaceWrite(fieldAccess);
/*     */       }
/*     */     }
/*     */ 
/*     */     private boolean calledByInvocationClass(FieldAccess fieldAccess)
/*     */     {
/*     */       try
/*     */       {
/* 655 */         return isInvocationClass(fieldAccess.where().getDeclaringClass());
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/*     */       }
/*     */ 
/* 661 */       return true;
/*     */     }
/*     */ 
/*     */     private boolean isInvocationClass(CtClass superClazz)
/*     */     {
/*     */       try
/*     */       {
/* 669 */         if (superClazz == null)
/*     */         {
/* 671 */           return false;
/*     */         }
/* 673 */         if (superClazz.getName().equals("java.lang.Object"))
/*     */         {
/* 675 */           return false;
/*     */         }
/* 677 */         if (superClazz.getName().equals("org.jboss.aop.joinpoint.Invocation"))
/*     */         {
/* 679 */           return true;
/*     */         }
/* 681 */         return isInvocationClass(superClazz.getSuperclass());
/*     */       }
/*     */       catch (NotFoundException e) {
/*     */       }
/* 685 */       throw new RuntimeException(e.getMessage(), e);
/*     */     }
/*     */ 
/*     */     protected abstract void replaceRead(FieldAccess paramFieldAccess)
/*     */       throws CannotCompileException;
/*     */ 
/*     */     protected abstract void replaceWrite(FieldAccess paramFieldAccess)
/*     */       throws CannotCompileException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.FieldAccessTransformer
 * JD-Core Version:    0.6.0
 */