/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Constructor;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ConstructorInfo;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.ConstructorExecution;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class ConstructorJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_constructor_";
/*     */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_constructor_";
/*  56 */   private static final Class JOINPOINT_TYPE = ConstructorExecution.class;
/*  57 */   private static final Class INVOCATION_TYPE = ConstructorInvocation.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */   WeakReference<Class<?>> returnType;
/*     */ 
/*     */   public ConstructorJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  75 */     super(advisor, info, JoinPointGenerator.JoinPointParameters.ONLY_ARGS, ((ConstructorInfo)info).getConstructor().getParameterTypes().length, false);
/*     */ 
/*  78 */     this.returnType = new WeakReference(((ConstructorInfo)info).getConstructor().getDeclaringClass());
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/*  84 */     ConstructorInfo cinfo = (ConstructorInfo)info;
/*  85 */     this.joinpointClassName = getGeneratedJoinPointClassName(classSimpleName(cinfo), index(cinfo));
/*     */ 
/*  89 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(classSimpleName(cinfo), index(cinfo));
/*     */   }
/*     */ 
/*     */   private String classSimpleName(ConstructorInfo info)
/*     */   {
/*  96 */     Constructor ctor = info.getConstructor();
/*  97 */     return Advisor.getSimpleName(ctor.getDeclaringClass());
/*     */   }
/*     */ 
/*     */   private int index(ConstructorInfo info)
/*     */   {
/* 102 */     return info.getIndex();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 107 */     return false;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 112 */     return (Class)this.returnType.get();
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 117 */     Constructor ctor = ((ConstructorExecution)joinPoint).getConstructor();
/* 118 */     return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getGenericParameterTypes(), ctor.getParameterTypes(), ctor.getGenericExceptionTypes(), ctor.getDeclaringClass(), false);
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 134 */     return false;
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 144 */     BaseClassGenerator generator = new BaseClassGenerator(instrumentor, advisedClass, advisedCtor, ciname, index);
/* 145 */     return generator.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(String className, int index)
/*     */   {
/* 150 */     return "joinpoint_constructor_" + className + "_" + index;
/*     */   }
/*     */ 
/*     */   private static String getGeneratedJoinPointClassName(String className, int index)
/*     */   {
/* 155 */     return "JoinPoint_constructor_" + className + "_" + index;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  63 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  67 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass advisedClass;
/*     */     CtConstructor advisedCtor;
/*     */     String ciname;
/*     */     int index;
/*     */     CtClass jp;
/*     */     CtClass[] params;
/*     */     CtClass constructorInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index)
/*     */       throws NotFoundException
/*     */     {
/* 177 */       this.instrumentor = instrumentor;
/* 178 */       this.advisedClass = advisedClass;
/* 179 */       this.advisedCtor = advisedCtor;
/* 180 */       this.ciname = ciname;
/* 181 */       this.index = index;
/* 182 */       this.params = advisedCtor.getParameterTypes();
/* 183 */       this.constructorInfoClass = instrumentor.forName("org.jboss.aop.ConstructorInfo");
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 188 */       this.jp = setupClass();
/* 189 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
/*     */ 
/* 191 */       addInvokeJoinpointMethod();
/* 192 */       addMethodInfoField();
/* 193 */       addPublicConstructor();
/* 194 */       addProtectedConstructors();
/* 195 */       addDispatchMethods();
/*     */ 
/* 197 */       TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
/* 198 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 204 */       String className = ConstructorJoinPointGenerator.access$000(this.advisedClass.getSimpleName(), this.index);
/*     */ 
/* 207 */       this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true, 9, ConstructorJoinPointGenerator.INVOCATION_CT_TYPE);
/* 208 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 209 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 219 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.constructorInfoClass }, new CtClass[0], "{super($1, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 225 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 234 */       CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
/* 235 */       CtClass[] ctorParams2 = new CtClass[1];
/*     */       CtClass tmp24_21 = this.jp; ctorParams2[0] = tmp24_21; ctorParams1[0] = tmp24_21;
/* 237 */       System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
/*     */ 
/* 239 */       StringBuffer body = new StringBuffer();
/* 240 */       body.append("{");
/* 241 */       body.append("   this($1.info);");
/*     */ 
/* 243 */       int offset = 1;
/* 244 */       StringBuffer setArguments = new StringBuffer();
/* 245 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 247 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/* 249 */       setArguments.append("}");
/*     */ 
/* 251 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 256 */       protectedConstructor.setModifiers(4);
/* 257 */       this.jp.addConstructor(protectedConstructor);
/* 258 */       if (this.params.length > 0)
/*     */       {
/* 260 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 265 */         protectedConstructor.setModifiers(4);
/* 266 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 276 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.advisedClass, "invokeJoinpoint", this.params, JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 283 */       invokeJoinpointMethod.setModifiers(4);
/* 284 */       this.jp.addMethod(invokeJoinpointMethod);
/* 285 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addMethodInfoField() throws CannotCompileException
/*     */     {
/* 290 */       CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
/* 291 */       infoField.setModifiers(4);
/* 292 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 297 */       OptimizedConstructorInvocations.addDispatch(this.jp, "dispatch", this.advisedCtor);
/* 298 */       if (this.params.length > 0)
/*     */       {
/* 300 */         addInvokeJoinPointDispatchMethod();
/*     */       }
/* 302 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinPointDispatchMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 309 */       String body = "{   " + this.advisedClass.getName() + " obj = new " + this.advisedClass.getName() + "($$);" + "   setTargetObject(obj);" + "   return obj;" + "}";
/*     */       try
/*     */       {
/* 318 */         CtMethod dispatch = CtNewMethod.make(this.advisedClass, "dispatch", this.params, this.advisedCtor.getExceptionTypes(), body, this.jp);
/*     */ 
/* 325 */         dispatch.setModifiers(4);
/* 326 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 330 */         throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 336 */       CtMethod template = ConstructorJoinPointGenerator.INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 338 */       String body = "{return dispatch();}";
/*     */ 
/* 340 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 347 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.ConstructorJoinPointGenerator
 * JD-Core Version:    0.6.0
 */