/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Constructor;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewConstructor;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.ConByConInfo;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.ConstructorCallByConstructor;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class ConByConJoinPointGenerator extends JoinPointGenerator
/*     */ {
/*     */   public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_CByC_";
/*     */   public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_CByC_";
/*  56 */   private static final Class JOINPOINT_TYPE = ConstructorCallByConstructor.class;
/*  57 */   private static final Class INVOCATION_TYPE = ConstructorCalledByConstructorInvocation.class;
/*     */   private static final CtClass INVOCATION_CT_TYPE;
/*     */   private WeakReference<Class<?>> returnType;
/*     */ 
/*     */   public ConByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info)
/*     */   {
/*  75 */     super(advisor, info, JoinPointGenerator.JoinPointParameters.CALLER_ARGS, ((ConByConInfo)info).getConstructor().getParameterTypes().length, false);
/*     */ 
/*  78 */     this.returnType = new WeakReference(((ConByConInfo)info).getCalledClass());
/*     */   }
/*     */ 
/*     */   protected void initialiseJoinPointNames(JoinPointInfo info)
/*     */   {
/*  83 */     ConByConInfo cinfo = (ConByConInfo)info;
/*  84 */     this.joinpointClassName = getGeneratedJoinPointClassName(callingIndex(cinfo), calledClass(cinfo), calledConHash(cinfo));
/*     */ 
/*  89 */     this.joinpointFieldName = getGeneratedJoinPointFieldName(callingIndex(cinfo), calledClass(cinfo), calledConHash(cinfo));
/*     */   }
/*     */ 
/*     */   private int callingIndex(ConByConInfo info)
/*     */   {
/*  98 */     return info.getCallingIndex();
/*     */   }
/*     */ 
/*     */   private String calledClass(ConByConInfo info)
/*     */   {
/* 103 */     return info.getCalledClass().getName();
/*     */   }
/*     */ 
/*     */   private long calledConHash(ConByConInfo info)
/*     */   {
/* 108 */     return info.getCalledConHash();
/*     */   }
/*     */ 
/*     */   protected boolean isVoid()
/*     */   {
/* 114 */     return false;
/*     */   }
/*     */ 
/*     */   protected Class getReturnClassType()
/*     */   {
/* 119 */     return (Class)this.returnType.get();
/*     */   }
/*     */ 
/*     */   protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup)
/*     */   {
/* 124 */     ConstructorCallByConstructor call = (ConstructorCallByConstructor)joinPoint;
/* 125 */     Constructor ctor = call.getConstructor();
/* 126 */     AdviceMethodProperties properties = new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getGenericParameterTypes(), ctor.getParameterTypes(), ctor.getGenericExceptionTypes(), call.getCalledClass(), false, call.getCallingClass(), true);
/*     */ 
/* 139 */     return properties;
/*     */   }
/*     */ 
/*     */   protected boolean isCaller()
/*     */   {
/* 144 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean hasCallingObject()
/*     */   {
/* 149 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean hasTargetObject()
/*     */   {
/* 154 */     return false;
/*     */   }
/*     */ 
/*     */   protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 160 */     super.overrideDispatchMethods(superClass, clazz, (ConByConInfo)newInfo);
/*     */   }
/*     */ 
/*     */   protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtConstructor targetCtor, String classname, long calledHash, String ciname)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 172 */     BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetCtor, calledHash, ciname);
/* 173 */     return generator.generate();
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointClassName(int callingIndex, String classname, long calledHash)
/*     */   {
/* 178 */     return "JoinPoint_CByC_" + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
/*     */   }
/*     */ 
/*     */   protected static String getGeneratedJoinPointFieldName(int callingIndex, String classname, long calledHash)
/*     */   {
/* 183 */     return "joinpoint_CByC_" + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  63 */       INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*  67 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class BaseClassGenerator
/*     */   {
/*     */     GeneratedAdvisorInstrumentor instrumentor;
/*     */     CtClass callingClass;
/*     */     int callingIndex;
/*     */     CtField callingField;
/*     */     String classname;
/*     */     CtClass targetClass;
/*     */     CtConstructor targetCtor;
/*     */     long calledHash;
/*     */     String ciname;
/*     */     CtClass jp;
/*     */     CtClass[] params;
/*     */     CtClass constructorInfoClass;
/*     */ 
/*     */     BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtConstructor targetCtor, long calledHash, String ciname)
/*     */       throws NotFoundException
/*     */     {
/* 211 */       this.instrumentor = instrumentor;
/* 212 */       this.callingClass = callingClass;
/* 213 */       this.callingIndex = callingIndex;
/* 214 */       this.classname = classname;
/* 215 */       this.targetClass = instrumentor.forName(classname);
/* 216 */       this.targetCtor = targetCtor;
/* 217 */       this.calledHash = calledHash;
/* 218 */       this.ciname = ciname;
/* 219 */       this.params = targetCtor.getParameterTypes();
/* 220 */       this.constructorInfoClass = instrumentor.forName(CallerTransformer.CON_BY_CON_INFO_CLASS_NAME);
/*     */     }
/*     */ 
/*     */     protected CtClass generate() throws CannotCompileException, NotFoundException
/*     */     {
/* 225 */       this.jp = setupClass();
/* 226 */       OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
/*     */ 
/* 228 */       addTypedCallingField();
/* 229 */       addInvokeJoinpointMethod();
/* 230 */       addMethodInfoField();
/* 231 */       addPublicConstructor();
/* 232 */       addProtectedConstructors();
/* 233 */       addDispatchMethods();
/*     */ 
/* 235 */       TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
/* 236 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private CtClass setupClass()
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 242 */       String className = ConByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
/*     */ 
/* 245 */       this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true, 9, ConByConJoinPointGenerator.INVOCATION_CT_TYPE);
/* 246 */       JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
/* 247 */       return this.jp;
/*     */     }
/*     */ 
/*     */     private void addTypedCallingField() throws CannotCompileException
/*     */     {
/* 252 */       this.callingField = new CtField(this.callingClass, "typedCallingObject", this.jp);
/* 253 */       this.jp.addField(this.callingField);
/* 254 */       this.callingField.setModifiers(4);
/*     */     }
/*     */ 
/*     */     private void addPublicConstructor()
/*     */       throws CannotCompileException
/*     */     {
/* 264 */       CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[] { this.constructorInfoClass }, new CtClass[0], "{super($1, null, $1.getInterceptors()); this.info = $1;}", this.jp);
/*     */ 
/* 269 */       this.jp.addConstructor(publicConstructor);
/*     */     }
/*     */ 
/*     */     protected void addProtectedConstructors()
/*     */       throws CannotCompileException
/*     */     {
/* 278 */       CtClass[] ctorParams1 = new CtClass[this.params.length + 2];
/* 279 */       CtClass[] ctorParams2 = new CtClass[2];
/*     */       CtClass tmp24_21 = this.jp; ctorParams2[0] = tmp24_21; ctorParams1[0] = tmp24_21;
/*     */       CtClass tmp35_32 = this.callingClass; ctorParams2[1] = tmp35_32; ctorParams1[1] = tmp35_32;
/* 282 */       System.arraycopy(this.params, 0, ctorParams1, 2, this.params.length);
/*     */ 
/* 284 */       StringBuffer body = new StringBuffer();
/* 285 */       body.append("{");
/* 286 */       body.append("   this($1.info);");
/* 287 */       body.append("   super.").append("callingObject").append("=$2;");
/* 288 */       body.append("   this.").append(this.callingField.getName()).append("=$2;");
/*     */ 
/* 290 */       StringBuffer setArguments = new StringBuffer();
/* 291 */       int offset = 2;
/* 292 */       for (int i = offset; i < ctorParams1.length; i++)
/*     */       {
/* 294 */         setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
/*     */       }
/* 296 */       setArguments.append("}");
/*     */ 
/* 298 */       CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
/*     */ 
/* 303 */       protectedConstructor.setModifiers(4);
/* 304 */       this.jp.addConstructor(protectedConstructor);
/* 305 */       if (this.params.length > 0)
/*     */       {
/* 307 */         protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
/*     */ 
/* 312 */         protectedConstructor.setModifiers(4);
/* 313 */         this.jp.addConstructor(protectedConstructor);
/*     */       }
/*     */     }
/*     */ 
/*     */     private CtClass[] getInvokeJoinPointParameters()
/*     */     {
/* 319 */       CtClass[] invokeParams = new CtClass[this.params.length + 1];
/* 320 */       invokeParams[0] = this.callingClass;
/* 321 */       System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
/* 322 */       return invokeParams;
/*     */     }
/*     */ 
/*     */     private CtMethod addInvokeJoinpointMethod()
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 331 */       CtMethod invokeJoinpointMethod = CtNewMethod.make(this.targetClass, "invokeJoinpoint", getInvokeJoinPointParameters(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
/*     */ 
/* 338 */       invokeJoinpointMethod.setModifiers(4);
/* 339 */       this.jp.addMethod(invokeJoinpointMethod);
/* 340 */       return invokeJoinpointMethod;
/*     */     }
/*     */ 
/*     */     private void addMethodInfoField() throws CannotCompileException
/*     */     {
/* 345 */       CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
/* 346 */       infoField.setModifiers(4);
/* 347 */       this.jp.addField(infoField);
/*     */     }
/*     */ 
/*     */     private void addDispatchMethods() throws CannotCompileException, NotFoundException
/*     */     {
/* 352 */       OptimizedConstructorInvocations.addDispatch(this.jp, "dispatch", this.targetCtor);
/* 353 */       addInvokeJoinpointDispatchMethod();
/* 354 */       addInvokeTargetMethod();
/*     */     }
/*     */ 
/*     */     private void addInvokeJoinpointDispatchMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 359 */       int offset = 1;
/* 360 */       StringBuffer parameters = new StringBuffer();
/* 361 */       for (int i = 0; i < this.params.length; i++)
/*     */       {
/* 363 */         if (i > 0) parameters.append(", ");
/* 364 */         parameters.append("$" + (i + 1 + 1));
/*     */       }
/*     */ 
/* 367 */       String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + "(" + parameters.toString() + ");" + "   setTargetObject(obj);" + "   return obj;" + "}";
/*     */       try
/*     */       {
/* 377 */         CtMethod dispatch = CtNewMethod.make(this.targetClass, "dispatch", getInvokeJoinPointParameters(), this.targetCtor.getExceptionTypes(), body, this.jp);
/*     */ 
/* 384 */         dispatch.setModifiers(4);
/* 385 */         this.jp.addMethod(dispatch);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 389 */         throw new RuntimeException("Could not compile code " + body + " for dispatch method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException
/*     */     {
/* 395 */       CtMethod template = ConByConJoinPointGenerator.INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
/*     */ 
/* 397 */       String body = "{return dispatch();}";
/*     */ 
/* 399 */       CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
/*     */ 
/* 406 */       this.jp.addMethod(invokeTarget);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.ConByConJoinPointGenerator
 * JD-Core Version:    0.6.0
 */