/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.CtMethod;
/*    */ 
/*    */ public class Codifier
/*    */ {
/*    */   private Collection pendingCodes;
/*    */ 
/*    */   public Codifier()
/*    */   {
/* 46 */     this.pendingCodes = new ArrayList();
/*    */   }
/*    */ 
/*    */   public synchronized void addPendingCode(CtMethod method, String body)
/*    */   {
/* 56 */     PendingCode pendingCode = new PendingCode(method, body);
/* 57 */     this.pendingCodes.add(pendingCode);
/*    */   }
/*    */ 
/*    */   public synchronized void codifyPending()
/*    */     throws CannotCompileException
/*    */   {
/* 69 */     for (Iterator iterator = this.pendingCodes.iterator(); iterator.hasNext(); )
/*    */     {
/* 71 */       PendingCode pendingCode = (PendingCode)iterator.next();
/* 72 */       pendingCode.method.setBody(pendingCode.body);
/*    */     }
/* 74 */     this.pendingCodes.clear();
/*    */   }
/*    */ 
/*    */   private class PendingCode
/*    */   {
/*    */     CtMethod method;
/*    */     String body;
/*    */ 
/*    */     public PendingCode(CtMethod method, String body)
/*    */     {
/* 87 */       this.method = method;
/* 88 */       this.body = body;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.Codifier
 * JD-Core Version:    0.6.0
 */