/*    */ package org.jboss.aop.expressions;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.util.regex.Matcher;
/*    */ import java.util.regex.Pattern;
/*    */ import javassist.CtClass;
/*    */ import javassist.CtConstructor;
/*    */ import javassist.NotFoundException;
/*    */ 
/*    */ public class ConstructorExpression
/*    */ {
/* 40 */   protected static final Pattern PATTERN = Pattern.compile("(.*)\\((.*)\\)");
/*    */   public String originalExpression;
/*    */   public ParameterExpression params;
/*    */   public Pattern classExpr;
/*    */   public String className;
/*    */ 
/*    */   public ConstructorExpression(String ex)
/*    */   {
/* 48 */     Matcher m = PATTERN.matcher(ex);
/* 49 */     if (!m.matches()) throw new IllegalStateException("ConstructorExpression is invalid: " + ex);
/* 50 */     this.className = m.group(1);
/* 51 */     this.params = new ParameterExpression(m.group(2));
/* 52 */     this.className = this.className.replaceAll("\\.", "\\\\.");
/* 53 */     this.className = this.className.replaceAll("\\*", ".*");
/* 54 */     this.classExpr = Pattern.compile(this.className);
/*    */   }
/*    */ 
/*    */   public boolean matches(Constructor con)
/*    */   {
/* 60 */     Matcher cm = this.classExpr.matcher(con.getDeclaringClass().getName());
/* 61 */     if (!cm.matches()) return false;
/*    */ 
/* 63 */     return this.params.matches(con.getParameterTypes());
/*    */   }
/*    */ 
/*    */   public boolean matchParamsOnly(Constructor con)
/*    */   {
/* 68 */     return this.params.matches(con.getParameterTypes());
/*    */   }
/*    */ 
/*    */   public boolean matchParamsOnly(CtConstructor con) throws NotFoundException
/*    */   {
/* 73 */     return this.params.matches(con.getParameterTypes());
/*    */   }
/*    */ 
/*    */   public boolean matches(CtConstructor con) throws NotFoundException
/*    */   {
/* 78 */     Matcher cm = this.classExpr.matcher(con.getDeclaringClass().getName());
/* 79 */     if (!cm.matches()) return false;
/*    */ 
/* 81 */     return this.params.matches(con.getParameterTypes());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.expressions.ConstructorExpression
 * JD-Core Version:    0.6.0
 */