/*     */ package org.jboss.aop.deployers;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import org.jboss.aop.AspectAnnotationLoader;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.aop.Domain;
/*     */ import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
/*     */ import org.jboss.aop.domain.DomainInitializer;
/*     */ import org.jboss.aop.domain.DomainInitializerCallback;
/*     */ import org.jboss.aop.domain.DomainInitializerCallbackHandler;
/*     */ import org.jboss.deployers.plugins.classloading.Module;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class AspectDeployer extends AbstractVFSRealDeployer
/*     */ {
/*     */   private static final String AOP_JAR_SUFFIX = ".aop";
/*     */   private static final String AOP_DD_SUFFIX = "-aop.xml";
/*     */   private AspectManager aspectManager;
/*     */ 
/*     */   public AspectDeployer()
/*     */   {
/*  74 */     setStage(DeploymentStages.POST_CLASSLOADER);
/*     */   }
/*     */ 
/*     */   public AspectManager getAspectManager()
/*     */   {
/*  84 */     return this.aspectManager;
/*     */   }
/*     */ 
/*     */   public void setAspectManager(AspectManager aspectManager)
/*     */   {
/*  94 */     this.aspectManager = aspectManager;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 102 */     if (this.aspectManager == null)
/* 103 */       throw new IllegalStateException("No aspect manager configured");
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit) throws DeploymentException
/*     */   {
/* 108 */     AspectManager manager = getCorrectManager(unit);
/*     */ 
/* 110 */     List files = unit.getMetaDataFiles(null, "-aop.xml");
/*     */ 
/* 112 */     if (isAopArchiveOrFolder(unit))
/*     */     {
/* 114 */       deployAnnotations(manager, unit);
/*     */     }
/*     */ 
/* 117 */     if (files.size() > 0)
/*     */     {
/* 119 */       deployXml(manager, unit, files);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit)
/*     */   {
/*     */     try
/*     */     {
/* 127 */       AspectManager manager = getCorrectManager(unit);
/* 128 */       List files = unit.getMetaDataFiles(null, "-aop.xml");
/*     */ 
/* 130 */       if (isAopArchiveOrFolder(unit))
/*     */       {
/* 132 */         undeployAnnotations(manager, unit);
/*     */       }
/*     */ 
/* 135 */       if (files.size() > 0)
/*     */       {
/* 137 */         undeployXml(manager, unit, files);
/*     */       }
/*     */ 
/* 142 */       if (unit.getTopLevel() == unit)
/*     */       {
/* 144 */         this.aspectManager.unregisterClassLoader(unit.getClassLoader());
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 142 */       if (unit.getTopLevel() == unit)
/*     */       {
/* 144 */         this.aspectManager.unregisterClassLoader(unit.getClassLoader());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployXml(AspectManager manager, VFSDeploymentUnit unit, List<VirtualFile> files) throws DeploymentException
/*     */   {
/* 151 */     this.log.info("Deploying xml into " + manager + " for " + unit.getClassLoader());
/*     */ 
/* 153 */     ArrayList deployedFiles = new ArrayList(files.size());
/* 154 */     for (VirtualFile vf : files)
/*     */     {
/* 156 */       deployedFiles.add(vf);
/*     */       try
/*     */       {
/* 159 */         this.log.debug("deploying: " + vf.toURL() + " into " + manager);
/* 160 */         InputStream is = vf.openStream();
/*     */         try
/*     */         {
/* 163 */           Document doc = AspectXmlLoader.loadDocument(is);
/* 164 */           AspectXmlLoader loader = new AspectXmlLoader();
/*     */ 
/* 166 */           loader.setManager(manager);
/* 167 */           loader.setClassLoader(unit.getClassLoader());
/* 168 */           loader.deployXML(doc, vf.toURL(), unit.getClassLoader());
/*     */         }
/*     */         finally
/*     */         {
/* 172 */           is.close();
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 178 */         for (int i = deployedFiles.size() - 1; i >= 0; i--)
/*     */         {
/* 180 */           undeployXml(manager, (VirtualFile)deployedFiles.get(i));
/*     */         }
/*     */ 
/* 183 */         throw DeploymentException.rethrowAsDeploymentException("Error deploying xml " + vf.getName() + " into " + manager, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeployXml(AspectManager manager, VFSDeploymentUnit unit, List<VirtualFile> files)
/*     */   {
/* 190 */     for (VirtualFile vf : files)
/*     */     {
/* 192 */       undeployXml(manager, vf);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeployXml(AspectManager manager, VirtualFile vf)
/*     */   {
/*     */     try
/*     */     {
/* 200 */       this.log.debug("undeploying: " + vf.toURL() + " from " + manager);
/* 201 */       InputStream is = vf.openStream();
/*     */       try
/*     */       {
/* 204 */         Document doc = AspectXmlLoader.loadDocument(is);
/* 205 */         AspectXmlLoader loader = new AspectXmlLoader();
/*     */ 
/* 207 */         loader.setManager(manager);
/* 208 */         loader.undeployXML(doc, vf.toURL());
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 214 */           is.close();
/*     */         }
/*     */         catch (IOException ignore)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 223 */       this.log.warn("Error undeploying xml " + vf.getName() + " from " + manager, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployAnnotations(AspectManager manager, VFSDeploymentUnit unit) throws DeploymentException
/*     */   {
/* 229 */     this.log.info("Deploying AOP annotations into " + manager + " for " + unit.getClassLoader());
/*     */ 
/* 231 */     AspectAnnotationLoader loader = getAnnotationLoader(manager, unit);
/* 232 */     List files = getClasses(unit);
/* 233 */     ArrayList deployedFiles = new ArrayList(files.size());
/* 234 */     for (VirtualFile file : files)
/*     */     {
/*     */       try
/*     */       {
/* 238 */         ClassFile cf = loadClassFile(file);
/* 239 */         this.log.debug("Deploying possibly annotated class " + cf.getName() + " into " + manager);
/* 240 */         loader.deployClassFile(cf);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 245 */         for (int i = deployedFiles.size(); i >= 0; i--)
/*     */         {
/* 247 */           undeployAnnotation(loader, (VirtualFile)deployedFiles.get(i));
/*     */         }
/* 249 */         throw new DeploymentException("Error reading annotations for " + file + " during deployment into " + manager, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeployAnnotations(AspectManager manager, VFSDeploymentUnit unit)
/*     */   {
/* 256 */     AspectAnnotationLoader loader = getAnnotationLoader(manager, unit);
/* 257 */     List files = getClasses(unit);
/* 258 */     for (VirtualFile file : files)
/*     */     {
/* 260 */       undeployAnnotation(loader, file);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeployAnnotation(AspectAnnotationLoader loader, VirtualFile file)
/*     */   {
/*     */     try
/*     */     {
/* 268 */       ClassFile cf = loadClassFile(file);
/* 269 */       this.log.debug("Undeploying possibly annotated class " + cf.getName());
/* 270 */       loader.undeployClassFile(cf);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 274 */       this.log.warn("Error reading annotations for " + file, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private AspectAnnotationLoader getAnnotationLoader(AspectManager manager, VFSDeploymentUnit unit)
/*     */   {
/* 280 */     AspectAnnotationLoader loader = new AspectAnnotationLoader(manager);
/* 281 */     loader.setClassLoader(unit.getClassLoader());
/* 282 */     return loader;
/*     */   }
/*     */ 
/*     */   private ClassFile loadClassFile(VirtualFile file)
/*     */   {
/* 287 */     DataInputStream din = null;
/* 288 */     ClassFile cf = null;
/*     */     try
/*     */     {
/* 291 */       InputStream in = file.openStream();
/* 292 */       din = new DataInputStream(new BufferedInputStream(in));
/* 293 */       cf = new ClassFile(din);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 297 */       throw new RuntimeException("Error reading " + file, e);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 303 */         din.close();
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 310 */     return cf;
/*     */   }
/*     */ 
/*     */   private List<VirtualFile> getClasses(VFSDeploymentUnit unit)
/*     */   {
/* 315 */     VisitorAttributes va = new VisitorAttributes();
/* 316 */     va.setLeavesOnly(true);
/* 317 */     ClassFileFilter filter = new ClassFileFilter(null);
/* 318 */     SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
/* 319 */     va.setRecurseFilter(noJars);
/* 320 */     FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
/*     */ 
/* 322 */     for (VirtualFile vf : unit.getClassPath())
/*     */     {
/*     */       try
/*     */       {
/* 326 */         vf.visit(visitor);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 330 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 333 */     return visitor.getMatched();
/*     */   }
/*     */ 
/*     */   private boolean isAopArchiveOrFolder(VFSDeploymentUnit unit)
/*     */   {
/* 339 */     String name = unit.getName();
/*     */ 
/* 342 */     int index = name.length();
/* 343 */     if (name.charAt(name.length() - 1) == '/')
/*     */     {
/* 345 */       index--;
/*     */     }
/* 347 */     if (name.charAt(name.length() - 2) == '!')
/*     */     {
/* 349 */       index--;
/*     */     }
/* 351 */     String realName = index == name.length() ? name : name.substring(0, index);
/*     */ 
/* 353 */     return realName.endsWith(".aop");
/*     */   }
/*     */ 
/*     */   private AspectManager getCorrectManager(VFSDeploymentUnit unit)
/*     */   {
/* 361 */     AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();
/*     */ 
/* 363 */     Domain domain = null;
/* 364 */     if (policy != null)
/*     */     {
/* 366 */       if (!(policy instanceof DomainInitializer))
/*     */       {
/* 368 */         throw new RuntimeException(policy + " must implement DomainInitializer");
/*     */       }
/* 370 */       DomainInitializer initializer = (DomainInitializer)policy;
/* 371 */       domain = initializer.initializeDomain(new DomainInitializerCallbackHandler(unit)
/*     */       {
/*     */         public void handle(DomainInitializerCallback[] callbacks) {
/* 374 */           for (DomainInitializerCallback callback : callbacks)
/*     */           {
/* 376 */             if (callback.getDataType() == Module.class)
/*     */             {
/* 378 */               callback.setValue(this.val$unit.getTopLevel().getAttachment(Module.class));
/*     */             }
/* 380 */             else if (callback.getDataType() == ClassLoader.class)
/*     */             {
/* 382 */               callback.setValue(this.val$unit.getClassLoader());
/*     */             }
/*     */             else
/*     */             {
/* 386 */               throw new RuntimeException("Invalid data type passed in by callback " + callback.getDataType());
/*     */             }
/*     */           }
/*     */         }
/*     */       });
/*     */     }
/*     */ 
/* 394 */     if (domain != null)
/*     */     {
/* 396 */       return domain;
/*     */     }
/*     */ 
/* 399 */     return this.aspectManager;
/*     */   }
/*     */ 
/*     */   private static class ClassFileFilter implements VirtualFileFilter
/*     */   {
/*     */     public boolean accepts(VirtualFile file)
/*     */     {
/*     */       try
/*     */       {
/* 408 */         return (file.isLeaf()) && (file.getName().endsWith(".class"));
/*     */       }
/*     */       catch (IOException e) {
/*     */       }
/* 412 */       throw new RuntimeException("Error visiting file: " + file.getName(), e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployers.AspectDeployer
 * JD-Core Version:    0.6.0
 */