/*    */ package org.jboss.aop.classpool;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   public static ClassLoader getParent(ClassLoader loader)
/*    */   {
/* 71 */     if (System.getSecurityManager() == null)
/*    */     {
/* 73 */       return GetParentAction.NON_PRIVILEGED.getParent(loader);
/*    */     }
/*    */ 
/* 77 */     return GetParentAction.PRIVILEGED.getParent(loader);
/*    */   }
/*    */ 
/*    */   static abstract interface GetParentAction
/*    */   {
/* 39 */     public static final GetParentAction NON_PRIVILEGED = new GetParentAction()
/*    */     {
/*    */       public ClassLoader getParent(ClassLoader loader)
/*    */       {
/* 43 */         return loader.getParent();
/*    */       }
/* 39 */     };
/*    */ 
/* 47 */     public static final GetParentAction PRIVILEGED = new GetParentAction()
/*    */     {
/*    */       public ClassLoader getParent(ClassLoader loader)
/*    */       {
/*    */         try
/*    */         {
/* 53 */           return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(loader)
/*    */           {
/*    */             public ClassLoader run() throws Exception
/*    */             {
/* 57 */               return this.val$loader.getParent();
/*    */             } } );
/*    */         }
/*    */         catch (PrivilegedActionException e) {
/*    */         }
/* 63 */         throw new RuntimeException(e.getException());
/*    */       }
/* 47 */     };
/*    */ 
/*    */     public abstract ClassLoader getParent(ClassLoader paramClassLoader);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.classpool.SecurityActions
 * JD-Core Version:    0.6.0
 */