/*    */ package org.jboss.aop.array;
/*    */ 
/*    */ import java.lang.ref.WeakReference;
/*    */ 
/*    */ public abstract class ArrayRegistryEntry
/*    */ {
/*    */   WeakReference owner;
/*    */   WeakReference array;
/*    */   boolean ownerIsRoot;
/*    */ 
/*    */   ArrayRegistryEntry(Object owner, boolean ownerIsRoot, Object array)
/*    */   {
/* 44 */     this.owner = new WeakReference(owner);
/* 45 */     this.array = new WeakReference(array);
/* 46 */     this.ownerIsRoot = ownerIsRoot;
/* 47 */     if ((ownerIsRoot) && (owner.getClass().isArray())) {
/* 48 */       throw new RuntimeException("Owner is root and an array was passed in");
/*    */     }
/* 50 */     if ((!ownerIsRoot) && (!owner.getClass().isArray()))
/* 51 */       throw new RuntimeException("Owner is not root and no array was passed in");
/*    */   }
/*    */ 
/*    */   public Object getArray()
/*    */   {
/* 57 */     if (this.array != null)
/*    */     {
/* 59 */       return this.array.get();
/*    */     }
/* 61 */     return null;
/*    */   }
/*    */ 
/*    */   public Object getOwner()
/*    */   {
/* 66 */     if (this.owner != null)
/*    */     {
/* 68 */       return this.owner.get();
/*    */     }
/* 70 */     return null;
/*    */   }
/*    */ 
/*    */   public boolean isOwnerRoot()
/*    */   {
/* 75 */     return this.ownerIsRoot;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayRegistryEntry
 * JD-Core Version:    0.6.0
 */