/*     */ package org.jboss.aop.advice.annotation.assignability;
/*     */ 
/*     */ import java.lang.reflect.GenericArrayType;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.lang.reflect.WildcardType;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ class VariableNode
/*     */ {
/*     */   private VariableHierarchy hierarchy;
/*     */   private VariableNode previous;
/*     */   private VariableNode next;
/*     */   private Collection<Type> lowerBounds;
/*     */   private Collection<Type> upperBounds;
/*     */   private TypeVariable variable;
/*     */   private Type assignedValue;
/* 506 */   private static ParamTypeAssignabilityAlgorithm.EqualityChecker<VariableNode, ?> CHECKER = new ParamTypeAssignabilityAlgorithm.EqualityChecker()
/*     */   {
/*     */     public boolean isSame(Type argument, Type fromArgument, VariableNode node, Object token)
/*     */     {
/* 512 */       return VariableNode.access$000(argument, fromArgument, false);
/*     */     }
/* 506 */   };
/*     */ 
/*     */   public VariableNode(TypeVariable content, VariableHierarchy hierarchy)
/*     */   {
/*  51 */     this.hierarchy = hierarchy;
/*  52 */     this.variable = content;
/*  53 */     this.lowerBounds = new HashSet();
/*  54 */     this.upperBounds = new HashSet();
/*  55 */     Type[] bounds = content.getBounds();
/*  56 */     if ((bounds.length == 1) && ((bounds[0] instanceof TypeVariable)))
/*     */     {
/*  58 */       TypeVariable typeVariable = (TypeVariable)bounds[0];
/*  59 */       this.next = hierarchy.getVariableNode(typeVariable);
/*  60 */       this.next.previous = this;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final boolean assignValue(Type value)
/*     */   {
/*  66 */     if (!isAssignabilityPermited(value))
/*     */     {
/*  68 */       return false;
/*     */     }
/*     */ 
/*  71 */     if (this.assignedValue != null)
/*     */     {
/*  73 */       return isSame(value, this.assignedValue, true);
/*     */     }
/*     */ 
/*  76 */     if ((!isInsideUpperBounds(value, false)) || (!areLowerBoundsInside(value, false)))
/*     */     {
/*  78 */       return false;
/*     */     }
/*  80 */     this.assignedValue = value;
/*  81 */     return true;
/*     */   }
/*     */ 
/*     */   public final boolean addLowerBound(Type lowerBound)
/*     */   {
/*  86 */     if ((!isInsideUpperBounds(lowerBound, false)) || ((this.previous != null) && (!this.previous.areLowerBoundsInside(lowerBound, true))))
/*     */     {
/*  89 */       return false;
/*     */     }
/*  91 */     if ((lowerBound instanceof TypeVariable))
/*     */     {
/*  93 */       Type[] bounds = ((TypeVariable)lowerBound).getBounds();
/*  94 */       this.lowerBounds.add(new ChoiceBound((TypeVariable)lowerBound, bounds));
/*     */     }
/*     */     else
/*     */     {
/*  98 */       this.lowerBounds.add(lowerBound);
/*     */     }
/* 100 */     return true;
/*     */   }
/*     */ 
/*     */   public final boolean addUpperBound(Type upperBound)
/*     */   {
/* 105 */     if (((this.next != null) && (!this.next.isInsideUpperBounds(upperBound, true))) || (!areLowerBoundsInside(upperBound, false)))
/*     */     {
/* 108 */       return false;
/*     */     }
/* 110 */     addToUpperBounds(upperBound);
/* 111 */     return true;
/*     */   }
/*     */ 
/*     */   private void addToUpperBounds(Type upperBound)
/*     */   {
/* 119 */     if ((upperBound instanceof TypeVariable))
/*     */     {
/* 121 */       Type[] bounds = ((TypeVariable)upperBound).getBounds();
/* 122 */       this.upperBounds.add(new ChoiceBound((TypeVariable)upperBound, bounds));
/*     */     }
/*     */     else
/*     */     {
/* 126 */       this.upperBounds.add(upperBound);
/*     */     }
/*     */   }
/*     */ 
/*     */   public final boolean addMaximumUpperBound(Type upperBound)
/*     */   {
/* 132 */     if (!isAssignabilityPermited(upperBound))
/*     */     {
/* 134 */       return false;
/*     */     }
/* 136 */     for (Type oldUpperBound : this.upperBounds)
/*     */     {
/* 138 */       if (!isAssignable(upperBound, oldUpperBound))
/*     */       {
/* 140 */         return false;
/*     */       }
/*     */     }
/* 143 */     for (Type oldLowerBound : this.lowerBounds)
/*     */     {
/* 145 */       if (!isAssignable(upperBound, oldLowerBound))
/*     */       {
/* 147 */         return false;
/*     */       }
/*     */     }
/* 150 */     if ((this.assignedValue != null) && (!isAssignable(upperBound, this.assignedValue)))
/*     */     {
/* 152 */       return false;
/*     */     }
/* 154 */     if (this.next != null)
/*     */     {
/* 156 */       return this.next.addMaximumUpperBound(upperBound);
/*     */     }
/* 158 */     Type[] bounds = this.variable.getBounds();
/* 159 */     if ((bounds.length == 1) && (bounds[0] == Object.class))
/*     */     {
/* 161 */       return true;
/*     */     }
/*     */ 
/* 165 */     for (Type bound : bounds)
/*     */     {
/* 167 */       if (!isAssignable(upperBound, bound))
/*     */       {
/* 169 */         return false;
/*     */       }
/*     */     }
/* 172 */     return true;
/*     */   }
/*     */ 
/*     */   private boolean isAssignabilityPermited(Type value)
/*     */   {
/* 179 */     return ((!this.hierarchy.isBoundComparation()) || ((value instanceof Class)) || ((value instanceof ParameterizedType))) && ((!this.hierarchy.isRealBoundComparation()) || (!(value instanceof WildcardType)));
/*     */   }
/*     */ 
/*     */   private boolean areLowerBoundsInside(Type bound, boolean checkUpperBounds)
/*     */   {
/* 189 */     if ((this.assignedValue != null) && (!isAssignable(bound, this.assignedValue)))
/*     */     {
/* 191 */       return false;
/*     */     }
/* 193 */     if (checkUpperBounds)
/*     */     {
/* 195 */       for (Type upperBound : this.upperBounds)
/*     */       {
/* 197 */         if (!isAssignable(bound, upperBound))
/*     */         {
/* 199 */           return false;
/*     */         }
/*     */       }
/*     */     }
/* 203 */     for (Type lowerBound : this.lowerBounds)
/*     */     {
/* 205 */       if (!isAssignable(bound, lowerBound))
/*     */       {
/* 207 */         return false;
/*     */       }
/*     */     }
/* 210 */     if (this.previous != null)
/*     */     {
/* 212 */       return this.previous.areLowerBoundsInside(bound, true);
/*     */     }
/* 214 */     return true;
/*     */   }
/*     */ 
/*     */   private boolean isInsideUpperBounds(Type lowerBound, boolean checkLowerBounds)
/*     */   {
/* 219 */     if ((this.assignedValue != null) && (!isAssignable(lowerBound, this.assignedValue)))
/*     */     {
/* 221 */       return false;
/*     */     }
/* 223 */     if (checkLowerBounds)
/*     */     {
/* 225 */       for (Type bound : this.lowerBounds)
/*     */       {
/* 227 */         if (!isAssignable(bound, lowerBound))
/*     */         {
/* 229 */           return false;
/*     */         }
/*     */       }
/*     */     }
/* 233 */     for (Type upperBound : this.upperBounds)
/*     */     {
/* 235 */       if (!isAssignable(upperBound, lowerBound))
/*     */       {
/* 237 */         return false;
/*     */       }
/*     */     }
/* 240 */     if (this.next == null)
/*     */     {
/* 242 */       Type[] bounds = this.variable.getBounds();
/* 243 */       this.hierarchy.startBoundComparation();
/*     */       try
/*     */       {
/* 246 */         for (int i = 0; i < bounds.length; i++)
/*     */         {
/* 248 */           if (AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(bounds[i], lowerBound, this.hierarchy))
/*     */             continue;
/* 250 */           int i = 0;
/*     */           return i;
/*     */         } } finally { this.hierarchy.finishBoundComparation();
/*     */       }
/* 258 */       return true;
/*     */     }
/* 260 */     return this.next.isInsideUpperBounds(lowerBound, true);
/*     */   }
/*     */ 
/*     */   private static boolean isSame(Type argument, Type fromArgument, boolean argumentAssigned)
/*     */   {
/* 265 */     if ((argument instanceof WildcardType))
/*     */     {
/* 267 */       WildcardType wildcard = (WildcardType)argument;
/* 268 */       Type[] upperBounds = wildcard.getUpperBounds();
/* 269 */       Type[] lowerBounds = wildcard.getLowerBounds();
/* 270 */       if ((fromArgument instanceof WildcardType))
/*     */       {
/* 272 */         WildcardType fromWildcard = (WildcardType)fromArgument;
/* 273 */         Type[] fromUpperBounds = fromWildcard.getUpperBounds();
/* 274 */         if (!isAssignable(upperBounds, fromUpperBounds))
/*     */         {
/* 276 */           return false;
/*     */         }
/*     */ 
/* 279 */         Type[] fromLowerBounds = fromWildcard.getLowerBounds();
/* 280 */         for (int i = 0; i < fromLowerBounds.length; i++)
/*     */         {
/* 282 */           int j = 0;
/*     */           while (true) if (j < lowerBounds.length)
/*     */             {
/* 284 */               if (isAssignable(fromLowerBounds[i], lowerBounds[j]))
/*     */                 break;
/* 282 */               j++; continue;
/*     */             }
/*     */             else
/*     */             {
/* 289 */               return false;
/*     */             } 
/*     */         }
/* 291 */         return true;
/*     */       }
/* 293 */       if (argumentAssigned)
/*     */       {
/* 295 */         return false;
/*     */       }
/* 297 */       if ((fromArgument instanceof TypeVariable))
/*     */       {
/* 299 */         if (!isAssignable(upperBounds, ((TypeVariable)fromArgument).getBounds()))
/*     */         {
/* 301 */           return false;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 306 */         for (int i = 0; i < upperBounds.length; i++)
/*     */         {
/* 308 */           if (!isAssignable(upperBounds[i], fromArgument))
/*     */           {
/* 310 */             return false;
/*     */           }
/*     */         }
/* 313 */         return true;
/*     */       }
/*     */     }
/* 316 */     else if ((argument instanceof GenericArrayType))
/*     */     {
/* 318 */       if ((fromArgument instanceof GenericArrayType))
/*     */       {
/* 320 */         return isSame(((GenericArrayType)argument).getGenericComponentType(), ((GenericArrayType)fromArgument).getGenericComponentType(), argumentAssigned);
/*     */       }
/*     */ 
/* 326 */       return false;
/*     */     }
/*     */ 
/* 329 */     return argument.equals(fromArgument);
/*     */   }
/*     */ 
/*     */   private static boolean isAssignable(Type[] upperBounds, Type[] fromUpperBounds)
/*     */   {
/* 334 */     for (int i = 0; i < upperBounds.length; i++)
/*     */     {
/* 336 */       int j = 0;
/*     */       while (true) if (j < fromUpperBounds.length)
/*     */         {
/* 338 */           if (isAssignable(upperBounds[i], fromUpperBounds[j]))
/*     */             break;
/* 336 */           j++; continue;
/*     */         }
/*     */         else
/*     */         {
/* 343 */           return false;
/*     */         } 
/*     */     }
/* 345 */     return true;
/*     */   }
/*     */ 
/*     */   private static boolean isAssignable(Type type, Type fromType)
/*     */   {
/* 351 */     if ((fromType instanceof TypeVariable))
/*     */     {
/* 353 */       TypeVariable fromVariable = (TypeVariable)fromType;
/* 354 */       if ((type instanceof TypeVariable))
/*     */       {
/* 356 */         if (type == fromType)
/*     */         {
/* 358 */           return true;
/*     */         }
/* 360 */         Type[] fromBounds = fromVariable.getBounds();
/* 361 */         while ((fromBounds.length == 1) && ((fromBounds[0] instanceof TypeVariable)))
/*     */         {
/* 363 */           if (fromBounds[0] == type)
/*     */           {
/* 365 */             return true;
/*     */           }
/* 367 */           fromVariable = (TypeVariable)fromBounds[0];
/* 368 */           fromBounds = fromVariable.getBounds();
/*     */         }
/* 370 */         return false;
/*     */       }
/* 372 */       Type[] fromBounds = AssignabilityAlgorithm.getConcreteBounds(fromVariable);
/* 373 */       for (Type fromBound : fromBounds)
/*     */       {
/* 375 */         if (isAssignable(type, fromBound))
/*     */         {
/* 377 */           return true;
/*     */         }
/*     */       }
/* 380 */       return false;
/*     */     }
/* 382 */     if ((fromType instanceof ChoiceBound))
/*     */     {
/* 384 */       ChoiceBound fromChoiceBound = (ChoiceBound)fromType;
/* 385 */       if (((type instanceof TypeVariable)) && (!isAssignable((TypeVariable)type, fromChoiceBound.variable)))
/*     */       {
/* 388 */         return false;
/*     */       }
/* 390 */       for (Iterator it = fromChoiceBound.bounds.iterator(); it.hasNext(); )
/*     */       {
/* 392 */         Type fromOption = (Type)it.next();
/* 393 */         if (!isAssignable(type, fromOption))
/*     */         {
/* 395 */           it.remove();
/*     */         }
/*     */       }
/* 398 */       return !fromChoiceBound.bounds.isEmpty();
/*     */     }
/* 400 */     if ((type instanceof Class))
/*     */     {
/* 402 */       if (type == Object.class)
/*     */       {
/* 404 */         return true;
/*     */       }
/* 406 */       Class clazz = (Class)type;
/* 407 */       if ((fromType instanceof Class))
/*     */       {
/* 409 */         return clazz.isAssignableFrom((Class)fromType);
/*     */       }
/* 411 */       if ((fromType instanceof ParameterizedType))
/*     */       {
/* 413 */         return clazz.isAssignableFrom((Class)((ParameterizedType)fromType).getRawType());
/*     */       }
/* 415 */       if ((fromType instanceof WildcardType))
/*     */       {
/* 417 */         WildcardType fromWildcard = (WildcardType)fromType;
/* 418 */         boolean boundOk = false;
/* 419 */         for (Type upperBound : fromWildcard.getUpperBounds())
/*     */         {
/* 421 */           if (!isAssignable(type, upperBound))
/*     */             continue;
/* 423 */           boundOk = true;
/* 424 */           break;
/*     */         }
/*     */ 
/* 427 */         if (!boundOk)
/*     */         {
/* 429 */           return false;
/*     */         }
/* 431 */         for (Type lowerBound : fromWildcard.getLowerBounds())
/*     */         {
/* 433 */           if (isAssignable(type, lowerBound))
/*     */           {
/* 435 */             return true;
/*     */           }
/*     */         }
/* 438 */         return false;
/*     */       }
/* 440 */       if ((fromType instanceof TypeVariable))
/*     */       {
/* 442 */         for (Type upperBound : ((TypeVariable)fromType).getBounds())
/*     */         {
/* 444 */           if (isAssignable(type, upperBound))
/*     */           {
/* 446 */             return true;
/*     */           }
/*     */         }
/* 449 */         return false;
/*     */       }
/* 451 */       return (clazz.isArray()) && (isAssignable(clazz.getComponentType(), ((GenericArrayType)fromType).getGenericComponentType()));
/*     */     }
/*     */ 
/* 454 */     if ((type instanceof ParameterizedType))
/*     */     {
/* 456 */       return ParamTypeAssignabilityAlgorithm.isAssignable((ParameterizedType)type, fromType, CHECKER, null, null);
/*     */     }
/*     */ 
/* 459 */     if ((type instanceof TypeVariable))
/*     */     {
/* 461 */       for (Type bound : ((TypeVariable)type).getBounds())
/*     */       {
/* 463 */         if (!isAssignable(bound, fromType))
/*     */         {
/* 465 */           return false;
/*     */         }
/*     */       }
/* 468 */       return true;
/*     */     }
/* 470 */     if ((type instanceof WildcardType))
/*     */     {
/* 472 */       WildcardType wildcard = (WildcardType)type;
/* 473 */       for (Type bound : wildcard.getUpperBounds())
/*     */       {
/* 475 */         if (!isAssignable(bound, fromType))
/*     */         {
/* 477 */           return false;
/*     */         }
/*     */       }
/* 480 */       for (Type bound : wildcard.getLowerBounds())
/*     */       {
/* 482 */         if (!isAssignable(bound, fromType))
/*     */         {
/* 484 */           return false;
/*     */         }
/*     */       }
/* 487 */       return true;
/*     */     }
/* 489 */     ChoiceBound choiceBound = (ChoiceBound)type;
/* 490 */     if (((fromType instanceof TypeVariable)) && (!isAssignable(choiceBound.variable, (TypeVariable)fromType)))
/*     */     {
/* 493 */       return false;
/*     */     }
/* 495 */     for (Iterator it = choiceBound.bounds.iterator(); it.hasNext(); )
/*     */     {
/* 497 */       Type boundOption = (Type)it.next();
/* 498 */       if (!isAssignable(boundOption, fromType))
/*     */       {
/* 500 */         it.remove();
/*     */       }
/*     */     }
/* 503 */     return !choiceBound.bounds.isEmpty();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.VariableNode
 * JD-Core Version:    0.6.0
 */