/*     */ package org.jboss.aop.advice.annotation.assignability;
/*     */ 
/*     */ import java.lang.reflect.GenericArrayType;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.util.ArrayList;
/*     */ 
/*     */ public class DegreeAlgorithm
/*     */ {
/*     */   public static final short NOT_ASSIGNABLE_DEGREE = 32767;
/*     */   public static final short MAX_DEGREE = 32766;
/*  41 */   private static final DegreeAlgorithm INSTANCE = new DegreeAlgorithm();
/*     */ 
/*     */   public static DegreeAlgorithm getInstance()
/*     */   {
/*  45 */     return INSTANCE;
/*     */   }
/*     */ 
/*     */   public short getAssignabilityDegree(Type type, Type fromType)
/*     */   {
/*  52 */     if ((type == null) || (fromType == null))
/*     */     {
/*  54 */       return 32766;
/*     */     }
/*  56 */     Class clazz = getClassType(type);
/*  57 */     if (clazz == null)
/*     */     {
/*  59 */       return 32766;
/*     */     }
/*  61 */     Class fromClass = getClassType(fromType);
/*  62 */     if (fromClass == null)
/*     */     {
/*  64 */       return 32766;
/*     */     }
/*  66 */     return getAssignabilityDegree(fromClass, clazz);
/*     */   }
/*     */ 
/*     */   private Class<?> getClassType(Type type)
/*     */   {
/*  71 */     if ((type instanceof Class))
/*     */     {
/*  73 */       return (Class)type;
/*     */     }
/*  75 */     if ((type instanceof ParameterizedType))
/*     */     {
/*  77 */       return (Class)((ParameterizedType)type).getRawType();
/*     */     }
/*  79 */     if ((type instanceof TypeVariable))
/*     */     {
/*  81 */       return null;
/*     */     }
/*  83 */     Type componentType = ((GenericArrayType)type).getGenericComponentType();
/*  84 */     Class componentClass = getClassType(componentType);
/*     */     try
/*     */     {
/*  87 */       return componentClass.getClassLoader().loadClass(componentClass.getName() + "[]");
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*     */     }
/*  92 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private short getAssignabilityDegree(Class<?> fromType, Class<?> toType)
/*     */   {
/* 117 */     if (fromType == toType)
/*     */     {
/* 119 */       return 0;
/*     */     }
/* 121 */     if (toType.isInterface())
/*     */     {
/* 123 */       if (fromType.isInterface())
/*     */       {
/* 126 */         return getInterfaceInheritanceAD(fromType, toType, 0);
/*     */       }
/*     */ 
/* 131 */       return getImplementationAD(fromType, toType);
/*     */     }
/*     */ 
/* 134 */     if (fromType.isInterface())
/*     */     {
/* 137 */       if (toType.getName() == "java.lang.Object")
/*     */       {
/* 139 */         ArrayList list1 = new ArrayList();
/* 140 */         ArrayList list2 = new ArrayList();
/* 141 */         Class[] fromTypeInterfaces = fromType.getInterfaces();
/* 142 */         if (fromTypeInterfaces.length == 0)
/*     */         {
/* 144 */           return 1;
/*     */         }
/* 146 */         list1.add(fromTypeInterfaces);
/* 147 */         short degree = 2;
/*     */         while (true)
/*     */         {
/* 150 */           for (Class[] interfaces : list1)
/*     */           {
/* 152 */             for (int i = 0; i < interfaces.length; i++)
/*     */             {
/* 154 */               Class[] superInterfaces = interfaces[i].getInterfaces();
/* 155 */               if (superInterfaces.length == 0)
/*     */               {
/* 157 */                 return degree;
/*     */               }
/* 159 */               list2.add(superInterfaces);
/*     */             }
/*     */           }
/* 162 */           degree = (short)(degree + 1);
/* 163 */           list1.clear();
/* 164 */           ArrayList temp = list1;
/* 165 */           list1 = list2;
/* 166 */           list2 = temp;
/*     */         }
/*     */       }
/*     */ 
/* 170 */       return 32767;
/*     */     }
/*     */ 
/* 173 */     return getClassInheritanceAD(fromType.getSuperclass(), toType, 1);
/*     */   }
/*     */ 
/*     */   private short getImplementationAD(Class<?> fromClassType, Class<?> toInterfaceType)
/*     */   {
/* 193 */     if (fromClassType == null)
/*     */     {
/* 195 */       return 32767;
/*     */     }
/*     */ 
/* 198 */     Class[] interfaces = fromClassType.getInterfaces();
/* 199 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 201 */       if (interfaces[i] == toInterfaceType)
/*     */       {
/* 203 */         return 1;
/*     */       }
/*     */     }
/* 206 */     short currentDegree = 32767;
/* 207 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 209 */       currentDegree = (short)Math.min(getInterfaceInheritanceAD(interfaces[i], toInterfaceType, 1), currentDegree);
/*     */     }
/*     */ 
/* 212 */     if (currentDegree == 32767)
/*     */     {
/* 214 */       return getImplementationAD(fromClassType.getSuperclass(), toInterfaceType);
/*     */     }
/* 216 */     return currentDegree;
/*     */   }
/*     */ 
/*     */   private short getInterfaceInheritanceAD(Class<?> fromInterfaceType, Class<?> toInterfaceType, short currentDegree)
/*     */   {
/* 238 */     Class[] interfaces = fromInterfaceType.getInterfaces();
/* 239 */     currentDegree = (short)(currentDegree + 1);
/* 240 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 242 */       if (interfaces[i] == toInterfaceType)
/*     */       {
/* 244 */         return currentDegree;
/*     */       }
/*     */     }
/* 247 */     short bestDegree = 32767;
/* 248 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 250 */       bestDegree = (short)Math.min(getInterfaceInheritanceAD(interfaces[i], toInterfaceType, currentDegree), bestDegree);
/*     */     }
/*     */ 
/* 253 */     return bestDegree;
/*     */   }
/*     */ 
/*     */   private short getClassInheritanceAD(Class<?> fromClassType, Class<?> toClassType, short currentDegree)
/*     */   {
/* 274 */     if (fromClassType == null)
/*     */     {
/* 276 */       return 32767;
/*     */     }
/* 278 */     if (fromClassType == toClassType)
/*     */     {
/* 280 */       return currentDegree;
/*     */     }
/* 282 */     currentDegree = (short)(currentDegree + 1); return getClassInheritanceAD(fromClassType.getSuperclass(), toClassType, currentDegree);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.DegreeAlgorithm
 * JD-Core Version:    0.6.0
 */