/*     */ package org.jboss.aop.advice.annotation.assignability;
/*     */ 
/*     */ import java.lang.reflect.GenericArrayType;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.lang.reflect.WildcardType;
/*     */ 
/*     */ public enum AssignabilityAlgorithm
/*     */ {
/*  37 */   VARIABLE_TARGET, 
/*     */ 
/*  63 */   FROM_VARIABLE;
/*     */ 
/*     */   private static final ParamTypeAssignabilityAlgorithm.EqualityChecker<AssignabilityAlgorithm, VariableHierarchy> CHECKER;
/*     */ 
/*     */   protected abstract AssignabilityAlgorithm getInverseAlgorithm();
/*     */ 
/*     */   protected abstract boolean isVariableOperationApplicable(Type paramType1, Type paramType2);
/*     */ 
/*     */   protected abstract boolean assignValue(Type paramType1, Type paramType2, VariableHierarchy paramVariableHierarchy);
/*     */ 
/*     */   protected abstract boolean addBound(Type paramType1, Type paramType2, VariableHierarchy paramVariableHierarchy);
/*     */ 
/*     */   public boolean isAssignable(Type type, Type fromType, VariableHierarchy variableHierarchy)
/*     */   {
/* 103 */     if ((fromType instanceof WildcardType))
/*     */     {
/* 105 */       return isAssignable(type, (WildcardType)fromType, variableHierarchy);
/*     */     }
/* 107 */     if (isVariableOperationApplicable(type, fromType))
/*     */     {
/* 109 */       return addBound(type, fromType, variableHierarchy);
/*     */     }
/* 111 */     if ((type instanceof Class))
/*     */     {
/* 113 */       return isAssignable((Class)type, fromType, variableHierarchy);
/*     */     }
/* 115 */     if ((type instanceof ParameterizedType))
/*     */     {
/* 117 */       return isAssignable((ParameterizedType)type, fromType, variableHierarchy);
/*     */     }
/* 119 */     if ((type instanceof WildcardType))
/*     */     {
/* 121 */       throw new RuntimeException("This comparison should never happen");
/*     */     }
/* 123 */     if ((type instanceof TypeVariable))
/*     */     {
/* 125 */       return false;
/*     */     }
/*     */ 
/* 129 */     return isAssignable((GenericArrayType)type, fromType, variableHierarchy);
/*     */   }
/*     */ 
/*     */   private boolean isAssignable(Type type, WildcardType fromWildcardType, VariableHierarchy variableHierarchy)
/*     */   {
/* 137 */     boolean boundOk = false;
/* 138 */     for (Type upperBound : fromWildcardType.getUpperBounds())
/*     */     {
/* 140 */       if (!isAssignable(type, upperBound, variableHierarchy))
/*     */         continue;
/* 142 */       boundOk = true;
/* 143 */       break;
/*     */     }
/*     */ 
/* 146 */     if (!boundOk)
/*     */     {
/* 148 */       return false;
/*     */     }
/* 150 */     for (Type lowerBound : fromWildcardType.getLowerBounds())
/*     */     {
/* 152 */       if (isAssignable(type, lowerBound, variableHierarchy))
/*     */       {
/* 154 */         return true;
/*     */       }
/*     */     }
/* 157 */     return fromWildcardType.getLowerBounds().length == 0;
/*     */   }
/*     */ 
/*     */   private boolean isAssignable(Class<?> classType, Type fromType, VariableHierarchy variableHierarchy)
/*     */   {
/* 164 */     if ((fromType instanceof Class))
/*     */     {
/* 166 */       return classType.isAssignableFrom((Class)fromType);
/*     */     }
/* 168 */     if ((fromType instanceof ParameterizedType))
/*     */     {
/* 170 */       return classType.isAssignableFrom((Class)((ParameterizedType)fromType).getRawType());
/*     */     }
/*     */ 
/* 173 */     if ((fromType instanceof TypeVariable))
/*     */     {
/* 175 */       Type[] bounds = getConcreteBounds(fromType);
/* 176 */       boolean inside = false;
/* 177 */       for (int i = 0; (i < bounds.length) && (!inside); i++)
/*     */       {
/* 179 */         if ((bounds[i] instanceof Class))
/*     */         {
/* 181 */           if (!classType.isAssignableFrom((Class)bounds[i]))
/*     */             continue;
/* 183 */           inside = true;
/*     */         }
/*     */         else
/*     */         {
/* 189 */           if (!classType.isAssignableFrom((Class)((ParameterizedType)bounds[i]).getRawType())) {
/*     */             continue;
/*     */           }
/* 192 */           inside = true;
/*     */         }
/*     */       }
/*     */ 
/* 196 */       return inside;
/*     */     }
/*     */ 
/* 200 */     if (classType == Object.class)
/*     */     {
/* 202 */       return true;
/*     */     }
/* 204 */     if (classType.isArray())
/*     */     {
/* 206 */       return isAssignable(classType.getComponentType(), ((GenericArrayType)fromType).getGenericComponentType(), variableHierarchy);
/*     */     }
/*     */ 
/* 210 */     return false;
/*     */   }
/*     */ 
/*     */   public static Type[] getConcreteBounds(Type type)
/*     */   {
/* 219 */     TypeVariable current = (TypeVariable)type;
/* 220 */     Type[] bounds = current.getBounds();
/* 221 */     while ((bounds.length == 1) && ((bounds[0] instanceof TypeVariable)))
/*     */     {
/* 223 */       current = (TypeVariable)bounds[0];
/* 224 */       bounds = current.getBounds();
/*     */     }
/* 226 */     return bounds;
/*     */   }
/*     */ 
/*     */   private boolean isAssignable(ParameterizedType paramType, Type fromType, VariableHierarchy variableHierarchy)
/*     */   {
/* 232 */     if ((fromType instanceof TypeVariable))
/*     */     {
/* 234 */       Type[] concreteBounds = getConcreteBounds((TypeVariable)fromType);
/*     */       try
/*     */       {
/* 237 */         variableHierarchy.startRealBoundComparation();
/* 238 */         for (int i = 0; i < concreteBounds.length; i++)
/*     */         {
/* 240 */           if (!isAssignable(paramType, concreteBounds[i], variableHierarchy))
/*     */             continue;
/* 242 */           int i = 1;
/*     */           return i;
/*     */         } } finally { variableHierarchy.finishRealBoundComparation();
/*     */       }
/* 250 */       return false;
/*     */     }
/* 252 */     return ParamTypeAssignabilityAlgorithm.isAssignable(paramType, fromType, CHECKER, this, variableHierarchy);
/*     */   }
/*     */ 
/*     */   private boolean isAssignable(GenericArrayType arrayType, Type fromType, VariableHierarchy variableHierarchy)
/*     */   {
/* 259 */     if ((fromType instanceof Class))
/*     */     {
/* 261 */       Class fromClass = (Class)fromType;
/* 262 */       if (!fromClass.isArray())
/*     */       {
/* 264 */         return false;
/*     */       }
/* 266 */       return isAssignable(arrayType.getGenericComponentType(), fromClass.getComponentType(), variableHierarchy);
/*     */     }
/*     */ 
/* 269 */     if ((fromType instanceof GenericArrayType))
/*     */     {
/* 271 */       GenericArrayType fromArrayType = (GenericArrayType)fromType;
/* 272 */       return isAssignable(arrayType.getGenericComponentType(), fromArrayType.getGenericComponentType(), variableHierarchy);
/*     */     }
/*     */ 
/* 275 */     return false;
/*     */   }
/*     */ 
/*     */   static {
/* 279 */     CHECKER = new ParamTypeAssignabilityAlgorithm.EqualityChecker()
/*     */     {
/*     */       public boolean isSame(Type type, Type fromType, AssignabilityAlgorithm client, VariableHierarchy variableHierarchy)
/*     */       {
/* 284 */         if (client.isVariableOperationApplicable(type, fromType))
/*     */         {
/* 286 */           return client.assignValue(type, fromType, variableHierarchy);
/*     */         }
/* 288 */         if ((type instanceof Class))
/*     */         {
/* 290 */           return type.equals(fromType);
/*     */         }
/* 292 */         if ((type instanceof ParameterizedType))
/*     */         {
/* 294 */           if (!(fromType instanceof ParameterizedType))
/*     */           {
/* 296 */             return false;
/*     */           }
/* 298 */           ParameterizedType fromParamType = (ParameterizedType)fromType;
/* 299 */           ParameterizedType paramType = (ParameterizedType)type;
/* 300 */           if (!isSame(paramType.getRawType(), fromParamType.getRawType(), client, variableHierarchy))
/*     */           {
/* 303 */             return false;
/*     */           }
/* 305 */           return isSame(paramType.getActualTypeArguments(), fromParamType.getActualTypeArguments(), client, variableHierarchy);
/*     */         }
/*     */ 
/* 308 */         if ((type instanceof WildcardType))
/*     */         {
/* 310 */           Type[] upperBounds = ((WildcardType)type).getUpperBounds();
/* 311 */           Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
/* 312 */           if ((fromType instanceof WildcardType))
/*     */           {
/* 314 */             Type[] fromUpperBounds = ((WildcardType)fromType).getUpperBounds();
/* 315 */             for (int i = 0; i < upperBounds.length; i++)
/*     */             {
/* 317 */               int j = 0;
/*     */               while (true) if (j < fromUpperBounds.length)
/*     */                 {
/* 319 */                   if (client.isAssignable(upperBounds[i], fromUpperBounds[i], variableHierarchy))
/*     */                     break;
/* 317 */                   j++; continue;
/*     */                 }
/*     */                 else
/*     */                 {
/* 325 */                   return false;
/*     */                 } 
/*     */             }
/* 327 */             Type[] fromLowerBounds = ((WildcardType)fromType).getLowerBounds();
/* 328 */             for (int i = 0; i < lowerBounds.length; i++)
/*     */             {
/* 330 */               int j = 0;
/*     */               while (true) if (j < fromLowerBounds.length)
/*     */                 {
/* 332 */                   if (client.getInverseAlgorithm().isAssignable(fromLowerBounds[i], lowerBounds[i], variableHierarchy))
/*     */                     break;
/* 330 */                   j++; continue;
/*     */                 }
/*     */                 else
/*     */                 {
/* 339 */                   return false;
/*     */                 } 
/*     */             }
/* 341 */             return true;
/*     */           }
/*     */ 
/* 345 */           for (int i = 0; i < upperBounds.length; i++)
/*     */           {
/* 347 */             if (!client.isAssignable(upperBounds[i], fromType, variableHierarchy))
/*     */             {
/* 350 */               return false;
/*     */             }
/*     */           }
/* 353 */           for (int i = 0; i < lowerBounds.length; i++)
/*     */           {
/* 355 */             if (!client.getInverseAlgorithm().isAssignable(fromType, lowerBounds[i], variableHierarchy))
/*     */             {
/* 358 */               return false;
/*     */             }
/*     */           }
/* 361 */           return true;
/*     */         }
/*     */ 
/* 364 */         return true;
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.AssignabilityAlgorithm
 * JD-Core Version:    0.6.0
 */