/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.instrument.TransformerCommon;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ 
/*     */ public class PerVmAdvice
/*     */ {
/*     */   public static synchronized Interceptor generateOptimized(Joinpoint joinpoint, AspectManager manager, String adviceName, AspectDefinition a)
/*     */     throws Exception
/*     */   {
/*  49 */     Object aspect = manager.getPerVMAspect(a);
/*  50 */     return generateInterceptor(joinpoint, aspect, adviceName);
/*     */   }
/*     */ 
/*     */   public static Interceptor generateInterceptor(Joinpoint joinpoint, Object aspect, String adviceName)
/*     */     throws Exception
/*     */   {
/*  56 */     ClassLoader cl = aspect.getClass().getClassLoader();
/*  57 */     String name = "org.jboss.aop.advice." + aspect.getClass().getName() + "_z_" + adviceName + "_" + System.identityHashCode(cl);
/*  58 */     Class iclass = null;
/*     */ 
/*  60 */     if (cl == null)
/*     */     {
/*  63 */       cl = SecurityActions.getContextClassLoader();
/*     */     }
/*  65 */     synchronized (PerVmAdvice.class)
/*     */     {
/*     */       try
/*     */       {
/*  69 */         iclass = cl.loadClass(name);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*  75 */       ClassPool pool = AspectManager.instance().findClassPool(cl);
/*     */ 
/*  77 */       if (iclass == null)
/*     */       {
/*     */         try
/*     */         {
/*  83 */           ClassLoader pcl = pool.getClassLoader();
/*  84 */           iclass = pcl.loadClass(name);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/*  91 */       if (iclass == null)
/*     */       {
/*  93 */         Method[] methods = aspect.getClass().getMethods();
/*  94 */         ArrayList matches = new ArrayList();
/*  95 */         for (int i = 0; i < methods.length; i++)
/*     */         {
/*  97 */           if (!methods[i].getName().equals(adviceName)) continue; matches.add(methods[i]);
/*     */         }
/*  99 */         if (matches.size() == 0) {
/* 100 */           throw new NoMatchingAdviceException(aspect.getClass(), adviceName);
/*     */         }
/* 102 */         for (int i = 0; i < matches.size(); i++)
/*     */         {
/* 104 */           Method method = (Method)matches.get(i);
/* 105 */           if (method.getParameterTypes().length != 1)
/*     */           {
/* 107 */             throw new InvalidAdviceException("Only one argument of type invocations is supported. Method '" + method.toString() + "' (aspect class " + aspect.getClass().getName() + ") does not comply");
/*     */           }
/*     */ 
/* 114 */           Class paramClass = method.getParameterTypes()[0];
/* 115 */           boolean foundInterface = false;
/* 116 */           if ((paramClass.isInterface()) && (paramClass.getName().equals("org.jboss.aop.joinpoint.Invocation"))) {
/* 117 */             foundInterface = true;
/*     */           }
/*     */           else {
/* 120 */             Class superParamClass = findSuperClass(paramClass);
/* 121 */             for (Class iClass : superParamClass.getInterfaces())
/*     */             {
/* 123 */               if (iClass.getName().equals("org.jboss.aop.joinpoint.Invocation"))
/* 124 */                 foundInterface = true;
/*     */             }
/*     */           }
/* 127 */           if (!foundInterface) {
/* 128 */             throw new InvalidAdviceException("Aspect method must have a parameter that implements Invocation. Parameter of advice '" + method.getName() + "' (aspect class" + aspect.getClass().getName() + ") does not comply: " + paramClass.getCanonicalName());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 135 */         CtClass clazz = TransformerCommon.makeClass(pool, name);
/*     */ 
/* 138 */         CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
/* 139 */         CtClass abstractAdviceClass = pool.get("org.jboss.aop.advice.AbstractAdvice");
/* 140 */         clazz.setSuperclass(abstractAdviceClass);
/*     */ 
/* 143 */         CtClass aspectClass = pool.get(aspect.getClass().getName());
/* 144 */         CtField field = new CtField(aspectClass, "aspectField", clazz);
/* 145 */         field.setModifiers(1);
/* 146 */         clazz.addField(field);
/*     */ 
/* 148 */         CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
/* 149 */         String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + adviceName + "\"; " + "}";
/*     */ 
/* 153 */         CtMethod getName = CtNewMethod.make(getNameTemplate.getReturnType(), "getName", getNameTemplate.getParameterTypes(), getNameTemplate.getExceptionTypes(), getNameBody, clazz);
/* 154 */         getName.setModifiers(1);
/* 155 */         clazz.addMethod(getName);
/*     */ 
/* 158 */         CtMethod invokeTemplate = interceptorInterface.getDeclaredMethod("invoke");
/* 159 */         StringBuffer invokeBody = new StringBuffer();
/* 160 */         invokeBody.append("{  ");
/* 161 */         if (matches.size() > 1)
/*     */         {
/* 163 */           boolean noArg = false;
/* 164 */           for (int i = 0; i < matches.size(); i++)
/*     */           {
/* 166 */             Method advice = (Method)matches.get(i);
/* 167 */             if (advice.getParameterTypes().length > 0)
/*     */             {
/* 169 */               String param = advice.getParameterTypes()[0].getName();
/* 170 */               invokeBody.append("   if ($1 instanceof " + param + ") return aspectField." + adviceName + "((" + param + ")$1); ");
/*     */             }
/*     */             else
/*     */             {
/* 174 */               noArg = true;
/* 175 */               invokeBody.append("   return aspectField." + adviceName + "(); ");
/* 176 */               break;
/*     */             }
/*     */           }
/* 179 */           if (!noArg)
/* 180 */             invokeBody.append("   return (org.jboss.aop.joinpoint.Invocation)null; ");
/*     */         }
/*     */         else
/*     */         {
/* 184 */           Method advice = (Method)matches.get(0);
/* 185 */           String param = advice.getParameterTypes()[0].getName();
/* 186 */           invokeBody.append("return aspectField." + adviceName + "((" + param + ")$1); ");
/*     */         }
/* 188 */         invokeBody.append("}");
/* 189 */         CtMethod invoke = CtNewMethod.make(invokeTemplate.getReturnType(), "invoke", invokeTemplate.getParameterTypes(), invokeTemplate.getExceptionTypes(), invokeBody.toString(), clazz);
/* 190 */         invoke.setModifiers(1);
/* 191 */         clazz.addMethod(invoke);
/*     */ 
/* 193 */         ProtectionDomain pd = aspect.getClass().getProtectionDomain();
/* 194 */         iclass = TransformerCommon.toClass(clazz, cl, pd);
/*     */       }
/*     */     }
/* 197 */     Interceptor rtn = (Interceptor)iclass.newInstance();
/* 198 */     Field f = iclass.getField("aspectField");
/* 199 */     f.set(rtn, aspect);
/* 200 */     return rtn;
/*     */   }
/*     */ 
/*     */   private static Class findSuperClass(Class clazz)
/*     */   {
/* 205 */     if ((clazz.getSuperclass() == null) || (clazz.getSuperclass().getName().equals("java.lang.Object"))) {
/* 206 */       return clazz;
/*     */     }
/* 208 */     return findSuperClass(clazz.getSuperclass());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PerVmAdvice
 * JD-Core Version:    0.6.0
 */