/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.CallerInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aop.proxy.container.AspectManaged;
/*     */ import org.jboss.aop.proxy.container.ClassProxyContainer;
/*     */ import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;
/*     */ 
/*     */ public class PerJoinpointAdvice extends AbstractAdvice
/*     */ {
/*  94 */   private boolean initialized = false;
/*     */   AspectDefinition aspectDefinition;
/*     */   Joinpoint joinpoint;
/*     */ 
/*     */   public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def, String adviceName)
/*     */     throws Exception
/*     */   {
/*  53 */     if ((joinpoint instanceof MethodJoinpoint))
/*     */     {
/*  55 */       MethodJoinpoint method = (MethodJoinpoint)joinpoint;
/*  56 */       if (Modifier.isStatic(method.getMethod().getModifiers()))
/*     */       {
/*  58 */         return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
/*     */       }
/*     */     } else {
/*  61 */       if ((joinpoint instanceof ConstructorJoinpoint))
/*     */       {
/*  63 */         return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
/*     */       }
/*  65 */       if ((joinpoint instanceof MethodCalledByMethodJoinpoint))
/*     */       {
/*  67 */         MethodCalledByMethodJoinpoint method = (MethodCalledByMethodJoinpoint)joinpoint;
/*  68 */         if (Modifier.isStatic(method.getCalling().getModifiers()))
/*     */         {
/*  70 */           return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
/*     */         }
/*     */       }
/*  73 */       else if ((joinpoint instanceof ConstructorCalledByMethodJoinpoint))
/*     */       {
/*  75 */         ConstructorCalledByMethodJoinpoint method = (ConstructorCalledByMethodJoinpoint)joinpoint;
/*  76 */         if (Modifier.isStatic(method.getCalling().getModifiers()))
/*     */         {
/*  78 */           return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
/*     */         }
/*     */       }
/*  81 */       else if ((joinpoint instanceof FieldJoinpoint))
/*     */       {
/*  83 */         FieldJoinpoint field = (FieldJoinpoint)joinpoint;
/*  84 */         if (Modifier.isStatic(field.getField().getModifiers()))
/*     */         {
/*  86 */           ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
/*  87 */           Object aspect = classAdvisor.getFieldAspect(field, def);
/*  88 */           return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
/*     */         }
/*     */       }
/*     */     }
/*  91 */     return new PerJoinpointAdvice(adviceName, def, advisor, joinpoint);
/*     */   }
/*     */ 
/*     */   public PerJoinpointAdvice(String adviceName, AspectDefinition a, Advisor advisor, Joinpoint joinpoint)
/*     */   {
/* 100 */     this.aspectDefinition = a;
/* 101 */     this.adviceName = adviceName;
/* 102 */     advisor.addPerInstanceJoinpointAspect(joinpoint, a);
/* 103 */     this.joinpoint = joinpoint;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 108 */     return this.aspectDefinition.getName() + "." + this.adviceName;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 113 */     Object aspect = null;
/* 114 */     if ((invocation instanceof CallerInvocation))
/*     */     {
/* 118 */       Object callingObject = ((CallerInvocation)invocation).getCallingObject();
/*     */ 
/* 120 */       if (callingObject == null) return invocation.invokeNext();
/*     */ 
/* 122 */       Advised advised = (Advised)callingObject;
/* 123 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/* 124 */       aspect = advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
/*     */     }
/*     */     else
/*     */     {
/* 128 */       Object targetObject = invocation.getTargetObject();
/* 129 */       if (targetObject == null) return invocation.invokeNext();
/*     */ 
/* 131 */       InstanceAdvisor instanceAdvisor = null;
/* 132 */       if ((targetObject instanceof Advised))
/*     */       {
/* 134 */         Advised advised = (Advised)targetObject;
/* 135 */         instanceAdvisor = advised._getInstanceAdvisor();
/*     */       }
/*     */       else
/*     */       {
/* 139 */         Advisor advisor = invocation.getAdvisor();
/* 140 */         if (advisor == null)
/*     */         {
/* 142 */           return invocation.invokeNext();
/*     */         }
/* 144 */         if ((advisor instanceof InstanceAdvisor))
/*     */         {
/* 146 */           instanceAdvisor = (InstanceAdvisor)advisor;
/*     */         }
/* 148 */         else if (((advisor instanceof ClassProxyContainer)) && ((invocation instanceof ContainerProxyMethodInvocation)))
/*     */         {
/* 150 */           ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
/* 151 */           instanceAdvisor = pi.getProxy().getInstanceAdvisor();
/*     */         }
/*     */         else
/*     */         {
/* 155 */           return invocation.invokeNext();
/*     */         }
/*     */       }
/* 158 */       aspect = instanceAdvisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
/*     */     }
/*     */ 
/* 161 */     if (!this.initialized)
/*     */     {
/* 163 */       init(this.adviceName, aspect.getClass());
/* 164 */       this.initialized = true;
/*     */     }
/* 166 */     Method advice = resolveAdvice(invocation);
/* 167 */     Object[] args = { invocation };
/*     */     try
/*     */     {
/* 171 */       return advice.invoke(aspect, args);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 175 */     throw e.getCause();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PerJoinpointAdvice
 * JD-Core Version:    0.6.0
 */