/*    */ package org.jboss.aop.advice;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ 
/*    */ public class AdviceStack
/*    */ {
/*    */   protected String name;
/*    */   protected ArrayList<InterceptorFactory> interceptorFactories;
/*    */ 
/*    */   public AdviceStack(String name, ArrayList<InterceptorFactory> factories)
/*    */   {
/* 40 */     this.name = name;
/* 41 */     this.interceptorFactories = factories;
/*    */   }
/*    */   public String getName() {
/* 44 */     return this.name;
/*    */   }
/* 46 */   public ArrayList<InterceptorFactory> getInterceptorFactories() { return this.interceptorFactories;
/*    */   }
/*    */ 
/*    */   public Interceptor[] createInterceptors(Advisor advisor, Joinpoint jp)
/*    */   {
/* 51 */     ArrayList interceptors = new ArrayList();
/* 52 */     for (int i = 0; i < this.interceptorFactories.size(); i++)
/*    */     {
/* 54 */       InterceptorFactory factory = (InterceptorFactory)this.interceptorFactories.get(i);
/* 55 */       if (!factory.isDeployed()) continue; interceptors.add(factory.create(advisor, jp));
/*    */     }
/* 57 */     return (Interceptor[])interceptors.toArray(new Interceptor[interceptors.size()]);
/*    */   }
/*    */ 
/*    */   public Interceptor[] createInterceptors()
/*    */   {
/* 62 */     return createInterceptors(null, null);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AdviceStack
 * JD-Core Version:    0.6.0
 */