/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ 
/*     */ public class AdviceFactory
/*     */   implements InterceptorFactory
/*     */ {
/*     */   private String advice;
/*     */   private AspectDefinition aspect;
/*     */   private AdviceType type;
/*     */ 
/*     */   public AdviceFactory(AspectDefinition aspect, String adviceName)
/*     */   {
/*  52 */     this(aspect, adviceName, AdviceType.AROUND);
/*     */   }
/*     */ 
/*     */   public AdviceFactory(AspectDefinition aspect, String adviceName, AdviceType type)
/*     */   {
/*  65 */     this.aspect = aspect;
/*  66 */     this.advice = adviceName;
/*  67 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public AspectDefinition getAspect()
/*     */   {
/*  75 */     return this.aspect;
/*     */   }
/*     */ 
/*     */   public String getAdvice()
/*     */   {
/*  83 */     return this.advice;
/*     */   }
/*     */ 
/*     */   public AdviceType getType()
/*     */   {
/*  91 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean isDeployed()
/*     */   {
/*  97 */     return this.aspect.isDeployed();
/*     */   }
/*     */ 
/*     */   public Interceptor create(Advisor advisor, Joinpoint joinpoint)
/*     */   {
/* 102 */     if (this.aspect.getScope() == Scope.PER_VM)
/*     */     {
/*     */       try
/*     */       {
/* 106 */         return PerVmAdvice.generateOptimized(joinpoint, advisor.getManager(), this.advice, this.aspect);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 110 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 113 */     if (this.aspect.getScope() == Scope.PER_CLASS)
/*     */     {
/*     */       try
/*     */       {
/* 117 */         return PerClassAdvice.generate(joinpoint, advisor, this.advice, this.aspect);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 121 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 124 */     if (this.aspect.getScope() == Scope.PER_INSTANCE)
/*     */     {
/* 126 */       return new PerInstanceAdvice(this.advice, this.aspect, advisor);
/*     */     }
/* 128 */     if (this.aspect.getScope() == Scope.PER_JOINPOINT)
/*     */     {
/*     */       try
/*     */       {
/* 132 */         return PerJoinpointAdvice.createInterceptor(advisor, joinpoint, this.aspect, this.advice);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 136 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 139 */     if (this.aspect.getScope() == Scope.PER_CLASS_JOINPOINT)
/*     */     {
/* 141 */       Object instance = null;
/*     */ 
/* 143 */       if ((advisor instanceof GeneratedClassAdvisor))
/*     */       {
/* 146 */         instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
/* 147 */         if (instance == null)
/*     */         {
/* 149 */           ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(this.aspect, joinpoint);
/* 150 */           instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
/*     */         }
/*     */       }
/* 153 */       else if ((joinpoint instanceof FieldJoinpoint))
/*     */       {
/* 155 */         FieldJoinpoint field = (FieldJoinpoint)joinpoint;
/* 156 */         ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
/* 157 */         instance = classAdvisor.getFieldAspect(field, this.aspect);
/*     */       }
/*     */       else
/*     */       {
/* 161 */         instance = this.aspect.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 166 */         return PerVmAdvice.generateInterceptor(joinpoint, instance, this.advice);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 170 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 177 */     return null;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 182 */     return this.aspect.getName() + "." + this.advice;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 187 */     if (this == obj) return true;
/* 188 */     if (!(obj instanceof AdviceFactory)) return false;
/*     */ 
/* 190 */     AspectDefinition otherAspect = ((AdviceFactory)obj).getAspect();
/*     */ 
/* 192 */     if (!this.aspect.getName().equals(otherAspect.getName())) return false;
/* 193 */     if (!this.aspect.getFactory().getName().equals(otherAspect.getFactory().getName())) return false;
/* 194 */     return this.advice.equals(((AdviceFactory)obj).advice);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AdviceFactory
 * JD-Core Version:    0.6.0
 */