/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javassist.ByteArrayClassPath;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.instrument.Instrumentor;
/*     */ import org.jboss.aop.instrument.InstrumentorFactory;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SuperClassesFirstWeavingStrategy extends WeavingStrategySupport
/*     */ {
/*  46 */   private static final Logger logger = AOPLogger.getLogger(SuperClassesFirstWeavingStrategy.class);
/*     */ 
/*  48 */   private boolean verbose = AspectManager.verbose;
/*  49 */   public static final String AOP_PACKAGE = Advised.class.getPackage().getName();
/*     */ 
/*     */   public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer) throws Exception
/*     */   {
/*  53 */     if (isReEntry())
/*     */     {
/*  55 */       return null;
/*     */     }
/*  57 */     setReEntry();
/*  58 */     manager.transformationStarted = true;
/*     */     try
/*     */     {
/*  61 */       if (manager.isNonAdvisableClassName(className))
/*     */       {
/*  63 */         Object localObject1 = null;
/*     */         return localObject1;
/*     */       }
/*  66 */       AOPClassPool pool = (AOPClassPool)manager.registerClassLoader(loader);
/*     */ 
/*  68 */       CtClass clazz = obtainCtClassInfo(pool, className, classfileBuffer);
/*     */ 
/*  70 */       CtClass woven = instrumentClass(manager, pool, clazz, true);
/*  71 */       if (woven != null)
/*     */       {
/*  73 */         pool.lockInCache(woven);
/*  74 */         if (AspectManager.debugClasses)
/*     */         {
/*  76 */           SecurityActions.debugWriteFile(clazz);
/*     */         }
/*  78 */         rtn = woven.toBytecode();
/*  79 */         if (AspectManager.getPrune()) woven.prune();
/*  80 */         byte[] arrayOfByte1 = rtn;
/*     */         return arrayOfByte1;
/*     */       }
/*  84 */       pool.soften(clazz);
/*     */ 
/*  86 */       byte[] rtn = null;
/*     */       return rtn;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  90 */       if (!(ex instanceof NotFoundException))
/*     */       {
/*  92 */         if (this.verbose)
/*  93 */           ex.printStackTrace();
/*     */         else {
/*  95 */           System.err.println("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
/*     */         }
/*     */       }
/*  98 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 102 */       clearReEntry(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   private CtClass obtainCtClassInfo(AOPClassPool pool, String className, byte[] classfileBuffer)
/*     */     throws NotFoundException
/*     */   {
/*     */     try
/*     */     {
/* 110 */       return pool.getLocally(className);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 116 */       ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
/* 117 */       pool.insertClassPath(cp);
/* 118 */       return pool.getLocally(className);
/*     */     }
/*     */     catch (Error e) {
/*     */     }
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   private CtClass instrumentClass(AspectManager manager, AOPClassPool pool, CtClass clazz, boolean isLoadedClass)
/*     */     throws NotFoundException, Exception
/*     */   {
/*     */     try
/*     */     {
/* 130 */       CtClass superClass = clazz.getSuperclass();
/*     */       ClassPool superPool;
/* 131 */       if ((superClass != null) && (!Instrumentor.implementsAdvised(clazz)))
/*     */       {
/* 133 */         superPool = superClass.getClassPool();
/* 134 */         if ((superPool instanceof AOPClassPool))
/*     */         {
/* 136 */           AspectManager aspectManager = manager;
/* 137 */           if (((manager instanceof Domain)) && (superPool != pool))
/*     */           {
/* 140 */             aspectManager = AspectManager.instance(superPool.getClassLoader());
/*     */           }
/* 142 */           instrumentClass(aspectManager, (AOPClassPool)superPool, superClass, false);
/*     */         }
/*     */       }
/*     */ 
/* 146 */       if (manager.isNonAdvisableClassName(clazz.getName()))
/*     */       {
/* 148 */         superPool = null;
/*     */         return superPool;
/*     */       }
/*     */ 
/* 151 */       if (clazz.isArray())
/*     */       {
/* 153 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("cannot compile, isArray: " + clazz.getName());
/* 154 */         pool.flushClass(clazz.getName());
/* 155 */         superPool = null;
/*     */         return superPool;
/*     */       }
/* 157 */       if (clazz.isInterface())
/*     */       {
/* 159 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("cannot compile, isInterface: " + clazz.getName());
/*     */ 
/* 161 */         clazz.prune();
/* 162 */         superPool = null;
/*     */         return superPool;
/*     */       }
/* 164 */       if (clazz.isFrozen())
/*     */       {
/* 166 */         if (isAdvised(pool, clazz)) {
/* 167 */           superPool = null;
/*     */           return superPool;
/* 168 */         }if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("warning, isFrozen: " + clazz.getName() + " " + clazz.getClassPool());
/* 169 */         if (!isLoadedClass)
/*     */         {
/* 172 */           clazz = obtainCtClassInfo(pool, clazz.getName(), null);
/*     */         }
/*     */         else {
/* 175 */           superPool = null;
/*     */           return superPool;
/*     */         }
/*     */       }
/*     */ 
/* 179 */       boolean transformed = clazz.isModified();
/* 180 */       if (!transformed)
/*     */       {
/* 182 */         advisor = AdvisorFactory.getClassAdvisor(clazz, manager);
/*     */ 
/* 184 */         Instrumentor instrumentor = InstrumentorFactory.getInstrumentor(pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(clazz));
/*     */ 
/* 190 */         if (!Instrumentor.isTransformable(clazz))
/*     */         {
/* 192 */           if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("cannot compile, implements Untransformable: " + clazz.getName());
/*     */ 
/* 195 */           Object localObject1 = null;
/*     */           return localObject1;
/*     */         }
/*     */ 
/* 198 */         manager.attachMetaData(advisor, clazz, true);
/* 199 */         manager.applyInterfaceIntroductions(advisor, clazz);
/* 200 */         transformed = instrumentor.transform(clazz, advisor);
/*     */       }
/* 202 */       if (transformed)
/*     */       {
/* 204 */         advisor = clazz;
/*     */         return advisor;
/*     */       }
/*     */ 
/* 207 */       if (isLoadedClass)
/*     */       {
/* 209 */         pool.setClassLoadedButNotWoven(clazz.getName());
/*     */       }
/*     */ 
/* 212 */       ClassAdvisor advisor = null;
/*     */       return advisor;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       throw new RuntimeException("Error converting class ", e);
/*     */     } finally {
/*     */     }
/* 219 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   public boolean isAdvised(ClassPool pool, CtClass clazz)
/*     */     throws NotFoundException
/*     */   {
/* 225 */     CtClass[] interfaces = clazz.getInterfaces();
/* 226 */     CtClass advised = pool.get(AOP_PACKAGE + ".Advised");
/* 227 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 229 */       if (interfaces[i].equals(advised)) return true;
/* 230 */       if (interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) return true;
/*     */     }
/* 232 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.SuperClassesFirstWeavingStrategy
 * JD-Core Version:    0.6.0
 */