/*     */ package org.jboss.aop;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.advice.AdviceBinding;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*     */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
/*     */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackDefinition;
/*     */ import org.jboss.aop.pointcut.AnnotationMatcher;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ import org.jboss.aop.pointcut.PointcutMethodMatch;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.proxy.container.InstanceProxyContainer;
/*     */ import org.jboss.aop.util.Advisable;
/*     */ import org.jboss.util.MethodHashing;
/*     */ 
/*     */ public class ReflectiveAspectBinder
/*     */ {
/*     */   protected Class clazz;
/*  63 */   protected HashSet aspects = new HashSet();
/*  64 */   protected HashMap methodAdvices = new HashMap();
/*  65 */   protected HashMap constructorAdvices = new HashMap();
/*  66 */   protected HashMap fieldReadAdvices = new HashMap();
/*  67 */   protected HashMap fieldWriteAdvices = new HashMap();
/*     */   protected Advisor advisor;
/*     */   protected boolean isInstanceContainer;
/*  70 */   TLongObjectHashMap methodMap = new TLongObjectHashMap();
/*     */ 
/*  73 */   protected Map<Object, Set<LifecycleCallbackDefinition>> lifecycleCallbacks = new HashMap();
/*     */   boolean initialisedAspects;
/*     */   boolean intitialisedLifecycleCallbacks;
/*     */ 
/*     */   public ReflectiveAspectBinder(Class clazz, Advisor advisor)
/*     */   {
/*  79 */     this.clazz = clazz;
/*  80 */     this.advisor = advisor;
/*  81 */     this.isInstanceContainer = (InstanceProxyContainer.class == advisor.getClass());
/*     */   }
/*     */ 
/*     */   public Class getClazz()
/*     */   {
/*  86 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public HashSet getAspects()
/*     */   {
/*  91 */     if (!this.initialisedAspects)
/*     */     {
/*  93 */       Map bindings = this.advisor.getManager().getBindings();
/*  94 */       bindMethodAdvices(this.clazz, bindings);
/*  95 */       bindConstructorAdvices(bindings);
/*  96 */       bindFieldAdvices(bindings);
/*     */     }
/*  98 */     return this.aspects;
/*     */   }
/*     */ 
/*     */   public Map<Object, Set<LifecycleCallbackDefinition>> getLifecycleCallbacks()
/*     */   {
/* 103 */     if (!this.intitialisedLifecycleCallbacks)
/*     */     {
/* 105 */       bindLifecycles();
/*     */     }
/* 107 */     return this.lifecycleCallbacks;
/*     */   }
/*     */ 
/*     */   public HashMap getMethodAdvices()
/*     */   {
/* 112 */     return this.methodAdvices;
/*     */   }
/*     */ 
/*     */   public HashMap getConstructorAdvices()
/*     */   {
/* 117 */     return this.constructorAdvices;
/*     */   }
/*     */ 
/*     */   public HashMap getFieldReadAdvices()
/*     */   {
/* 122 */     return this.fieldReadAdvices;
/*     */   }
/*     */ 
/*     */   public HashMap getFieldWriteAdvices()
/*     */   {
/* 127 */     return this.fieldWriteAdvices;
/*     */   }
/*     */ 
/*     */   public void createMethodMap(Class superClass)
/*     */   {
/*     */     try
/*     */     {
/* 134 */       if ((superClass == null) || ((superClass == Object.class) && (!this.isInstanceContainer)))
/*     */       {
/* 136 */         return;
/*     */       }
/* 138 */       createMethodMap(superClass.getSuperclass());
/*     */ 
/* 140 */       Method[] methods = (Method[])(Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(superClass)
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 144 */           return this.val$superClass.getDeclaredMethods();
/*     */         }
/*     */       });
/* 147 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 149 */         if (!Advisable.isAdvisable(methods[i]))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 154 */         long hash = MethodHashing.methodHash(methods[i]);
/* 155 */         this.methodMap.put(hash, methods[i]);
/*     */       }
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 160 */       throw new RuntimeException(e.getException());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 164 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindMethodAdvices(Class superClass, Map bindings)
/*     */   {
/* 170 */     createMethodMap(superClass);
/* 171 */     if (this.methodMap != null)
/*     */     {
/* 173 */       Object[] methods = this.methodMap.getValues();
/* 174 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 176 */         bindMethodAdvice((Method)methods[i], bindings);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindConstructorAdvices(Map bindings)
/*     */   {
/* 183 */     Constructor[] cons = (Constructor[])(Constructor[])AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 187 */         return ReflectiveAspectBinder.this.clazz.getDeclaredConstructors();
/*     */       }
/*     */     });
/* 190 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/* 192 */       bindConstructorAdvice(cons[i], bindings);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindFieldAdvices(Map bindings)
/*     */   {
/* 198 */     Field[] fields = (Field[])(Field[])AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 202 */         return ReflectiveAspectBinder.this.clazz.getDeclaredFields();
/*     */       }
/*     */     });
/* 205 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 207 */       bindFieldGetAdvice(fields[i], bindings);
/* 208 */       bindFieldSetAdvice(fields[i], bindings);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean matches(AnnotationIntroduction ai, Object element)
/*     */   {
/* 214 */     AnnotationMatcher matcher = new AnnotationMatcher(this.advisor, element);
/* 215 */     return ((Boolean)ai.getTarget().jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   protected void bindMethodAdvice(Method mi, Map bindings)
/*     */   {
/* 220 */     Iterator it = bindings.values().iterator();
/* 221 */     ArrayList advices = (ArrayList)this.methodAdvices.get(mi);
/* 222 */     while (it.hasNext())
/*     */     {
/* 225 */       AdviceBinding binding = (AdviceBinding)it.next();
/* 226 */       PointcutMethodMatch pmatch = binding.getPointcut().matchesExecution(this.advisor, mi);
/*     */ 
/* 228 */       if ((pmatch != null) && (pmatch.isMatch()))
/*     */       {
/* 230 */         if (advices == null)
/*     */         {
/* 232 */           advices = new ArrayList();
/* 233 */           this.methodAdvices.put(mi, advices);
/*     */         }
/* 235 */         advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
/* 236 */         for (int i = 0; i < binding.getInterceptorFactories().length; i++)
/*     */         {
/* 238 */           this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindConstructorAdvice(Constructor mi, Map bindings)
/*     */   {
/* 246 */     Iterator it = bindings.values().iterator();
/* 247 */     ArrayList advices = (ArrayList)this.constructorAdvices.get(mi);
/* 248 */     while (it.hasNext())
/*     */     {
/* 251 */       AdviceBinding binding = (AdviceBinding)it.next();
/* 252 */       if (binding.getPointcut().matchesExecution(this.advisor, mi))
/*     */       {
/* 254 */         if (advices == null)
/*     */         {
/* 256 */           advices = new ArrayList();
/* 257 */           this.constructorAdvices.put(mi, advices);
/*     */         }
/* 259 */         advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
/* 260 */         for (int i = 0; i < binding.getInterceptorFactories().length; i++)
/*     */         {
/* 262 */           this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindFieldGetAdvice(Field mi, Map bindings)
/*     */   {
/* 270 */     Map repositoryBindings = this.advisor.getManager().getBindings();
/* 271 */     Iterator it = repositoryBindings.values().iterator();
/* 272 */     ArrayList advices = (ArrayList)this.fieldReadAdvices.get(mi);
/* 273 */     while (it.hasNext())
/*     */     {
/* 276 */       AdviceBinding binding = (AdviceBinding)it.next();
/* 277 */       if (binding.getPointcut().matchesGet(this.advisor, mi))
/*     */       {
/* 279 */         if (advices == null)
/*     */         {
/* 281 */           advices = new ArrayList();
/* 282 */           this.fieldReadAdvices.put(mi, advices);
/*     */         }
/* 284 */         advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
/* 285 */         for (int i = 0; i < binding.getInterceptorFactories().length; i++)
/*     */         {
/* 287 */           this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindFieldSetAdvice(Field mi, Map bindings)
/*     */   {
/* 295 */     Map repositoryBindings = this.advisor.getManager().getBindings();
/* 296 */     Iterator it = repositoryBindings.values().iterator();
/* 297 */     ArrayList advices = (ArrayList)this.fieldWriteAdvices.get(mi);
/* 298 */     while (it.hasNext())
/*     */     {
/* 301 */       AdviceBinding binding = (AdviceBinding)it.next();
/* 302 */       if (binding.getPointcut().matchesSet(this.advisor, mi))
/*     */       {
/* 304 */         if (advices == null)
/*     */         {
/* 306 */           advices = new ArrayList();
/* 307 */           this.fieldWriteAdvices.put(mi, advices);
/*     */         }
/* 309 */         advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
/* 310 */         for (int i = 0; i < binding.getInterceptorFactories().length; i++)
/*     */         {
/* 312 */           this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindLifecycles()
/*     */   {
/* 320 */     for (LifecycleCallbackBinding binding : this.advisor.getManager().getLifecycleBindings().values())
/*     */     {
/* 322 */       if (binding.matches(this.advisor, this.clazz))
/*     */       {
/* 324 */         Object state = binding.getControllerState();
/* 325 */         callbacks = (Set)this.lifecycleCallbacks.get(state);
/* 326 */         if (callbacks == null)
/*     */         {
/* 328 */           callbacks = new LinkedHashSet();
/* 329 */           this.lifecycleCallbacks.put(state, callbacks);
/*     */         }
/*     */ 
/* 332 */         List boundCallbacks = binding.getLifecycleCallbacks();
/* 333 */         for (LifecycleCallbackDefinition callback : boundCallbacks)
/*     */         {
/* 335 */           callbacks.add(callback);
/*     */         }
/*     */       }
/*     */     }
/*     */     Set callbacks;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ReflectiveAspectBinder
 * JD-Core Version:    0.6.0
 */