/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.aop.joinpoint.MethodCallByMethod;
/*    */ import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
/*    */ 
/*    */ public class MethodByMethodInfo extends CallerMethodInfo
/*    */   implements MethodCallByMethod
/*    */ {
/*    */   private final long callingMethodHash;
/*    */   private final Method callingMethod;
/*    */ 
/*    */   public MethodByMethodInfo(Advisor advisor, Class calledClass, Method m, Method callingMethod, long callingMethodHash, long calledMethodHash, Interceptor[] in)
/*    */   {
/* 44 */     super(advisor, calledClass, m, calledMethodHash, in, callingMethod.getDeclaringClass());
/* 45 */     this.callingMethodHash = callingMethodHash;
/* 46 */     this.callingMethod = callingMethod;
/*    */   }
/*    */ 
/*    */   private MethodByMethodInfo(MethodByMethodInfo other)
/*    */   {
/* 54 */     super(other);
/* 55 */     this.callingMethodHash = other.callingMethodHash;
/* 56 */     this.callingMethod = other.callingMethod;
/*    */   }
/*    */ 
/*    */   protected Joinpoint internalGetJoinpoint()
/*    */   {
/* 61 */     return new MethodCalledByMethodJoinpoint(this.callingMethod, getMethod());
/*    */   }
/*    */ 
/*    */   public JoinPointInfo copy()
/*    */   {
/* 66 */     return new MethodByMethodInfo(this);
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 71 */     StringBuffer sb = new StringBuffer("Method called by Method");
/* 72 */     sb.append("[");
/* 73 */     sb.append("calling=" + this.callingMethod);
/* 74 */     sb.append(",called=" + getMethod());
/* 75 */     sb.append("]");
/* 76 */     return sb.toString();
/*    */   }
/*    */ 
/*    */   public long getCallingMethodHash()
/*    */   {
/* 81 */     return this.callingMethodHash;
/*    */   }
/*    */ 
/*    */   public Method getCallingMethod()
/*    */   {
/* 86 */     return this.callingMethod;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.MethodByMethodInfo
 * JD-Core Version:    0.6.0
 */