/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public abstract class JoinPointInfo
/*     */   implements JoinPointBean
/*     */ {
/*     */   private Interceptor[] interceptors;
/*  36 */   private ArrayList interceptorChain = new ArrayList();
/*     */   private WeakReference advisor;
/*     */   protected volatile Joinpoint joinpoint;
/*     */   protected WeakReference clazz;
/*     */   private String adviceString;
/*     */ 
/*     */   protected JoinPointInfo()
/*     */   {
/*  48 */     this.clazz = new WeakReference(null);
/*     */   }
/*     */ 
/*     */   protected JoinPointInfo(Advisor advisor, Class clazz)
/*     */   {
/*  53 */     setAdvisor(advisor);
/*  54 */     this.clazz = new WeakReference(clazz);
/*     */   }
/*     */ 
/*     */   protected JoinPointInfo(JoinPointInfo other)
/*     */   {
/*  62 */     this.advisor = other.advisor;
/*  63 */     this.clazz = other.clazz;
/*  64 */     if (other.interceptors != null)
/*     */     {
/*  66 */       this.interceptors = new Interceptor[other.interceptors.length];
/*  67 */       System.arraycopy(other.interceptors, 0, this.interceptors, 0, other.interceptors.length);
/*     */     }
/*  69 */     if (other.interceptorChain != null) this.interceptorChain.addAll(this.interceptorChain);
/*     */   }
/*     */ 
/*     */   protected void clear()
/*     */   {
/*  74 */     this.interceptorChain.clear();
/*  75 */     this.interceptors = null;
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/*  80 */     if (this.advisor == null)
/*     */     {
/*  82 */       return null;
/*     */     }
/*  84 */     return (Advisor)this.advisor.get();
/*     */   }
/*     */ 
/*     */   public Class getClazz()
/*     */   {
/*  89 */     return (Class)this.clazz.get();
/*     */   }
/*     */ 
/*     */   public void setAdvisor(Advisor advisor)
/*     */   {
/*  94 */     this.advisor = new WeakReference(advisor);
/*     */   }
/*     */ 
/*     */   public boolean hasAdvices()
/*     */   {
/*  99 */     return (this.interceptors != null) && (this.interceptors.length > 0);
/*     */   }
/*     */ 
/*     */   public boolean equalChains(JoinPointInfo other)
/*     */   {
/* 104 */     if ((this.interceptors == null) && (other.interceptors == null)) return true;
/* 105 */     if ((this.interceptors == null) || (other.interceptors == null)) return false;
/* 106 */     if (this.interceptors.length != other.interceptors.length) return false;
/*     */ 
/* 108 */     for (int i = 0; i < this.interceptors.length; i++)
/*     */     {
/* 110 */       if (!this.interceptors[i].equals(other.interceptors[i])) return false;
/*     */     }
/*     */ 
/* 113 */     return true;
/*     */   }
/*     */ 
/*     */   public Joinpoint getJoinpoint()
/*     */   {
/* 118 */     if (this.joinpoint == null)
/*     */     {
/* 120 */       this.joinpoint = internalGetJoinpoint();
/*     */     }
/* 122 */     return this.joinpoint;
/*     */   }
/*     */ 
/*     */   public ArrayList getInterceptorChain() {
/* 126 */     return this.interceptorChain;
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors() {
/* 130 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public void setInterceptors(Interceptor[] interceptors) {
/* 134 */     this.adviceString = null;
/* 135 */     this.interceptors = interceptors;
/*     */   }
/*     */   protected abstract Joinpoint internalGetJoinpoint();
/*     */ 
/*     */   public abstract JoinPointInfo copy();
/*     */ 
/* 143 */   public Object resolveClassMetaData(Object key, Object attr) { return getAdvisor().getClassMetaData().getMetaData(key, attr);
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/* 148 */     Advisor advisor = getAdvisor();
/* 149 */     if (advisor != null)
/*     */     {
/* 151 */       return advisor.resolveAnnotation(annotation);
/*     */     }
/* 153 */     return null;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   public void cloneChains(JoinPointInfo other)
/*     */   {
/* 163 */     this.interceptorChain = ((ArrayList)other.interceptorChain.clone());
/* 164 */     if (other.interceptors == null)
/*     */     {
/* 166 */       this.interceptors = null;
/*     */     }
/*     */     else
/*     */     {
/* 170 */       this.interceptors = ((Interceptor[])other.interceptors.clone());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getAdviceString()
/*     */   {
/* 176 */     if (this.adviceString == null)
/*     */     {
/* 178 */       if ((this.interceptors == null) || (this.interceptors.length == 0))
/*     */       {
/* 180 */         return "";
/*     */       }
/*     */ 
/* 183 */       StringBuffer buf = new StringBuffer();
/* 184 */       for (int i = 0; i < this.interceptors.length; i++)
/*     */       {
/* 186 */         if (i > 0)
/*     */         {
/* 188 */           buf.append(",");
/*     */         }
/*     */ 
/* 191 */         GeneratedAdvisorInterceptor icptr = (GeneratedAdvisorInterceptor)this.interceptors[i];
/* 192 */         buf.append(icptr.getAdviceString());
/*     */       }
/*     */ 
/* 195 */       return buf.toString();
/*     */     }
/*     */ 
/* 198 */     return this.adviceString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.JoinPointInfo
 * JD-Core Version:    0.6.0
 */