/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.proxy.ClassProxy;
/*     */ import org.jboss.aop.proxy.ClassProxyFactory;
/*     */ import org.jboss.aop.proxy.Proxy;
/*     */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*     */ 
/*     */ public class Dispatcher
/*     */ {
/*     */   public static final String DISPATCHER = "DISPATCHER";
/*     */   public static final String OID = "OID";
/*  47 */   public static final Dispatcher singleton = new Dispatcher();
/*     */ 
/*  49 */   Map targetMap = new ConcurrentHashMap();
/*     */ 
/*     */   public boolean isRegistered(Object oid)
/*     */   {
/*  54 */     return this.targetMap.containsKey(oid);
/*     */   }
/*     */ 
/*     */   public void registerTarget(Object oid, Object target)
/*     */   {
/*  62 */     this.targetMap.put(oid, target);
/*     */   }
/*     */ 
/*     */   public void unregisterTarget(Object oid)
/*     */   {
/*  67 */     this.targetMap.remove(oid);
/*     */   }
/*     */ 
/*     */   public Object getRegistered(Object oid)
/*     */   {
/*  72 */     return this.targetMap.get(oid);
/*     */   }
/*     */ 
/*     */   public InvocationResponse invoke(Invocation invocation)
/*     */     throws NotFoundInDispatcherException, Throwable
/*     */   {
/*  78 */     Object oid = invocation.getMetaData("DISPATCHER", "OID");
/*     */ 
/*  80 */     Object target = null;
/*  81 */     target = this.targetMap.get(oid);
/*     */ 
/*  83 */     if (target == null)
/*     */     {
/*  85 */       throw new NotFoundInDispatcherException(oid);
/*     */     }
/*     */ 
/*  88 */     if ((target instanceof ClassProxy))
/*     */     {
/*  90 */       ClassProxy proxy = (ClassProxy)target;
/*  91 */       return proxy._dynamicInvoke(invocation);
/*     */     }
/*  93 */     if ((target instanceof Proxy))
/*     */     {
/*  95 */       Proxy proxy = (Proxy)target;
/*  96 */       return proxy._dynamicInvoke(invocation);
/*     */     }
/*  98 */     if ((target instanceof Advised))
/*     */     {
/* 100 */       Advisor advisor = ((Advised)target)._getAdvisor();
/* 101 */       return advisor.dynamicInvoke(target, invocation);
/*     */     }
/* 103 */     if ((target instanceof Advisor))
/*     */     {
/* 105 */       Advisor advisor = (Advisor)target;
/* 106 */       return advisor.dynamicInvoke(null, invocation);
/*     */     }
/*     */ 
/* 110 */     if ((invocation instanceof MethodInvocation))
/*     */     {
/* 112 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/*     */ 
/* 114 */       long methodHash = methodInvocation.getMethodHash();
/* 115 */       HashMap methodMap = ClassProxyFactory.getMethodMap(target.getClass());
/* 116 */       MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
/* 117 */       Method method = (Method)ref.get();
/* 118 */       Object[] args = methodInvocation.getArguments();
/*     */       try
/*     */       {
/* 121 */         return new InvocationResponse(method.invoke(target, args));
/*     */       }
/*     */       catch (InvocationTargetException ex)
/*     */       {
/* 125 */         throw ex.getTargetException();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 130 */     throw new RuntimeException("field invocations not implemented");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.Dispatcher
 * JD-Core Version:    0.6.0
 */