/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FilenameFilter;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.file.ArchiveBrowser;
/*     */ import org.jboss.util.file.ClassFileFilter;
/*     */ 
/*     */ public class Deployment
/*     */ {
/*  44 */   private static final Logger logger = AOPLogger.getLogger(Deployment.class);
/*     */ 
/*  46 */   public static boolean searchClasspath = true;
/*     */ 
/*     */   public static void deploy()
/*     */   {
/*     */     try
/*     */     {
/*  53 */       deployThroughClassAnnotations();
/*  54 */       preconfigThroughClassPath();
/*  55 */       preconfigThroughSystemProperty();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  59 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void preconfigThroughClassPath()
/*     */   {
/*  70 */     String search = System.getProperty("jboss.aop.search.classpath", null);
/*  71 */     if (search != null) searchClasspath = new Boolean(search).booleanValue();
/*  72 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("jboss.aop.search.classpath: '" + search + "' " + searchClasspath);
/*  73 */     if (searchClasspath)
/*     */     {
/*     */       try
/*     */       {
/*  77 */         Enumeration en = SecurityActions.getContextClassLoader().getResources("META-INF/jboss-aop.xml");
/*  78 */         while (en.hasMoreElements())
/*     */         {
/*  80 */           URL url = (URL)en.nextElement();
/*  81 */           if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("deploying  " + url);
/*  82 */           AspectXmlLoader.deployXML(url);
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*  87 */         throw new RuntimeException(ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void deployThroughClassAnnotations()
/*     */   {
/*  97 */     String path = System.getProperty("jboss.aop.class.path", null);
/*  98 */     if (path == null)
/*     */     {
/* 100 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("jboss.aop.class.path is NULL");
/* 101 */       return;
/*     */     }
/* 103 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("jboss.aop.class.path: " + path);
/* 104 */     StringTokenizer t = new StringTokenizer(path, File.pathSeparator);
/* 105 */     while (t.hasMoreTokens())
/*     */     {
/* 107 */       String token = t.nextToken();
/* 108 */       File f = new File(token);
/* 109 */       if (!f.exists())
/*     */       {
/* 111 */         System.err.println("[error] Unable to find jboss.aop.class.path: " + f.getName());
/*     */       }
/*     */       try
/*     */       {
/* 115 */         URL url = f.toURL();
/* 116 */         Iterator it = ArchiveBrowser.getBrowser(url, new ClassFileFilter());
/* 117 */         AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
/* 118 */         loader.deployInputStreamIterator(it);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 122 */         ex.printStackTrace();
/* 123 */         if ((ex instanceof RuntimeException)) {
/* 124 */           throw ((RuntimeException)ex);
/*     */         }
/* 126 */         throw new RuntimeException("[error] failed to load aop class path: " + f.toString(), ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void preconfigThroughSystemProperty()
/*     */   {
/* 136 */     String path = System.getProperty("jboss.aop.path", null);
/* 137 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("jboss.aop.path: " + path);
/* 138 */     if (path == null) return;
/* 139 */     StringTokenizer t = new StringTokenizer(path, File.pathSeparator);
/* 140 */     int j = 0;
/* 141 */     while (t.hasMoreTokens())
/*     */     {
/* 143 */       String token = t.nextToken();
/* 144 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("jboss.aop.path[" + j + "]: " + token);
/* 145 */       File f = new File(token);
/*     */       try
/*     */       {
/* 148 */         if (f.isDirectory())
/*     */         {
/* 150 */           FilenameFilter filter = new FilenameFilter()
/*     */           {
/*     */             public boolean accept(File dir, String name)
/*     */             {
/* 154 */               return name.endsWith("aop.xml");
/*     */             }
/*     */           };
/* 157 */           File[] files = f.listFiles(filter);
/* 158 */           for (int i = 0; i < files.length; i++)
/*     */           {
/* 160 */             deployXmlFile(files[i]);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 165 */           deployXmlFile(f);
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 170 */         ex.printStackTrace();
/* 171 */         if ((ex instanceof RuntimeException)) {
/* 172 */           throw ((RuntimeException)ex);
/*     */         }
/* 174 */         throw new RuntimeException("[error] failed to load aop path: " + f.toString(), ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void deployXmlFile(File f) throws Exception
/*     */   {
/* 181 */     URL url = f.toURL();
/* 182 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("deploying " + url);
/* 183 */     AspectXmlLoader.deployXML(url);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.Deployment
 * JD-Core Version:    0.6.0
 */