/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.joinpoint.ConstructorExecution;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class ConstructorInfo extends JoinPointInfo
/*     */   implements ConstructorExecution
/*     */ {
/*     */   private Method wrapper;
/*     */   private Constructor constructor;
/*     */   private int index;
/*     */ 
/*     */   public ConstructorInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ConstructorInfo(Class clazz, int index, long wrapperHash, long constructorHash, Advisor advisor)
/*     */   {
/*  50 */     super(advisor, clazz);
/*     */     try
/*     */     {
/*  53 */       this.index = index;
/*  54 */       this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
/*  55 */       this.constructor = MethodHashing.findConstructorByHash(clazz, constructorHash);
/*  56 */       setAdvisor(advisor);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  60 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private ConstructorInfo(ConstructorInfo other)
/*     */   {
/*  69 */     super(other);
/*     */   }
/*     */ 
/*     */   protected Joinpoint internalGetJoinpoint()
/*     */   {
/*  74 */     return new ConstructorJoinpoint(this.constructor);
/*     */   }
/*     */ 
/*     */   public JoinPointInfo copy()
/*     */   {
/*  79 */     return new ConstructorInfo(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  84 */     StringBuffer sb = new StringBuffer("Constructor");
/*  85 */     sb.append("[");
/*  86 */     sb.append("constructor=" + this.constructor);
/*  87 */     sb.append("]");
/*  88 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public void setWrapper(Method wrapper)
/*     */   {
/*  93 */     this.wrapper = wrapper;
/*     */   }
/*     */ 
/*     */   public Method getWrapper()
/*     */   {
/*  98 */     return this.wrapper;
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/* 103 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 108 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setIndex(int index)
/*     */   {
/* 113 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 118 */     return this.index;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 124 */     Object val = super.resolveAnnotation(annotation);
/* 125 */     if (val != null) return val;
/*     */ 
/* 127 */     if (getAdvisor() != null)
/*     */     {
/* 129 */       val = getAdvisor().resolveAnnotation(this.constructor, annotation);
/* 130 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 133 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ConstructorInfo
 * JD-Core Version:    0.6.0
 */