/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.ConstructorCallByConstructor;
/*    */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ 
/*    */ public class ConByConInfo extends CallerConstructorInfo
/*    */   implements ConstructorCallByConstructor
/*    */ {
/*    */   private final int callingIndex;
/*    */   private final Constructor calling;
/*    */ 
/*    */   public ConByConInfo(Advisor advisor, Class calledClass, Class callingClass, int callingIndex, Constructor called, long calledConHash, Method wrappingMethod, Interceptor[] in)
/*    */   {
/* 44 */     super(advisor, calledClass, called, calledConHash, wrappingMethod, in, callingClass);
/* 45 */     this.callingIndex = callingIndex;
/* 46 */     Advisor tempAdvisor = advisor;
/* 47 */     if (advisor.getClazz() != callingClass)
/*    */     {
/* 49 */       tempAdvisor = advisor.manager.getAdvisor(callingClass);
/*    */     }
/* 51 */     this.calling = tempAdvisor.constructors[callingIndex];
/*    */   }
/*    */ 
/*    */   private ConByConInfo(ConByConInfo other)
/*    */   {
/* 59 */     super(other);
/* 60 */     this.callingIndex = other.callingIndex;
/* 61 */     this.calling = other.getCallingConstructor();
/*    */   }
/*    */ 
/*    */   protected Joinpoint internalGetJoinpoint()
/*    */   {
/* 66 */     return new ConstructorCalledByConstructorJoinpoint(getCallingConstructor(), getConstructor());
/*    */   }
/*    */ 
/*    */   public JoinPointInfo copy()
/*    */   {
/* 71 */     return new ConByConInfo(this);
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 76 */     StringBuffer sb = new StringBuffer("Constructor called by Constructor");
/* 77 */     sb.append("[");
/* 78 */     sb.append("calling=" + getCallingConstructor());
/* 79 */     sb.append(",called=" + getConstructor());
/* 80 */     sb.append("]");
/* 81 */     return sb.toString();
/*    */   }
/*    */ 
/*    */   public int getCallingIndex()
/*    */   {
/* 86 */     return this.callingIndex;
/*    */   }
/*    */ 
/*    */   @Deprecated
/*    */   public Constructor getCalling()
/*    */   {
/* 93 */     return this.calling;
/*    */   }
/*    */ 
/*    */   public Constructor getCallingConstructor()
/*    */   {
/* 98 */     return this.calling;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ConByConInfo
 * JD-Core Version:    0.6.0
 */