/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class ClassInstanceAdvisor
/*     */   implements InstanceAdvisor, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -3057976129116723527L;
/*  46 */   protected ArrayList insertedInterceptors = null;
/*  47 */   protected ArrayList appendedInterceptors = null;
/*     */   protected WeakReference instanceRef;
/*     */   protected transient WeakReference classAdvisorRef;
/*  50 */   public boolean hasInstanceAspects = false;
/*     */   private InterceptorChainObserver interceptorChainObserver;
/*     */   InstanceAdvisorDelegate delegate;
/*     */ 
/*     */   public ClassInstanceAdvisor()
/*     */   {
/*  58 */     this.delegate = new InstanceAdvisorDelegate(null, this);
/*  59 */     this.delegate.initialize();
/*     */   }
/*     */ 
/*     */   public ClassInstanceAdvisor(Object obj)
/*     */   {
/*  64 */     this.instanceRef = new WeakReference(obj);
/*  65 */     if ((obj instanceof Advised))
/*     */     {
/*  67 */       Advised advised = (Advised)obj;
/*  68 */       Advisor advizor = advised._getAdvisor();
/*  69 */       setAdvisorAndInitialise(advizor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassInstanceAdvisor(Advisor advizor)
/*     */   {
/*  75 */     setAdvisorAndInitialise(advizor);
/*     */   }
/*     */ 
/*     */   private void setAdvisorAndInitialise(Advisor advizor)
/*     */   {
/*  80 */     this.classAdvisorRef = new WeakReference(advizor);
/*     */ 
/*  82 */     if ((advizor instanceof ClassAdvisor))
/*     */     {
/*  84 */       this.delegate = new InstanceAdvisorDelegate(advizor, this);
/*  85 */       this.delegate.initialize();
/*  86 */       this.interceptorChainObserver = ((ClassAdvisor)advizor).getInterceptorChainObserver();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasInterceptors()
/*     */   {
/*  92 */     return (this.appendedInterceptors != null) || (this.insertedInterceptors != null);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(String def) {
/*  96 */     return this.delegate.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(AspectDefinition def)
/*     */   {
/* 101 */     return this.delegate.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def)
/*     */   {
/* 106 */     return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 111 */     return this.delegate.getMetaData();
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors()
/*     */   {
/* 116 */     ArrayList newlist = new ArrayList();
/* 117 */     if (this.insertedInterceptors != null) newlist.addAll(this.insertedInterceptors);
/* 118 */     if (this.appendedInterceptors != null) newlist.addAll(this.appendedInterceptors);
/* 119 */     return (Interceptor[])(Interceptor[])newlist.toArray(new Interceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors(Interceptor[] advisorChain)
/*     */   {
/* 127 */     if ((this.insertedInterceptors == null) && (this.appendedInterceptors == null)) return advisorChain;
/* 128 */     ArrayList newlist = new ArrayList();
/* 129 */     if (this.insertedInterceptors != null) newlist.addAll(this.insertedInterceptors);
/* 130 */     if (advisorChain != null)
/*     */     {
/* 132 */       newlist.addAll(Arrays.asList(advisorChain));
/*     */     }
/* 134 */     if (this.appendedInterceptors != null) newlist.addAll(this.appendedInterceptors);
/* 135 */     return (Interceptor[])(Interceptor[])newlist.toArray(new Interceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 140 */     ArrayList newList = new ArrayList();
/* 141 */     if (this.insertedInterceptors != null)
/*     */     {
/* 143 */       newList.addAll(this.insertedInterceptors);
/*     */     }
/* 145 */     newList.add(index, interceptor);
/* 146 */     this.insertedInterceptors = newList;
/* 147 */     this.hasInstanceAspects = true;
/* 148 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 150 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(Interceptor interceptor)
/*     */   {
/* 156 */     ArrayList newList = new ArrayList();
/* 157 */     if (this.insertedInterceptors != null)
/*     */     {
/* 159 */       newList.addAll(this.insertedInterceptors);
/*     */     }
/* 161 */     newList.add(interceptor);
/* 162 */     this.insertedInterceptors = newList;
/* 163 */     this.hasInstanceAspects = true;
/* 164 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 166 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(Interceptor interceptor)
/*     */   {
/* 172 */     ArrayList newList = new ArrayList();
/* 173 */     if (this.appendedInterceptors != null)
/*     */     {
/* 175 */       newList.addAll(this.appendedInterceptors);
/*     */     }
/* 177 */     newList.add(interceptor);
/* 178 */     this.appendedInterceptors = newList;
/* 179 */     this.hasInstanceAspects = true;
/* 180 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 182 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 188 */     ArrayList newList = new ArrayList();
/* 189 */     if (this.appendedInterceptors != null)
/*     */     {
/* 191 */       newList.addAll(this.appendedInterceptors);
/*     */     }
/* 193 */     newList.add(index, interceptor);
/* 194 */     this.appendedInterceptors = newList;
/* 195 */     this.hasInstanceAspects = true;
/* 196 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 198 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeInterceptor(String name)
/*     */   {
/* 207 */     int interceptorsRemoved = internalRemoveInterceptor(name);
/* 208 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 210 */       this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
/*     */     }
/*     */   }
/*     */ 
/*     */   private int internalRemoveInterceptor(String name)
/*     */   {
/* 220 */     int interceptorsRemoved = 0;
/* 221 */     if (this.insertedInterceptors != null)
/*     */     {
/* 223 */       for (int i = 0; i < this.insertedInterceptors.size(); i++)
/*     */       {
/* 225 */         Interceptor interceptor = (Interceptor)this.insertedInterceptors.get(i);
/* 226 */         if (!interceptor.getName().equals(name))
/*     */           continue;
/* 228 */         ArrayList newList = new ArrayList();
/* 229 */         newList.addAll(this.insertedInterceptors);
/* 230 */         newList.remove(i);
/* 231 */         this.insertedInterceptors = newList;
/* 232 */         interceptorsRemoved++;
/*     */       }
/*     */     }
/*     */ 
/* 236 */     if (this.appendedInterceptors != null)
/*     */     {
/* 238 */       for (int i = 0; i < this.appendedInterceptors.size(); i++)
/*     */       {
/* 240 */         Interceptor interceptor = (Interceptor)this.appendedInterceptors.get(i);
/* 241 */         if (!interceptor.getName().equals(name))
/*     */           continue;
/* 243 */         ArrayList newList = new ArrayList();
/* 244 */         newList.addAll(this.appendedInterceptors);
/* 245 */         newList.remove(i);
/* 246 */         this.appendedInterceptors = newList;
/* 247 */         interceptorsRemoved++;
/*     */       }
/*     */     }
/*     */ 
/* 251 */     this.hasInstanceAspects = (((this.insertedInterceptors != null) && (this.insertedInterceptors.size() > 0)) || ((this.appendedInterceptors != null) && (this.appendedInterceptors.size() > 0)));
/*     */ 
/* 253 */     return interceptorsRemoved;
/*     */   }
/*     */ 
/*     */   public final boolean hasAspects()
/*     */   {
/* 258 */     return this.hasInstanceAspects;
/*     */   }
/*     */ 
/*     */   public void insertInterceptorStack(String stackName)
/*     */   {
/* 263 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 264 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 266 */     ClassAdvisor classAdvisor = null;
/* 267 */     if ((getInstance() instanceof Advised))
/*     */     {
/* 269 */       Advised advised = (Advised)getInstance();
/* 270 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 272 */     int interceptorsAdded = 0;
/* 273 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 274 */     while (it.hasNext())
/*     */     {
/* 276 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 277 */       if (factory.isDeployed()) {
/* 278 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 279 */         insertInterceptor(interceptor);
/* 280 */         interceptorsAdded++;
/*     */       }
/*     */     }
/* 282 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 284 */       this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptorStack(String stackName)
/*     */   {
/* 290 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 291 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 293 */     ClassAdvisor classAdvisor = null;
/* 294 */     if ((getInstance() instanceof Advised))
/*     */     {
/* 296 */       Advised advised = (Advised)getInstance();
/* 297 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 299 */     int interceptorsAdded = 0;
/* 300 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 301 */     while (it.hasNext())
/*     */     {
/* 303 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 304 */       if (factory.isDeployed()) {
/* 305 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 306 */         appendInterceptor(interceptor);
/* 307 */         interceptorsAdded++;
/*     */       }
/*     */     }
/* 309 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 311 */       this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeInterceptorStack(String stackName)
/*     */   {
/* 317 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 318 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 320 */     ClassAdvisor classAdvisor = null;
/* 321 */     if ((getInstance() instanceof Advised))
/*     */     {
/* 323 */       Advised advised = (Advised)getInstance();
/* 324 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 326 */     int interceptorsRemoved = 0;
/* 327 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 328 */     while (it.hasNext())
/*     */     {
/* 330 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 331 */       if (factory.isDeployed()) {
/* 332 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 333 */         interceptorsRemoved += internalRemoveInterceptor(interceptor.getName());
/*     */       }
/*     */     }
/* 335 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 337 */       this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Domain getDomain()
/*     */   {
/* 345 */     throw new RuntimeException("getDomain() is only available when you use weaving with generated advisors");
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */   {
/* 353 */     ClassLoader classLoader = getClassAdvisor().getClazz().getClassLoader();
/* 354 */     if (this.interceptorChainObserver != null) { getClassAdvisor().getManager(); if (AspectManager.getRegisteredCLs().containsKey(classLoader)); } else { return;
/*     */     }
/* 358 */     this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
/*     */   }
/*     */ 
/*     */   private Advisor getClassAdvisor()
/*     */   {
/* 363 */     if (this.classAdvisorRef != null)
/*     */     {
/* 365 */       return (Advisor)this.classAdvisorRef.get();
/*     */     }
/* 367 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/* 372 */     if (this.instanceRef != null)
/*     */     {
/* 374 */       return this.instanceRef.get();
/*     */     }
/* 376 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ClassInstanceAdvisor
 * JD-Core Version:    0.6.0
 */