/*     */ package org.jboss.aop;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import org.jboss.aop.advice.AdviceBinding;
/*     */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*     */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.Advisable;
/*     */ import org.jboss.aop.util.ConstructorComparator;
/*     */ import org.jboss.aop.util.FieldComparator;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassContainer extends Advisor
/*     */ {
/*  54 */   private static final Logger logger = AOPLogger.getLogger(ClassContainer.class);
/*     */   private boolean chainOverridingForInheritedMethods;
/*     */   protected Field[] advisedFields;
/*     */ 
/*     */   public ClassContainer(String name, AspectManager manager)
/*     */   {
/*  60 */     super(name, manager);
/*     */   }
/*     */ 
/*     */   public void initializeClassContainer()
/*     */   {
/*  65 */     initializeMetadata();
/*  66 */     rebuildInterceptors();
/*     */   }
/*     */ 
/*     */   public void setClass(Class clazz)
/*     */   {
/*  71 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public void initializeMetadata()
/*     */   {
/*  76 */     createMethodMap();
/*  77 */     createConstructorTables();
/*  78 */     createFieldTable();
/*  79 */     getManager().attachMetaData(this, this.clazz);
/*  80 */     rebindClassMetaData();
/*  81 */     deployAnnotationOverrides();
/*     */   }
/*     */ 
/*     */   private void populateFieldTable(ArrayList fields, Class superclass)
/*     */   {
/*  88 */     if (superclass == null) return;
/*  89 */     if (superclass.equals(Object.class)) return;
/*     */ 
/*  91 */     populateFieldTable(fields, superclass.getSuperclass());
/*     */ 
/*  95 */     ArrayList temp = new ArrayList();
/*  96 */     Field[] declaredFields = (Field[])(Field[])AccessController.doPrivileged(new PrivilegedAction(superclass)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 100 */         return this.val$superclass.getDeclaredFields();
/*     */       }
/*     */     });
/* 103 */     for (int i = 0; i < declaredFields.length; i++)
/*     */     {
/* 105 */       if (!Advisable.isAdvisable(declaredFields[i]))
/*     */         continue;
/* 107 */       temp.add(declaredFields[i]);
/*     */     }
/*     */ 
/* 110 */     Collections.sort(temp, FieldComparator.INSTANCE);
/* 111 */     fields.addAll(temp);
/*     */   }
/*     */ 
/*     */   protected void createFieldTable()
/*     */   {
/* 119 */     ArrayList fields = new ArrayList();
/*     */ 
/* 121 */     populateFieldTable(fields, this.clazz);
/*     */ 
/* 123 */     this.advisedFields = ((Field[])(Field[])fields.toArray(new Field[fields.size()]));
/*     */   }
/*     */ 
/*     */   protected void rebuildInterceptors()
/*     */   {
/* 129 */     this.adviceBindings.clear();
/* 130 */     createInterceptorChains();
/*     */   }
/*     */ 
/*     */   public void addClassMetaData(ClassMetaDataBinding data)
/*     */   {
/* 135 */     initClassMetaDataBindingsList();
/* 136 */     this.classMetaDataBindings.add(data);
/* 137 */     if (this.clazz == null) return;
/*     */ 
/* 139 */     bindClassMetaData(data);
/*     */ 
/* 141 */     this.adviceBindings.clear();
/* 142 */     this.doesHaveAspects = false;
/* 143 */     rebuildInterceptors();
/*     */   }
/*     */ 
/*     */   public void removeClassMetaData(ClassMetaDataBinding data)
/*     */   {
/* 151 */     if (this.classMetaDataBindings.remove(data))
/*     */     {
/* 153 */       if (this.clazz == null) return;
/* 154 */       rebindClassMetaData();
/*     */ 
/* 156 */       this.adviceBindings.clear();
/* 157 */       this.doesHaveAspects = false;
/* 158 */       rebuildInterceptors();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindClassMetaData(ClassMetaDataBinding data)
/*     */   {
/*     */     try
/*     */     {
/* 166 */       ClassMetaDataLoader loader = data.getLoader();
/* 167 */       Object[] objs = this.advisedMethods.getValues();
/* 168 */       Method[] methods = new Method[objs.length];
/* 169 */       for (int i = 0; i < objs.length; i++) methods[i] = ((Method)objs[i]);
/* 170 */       loader.bind(this, data, methods, this.advisedFields, this.clazz.getDeclaredConstructors());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 175 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void rebindClassMetaData()
/*     */   {
/* 181 */     this.defaultMetaData.clear();
/* 182 */     this.methodMetaData.clear();
/* 183 */     this.fieldMetaData.clear();
/* 184 */     this.constructorMetaData.clear();
/* 185 */     this.classMetaData.clear();
/*     */ 
/* 187 */     for (int i = 0; i < this.classMetaDataBindings.size(); i++)
/*     */     {
/* 189 */       ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
/* 190 */       bindClassMetaData(data);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createMethodMap()
/*     */   {
/* 196 */     initAdvisedMethodsMap();
/*     */     try
/*     */     {
/* 199 */       Method[] declaredMethods = this.clazz.getMethods();
/* 200 */       for (int i = 0; i < declaredMethods.length; i++)
/*     */       {
/* 202 */         if (!ClassAdvisor.isAdvisable(declaredMethods[i]))
/*     */           continue;
/* 204 */         long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 205 */         this.advisedMethods.put(hash, declaredMethods[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 211 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected MethodInterceptors initializeMethodChain()
/*     */   {
/* 217 */     MethodInterceptors newInterceptors = new MethodInterceptors(this);
/* 218 */     long[] keys = this.advisedMethods.keys();
/* 219 */     for (int i = 0; i < keys.length; i++)
/*     */     {
/* 221 */       MethodInfo info = new MethodInfo();
/* 222 */       Method amethod = (Method)this.advisedMethods.get(keys[i]);
/* 223 */       info.setAdvisedMethod(amethod);
/* 224 */       info.setUnadvisedMethod(amethod);
/* 225 */       info.setHash(keys[i]);
/* 226 */       info.setAdvisor(this);
/* 227 */       newInterceptors.put(keys[i], info);
/*     */     }
/* 229 */     return newInterceptors;
/*     */   }
/*     */ 
/*     */   protected void createConstructorTables()
/*     */   {
/* 234 */     this.constructors = SecurityActions.getDeclaredConstructors(this.clazz);
/*     */ 
/* 236 */     if (this.constructors.length > 0)
/*     */     {
/* 238 */       for (int i = 0; i < this.constructors.length; i++)
/*     */       {
/* 240 */         SecurityActions.setAccessible(this.constructors[i]);
/*     */       }
/* 242 */       Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createInterceptorChains()
/*     */   {
/* 248 */     MethodInterceptors newMethodInfos = initializeMethodChain();
/* 249 */     ArrayList newConstructorInfos = initializeConstructorChain();
/*     */ 
/* 251 */     LinkedHashMap bindings = this.manager.getBindings();
/* 252 */     synchronized (bindings)
/*     */     {
/* 254 */       if (bindings.size() > 0)
/*     */       {
/* 256 */         Iterator it = bindings.values().iterator();
/* 257 */         while (it.hasNext())
/*     */         {
/* 259 */           AdviceBinding binding = (AdviceBinding)it.next();
/* 260 */           if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("iterate binding " + binding.getName());
/* 261 */           resolveMethodPointcut(newMethodInfos, binding);
/* 262 */           resolveConstructorPointcut(newConstructorInfos, binding);
/*     */         }
/*     */       }
/*     */     }
/* 266 */     finalizeConstructorChain(newConstructorInfos);
/* 267 */     finalizeMethodChain(newMethodInfos);
/* 268 */     this.constructorInfos = new ConstructorInfo[newConstructorInfos.size()];
/* 269 */     if (this.constructorInfos.length > 0) {
/* 270 */       this.constructorInfos = ((ConstructorInfo[])(ConstructorInfo[])newConstructorInfos.toArray(this.constructorInfos));
/*     */     }
/* 272 */     populateInterceptorsFromInfos();
/*     */ 
/* 274 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*     */   }
/*     */ 
/*     */   public boolean chainOverridingForInheritedMethods()
/*     */   {
/* 284 */     return this.chainOverridingForInheritedMethods;
/*     */   }
/*     */ 
/*     */   protected void setChainOverridingForInheritedMethods(boolean overriding)
/*     */   {
/* 293 */     this.chainOverridingForInheritedMethods = overriding;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ClassContainer
 * JD-Core Version:    0.6.0
 */