/*      */ package org.jboss.aop;
/*      */ 
/*      */ import gnu.trove.TLongObjectHashMap;
/*      */ import java.io.PrintStream;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedHashMap;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.Interceptor;
/*      */ import org.jboss.aop.instrument.ConstructorExecutionTransformer;
/*      */ import org.jboss.aop.instrument.FieldAccessTransformer;
/*      */ import org.jboss.aop.instrument.MethodExecutionTransformer;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*      */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
/*      */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
/*      */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
/*      */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
/*      */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*      */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*      */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*      */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*      */ import org.jboss.aop.joinpoint.Invocation;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
/*      */ import org.jboss.aop.joinpoint.MethodInvocation;
/*      */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*      */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*      */ import org.jboss.aop.metadata.ConstructorMetaData;
/*      */ import org.jboss.aop.metadata.FieldMetaData;
/*      */ import org.jboss.aop.metadata.MethodMetaData;
/*      */ import org.jboss.aop.metadata.SimpleMetaData;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.util.Advisable;
/*      */ import org.jboss.aop.util.ConstructorComparator;
/*      */ import org.jboss.aop.util.FieldComparator;
/*      */ import org.jboss.aop.util.MethodHashing;
/*      */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.NotImplementedException;
/*      */ 
/*      */ public class ClassAdvisor extends Advisor
/*      */ {
/*   88 */   private static final Logger logger = AOPLogger.getLogger(ClassAdvisor.class);
/*      */   public static final String NOT_TRANSFORMABLE_SUFFIX = "$aop";
/*   96 */   protected TLongObjectHashMap unadvisedMethods = new TLongObjectHashMap();
/*      */   private volatile MethodByMethodData methodByMethodData;
/*      */   private volatile ConByMethodData conByMethodData;
/*      */   protected HashMap[] methodCalledByConBindings;
/*      */   protected HashMap[] methodCalledByConInterceptors;
/*  107 */   protected HashMap backrefMethodCalledByConstructorBindings = new HashMap();
/*      */   protected HashMap[] conCalledByConBindings;
/*      */   protected HashMap[] conCalledByConInterceptors;
/*  112 */   protected HashMap backrefConCalledByConstructorBindings = new HashMap();
/*      */ 
/*      */   /** @deprecated */
/*      */   private Interceptor[][] fieldReadInterceptors;
/*      */   private FieldInfo[] fieldReadInfos;
/*      */ 
/*      */   /** @deprecated */
/*      */   private Interceptor[][] fieldWriteInterceptors;
/*      */   private FieldInfo[] fieldWriteInfos;
/*      */   protected Field[] advisedFields;
/*  127 */   private HashMap fieldAspectsWithNoInstance = new HashMap();
/*      */ 
/*  129 */   protected boolean initialized = false;
/*      */   private InterceptorChainObserver interceptorChainObserver;
/*      */ 
/*  133 */   public ClassAdvisor(String classname, AspectManager manager) { super(classname, manager);
/*      */   }
/*      */ 
/*      */   public ClassAdvisor(Class clazz, AspectManager manager)
/*      */   {
/*  138 */     this(clazz.getName(), manager);
/*  139 */     this.clazz = clazz;
/*      */   }
/*      */ 
/*      */   public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def)
/*      */   {
/*  155 */     HashMap map = (HashMap)this.fieldAspectsWithNoInstance.get(def);
/*  156 */     if (map == null)
/*      */     {
/*  158 */       synchronized (this.fieldAspectsWithNoInstance)
/*      */       {
/*  160 */         map = (HashMap)this.fieldAspectsWithNoInstance.get(def);
/*  161 */         if (map == null)
/*      */         {
/*  163 */           map = new HashMap();
/*  164 */           this.fieldAspectsWithNoInstance.put(def, map);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  169 */     Object aspect = map.get(joinpoint);
/*  170 */     if (aspect == null)
/*      */     {
/*  172 */       synchronized (map)
/*      */       {
/*  174 */         aspect = map.get(joinpoint);
/*  175 */         if (aspect == null)
/*      */         {
/*  177 */           aspect = def.getFactory().createPerJoinpoint(this, joinpoint);
/*  178 */           map.put(joinpoint, aspect);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  183 */     return aspect;
/*      */   }
/*      */ 
/*      */   public Field[] getAdvisedFields()
/*      */   {
/*  188 */     return this.advisedFields;
/*      */   }
/*      */ 
/*      */   public TLongObjectHashMap getAdvisedMethods()
/*      */   {
/*  193 */     return this.advisedMethods;
/*      */   }
/*      */ 
/*      */   protected TLongObjectHashMap getUnadvisedMethods()
/*      */   {
/*  198 */     return this.unadvisedMethods;
/*      */   }
/*      */ 
/*      */   public Constructor[] getConstructors()
/*      */   {
/*  203 */     return this.constructors;
/*      */   }
/*      */ 
/*      */   public TLongObjectHashMap getMethodCalledByMethodInterceptors()
/*      */   {
/*  208 */     return getMethodByMethodData().getMethodCalledByMethodInterceptors();
/*      */   }
/*      */ 
/*      */   public HashMap[] getMethodCalledByConInterceptors()
/*      */   {
/*  213 */     return this.methodCalledByConInterceptors;
/*      */   }
/*      */ 
/*      */   public HashMap[] getConCalledByConInterceptors()
/*      */   {
/*  218 */     return this.conCalledByConInterceptors;
/*      */   }
/*      */ 
/*      */   public TLongObjectHashMap getConCalledByMethodInterceptors()
/*      */   {
/*  223 */     return getConByMethodData().getConCalledByMethodInterceptors();
/*      */   }
/*      */ 
/*      */   public TLongObjectHashMap getMethodCalledByMethodBindings()
/*      */   {
/*  228 */     return getMethodByMethodData().getMethodCalledByMethodBindings();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Interceptor[][] getFieldReadInterceptors() {
/*  234 */     throw new NotImplementedException("Use getFieldReadInfos");
/*      */   }
/*      */ 
/*      */   public FieldInfo[] getFieldReadInfos()
/*      */   {
/*  239 */     return this.fieldReadInfos;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Interceptor[][] getFieldWriteInterceptors() {
/*  245 */     throw new NotImplementedException("Use getFieldWriteInfos");
/*      */   }
/*      */ 
/*      */   public FieldInfo[] getFieldWriteInfos()
/*      */   {
/*  250 */     return this.fieldWriteInfos;
/*      */   }
/*      */ 
/*      */   public TLongObjectHashMap getMethodInterceptors()
/*      */   {
/*  255 */     return this.methodInterceptors;
/*      */   }
/*      */ 
/*      */   public synchronized void attachClass(Class clazz)
/*      */   {
/*  264 */     if (this.initialized) return;
/*      */ 
/*      */     try
/*      */     {
/*  269 */       ClassAdvisor THIS = this;
/*  270 */       AspectManager theManager = this.manager;
/*      */ 
/*  272 */       this.manager.registerClassLoader(clazz.getClassLoader());
/*  273 */       AccessController.doPrivileged(new PrivilegedExceptionAction(theManager, THIS, clazz)
/*      */       {
/*      */         public Object run() throws Exception
/*      */         {
/*  277 */           this.val$theManager.attachMetaData(this.val$THIS, this.val$clazz);
/*  278 */           ClassAdvisor.this.interfaceIntroductions.clear();
/*      */ 
/*  284 */           this.val$THIS.clazz = this.val$clazz;
/*      */ 
/*  289 */           ClassAdvisor.this.rebindClassMetaData();
/*  290 */           this.val$theManager.applyInterfaceIntroductions(this.val$THIS, this.val$clazz);
/*  291 */           ClassAdvisor.this.createFieldTable();
/*  292 */           ClassAdvisor.this.createMethodTables();
/*  293 */           ClassAdvisor.this.createConstructorTables();
/*  294 */           ClassAdvisor.this.populateMixinMethods();
/*      */ 
/*  302 */           ClassAdvisor.this.rebindClassMetaData();
/*  303 */           ClassAdvisor.this.createInterceptorChains();
/*  304 */           ClassAdvisor.this.initialized = true;
/*  305 */           return null;
/*      */         }
/*      */ 
/*      */       });
/*      */     }
/*      */     catch (PrivilegedActionException e)
/*      */     {
/*  316 */       throw new RuntimeException(e.getException());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static Method getMethod(Class clazz, Method method)
/*      */     throws NoSuchMethodException
/*      */   {
/*  327 */     if ((clazz == null) || (clazz.equals(Object.class))) throw new NoSuchMethodException(method.getName());
/*      */     try
/*      */     {
/*  330 */       String wrappedName = notAdvisedMethodName(clazz.getName(), method.getName());
/*  331 */       return clazz.getMethod(wrappedName, method.getParameterTypes());
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/*  335 */     return getMethod(clazz.getSuperclass(), method);
/*      */   }
/*      */ 
/*      */   public int getConstructorIndex(Constructor constructor)
/*      */   {
/*  344 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/*  346 */       if (constructor.equals(this.constructors[i]))
/*      */       {
/*  348 */         return i;
/*      */       }
/*      */     }
/*      */ 
/*  352 */     return -1;
/*      */   }
/*      */ 
/*      */   public int getFieldIndex(Field field)
/*      */   {
/*  360 */     for (int i = 0; i < this.advisedFields.length; i++)
/*      */     {
/*  362 */       if (field.equals(this.advisedFields[i]))
/*      */       {
/*  364 */         return i;
/*      */       }
/*      */     }
/*      */ 
/*  368 */     return -1;
/*      */   }
/*      */ 
/*      */   protected void populateMixinMethods()
/*      */     throws Exception
/*      */   {
/*  378 */     ArrayList pointcuts = getInterfaceIntroductions();
/*  379 */     Iterator it = pointcuts.iterator();
/*  380 */     while (it.hasNext())
/*      */     {
/*  382 */       InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
/*  383 */       ArrayList mixins = pointcut.getMixins();
/*  384 */       for (int i = 0; i < mixins.size(); i++)
/*      */       {
/*  386 */         InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(i);
/*      */ 
/*  388 */         ClassLoader cl = SecurityActions.getContextClassLoader();
/*  389 */         cl.loadClass(mixin.getClassName());
/*  390 */         String[] interfaces = mixin.getInterfaces();
/*  391 */         for (int j = 0; j < interfaces.length; j++)
/*      */         {
/*  393 */           Class intf = cl.loadClass(interfaces[j]);
/*  394 */           if (!intf.isAssignableFrom(this.clazz))
/*      */             continue;
/*  396 */           Method[] methods = intf.getMethods();
/*  397 */           for (int k = 0; k < methods.length; k++)
/*      */           {
/*  402 */             Method method = getMethod(this.clazz, methods[k]);
/*  403 */             long hash = MethodHashing.methodHash(method);
/*  404 */             this.unadvisedMethods.put(hash, method);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void removeAdviceBinding(AdviceBinding binding)
/*      */   {
/*  415 */     removeCallerPointcut(binding);
/*  416 */     super.removeAdviceBinding(binding);
/*      */   }
/*      */ 
/*      */   public synchronized void removeAdviceBindings(ArrayList bindings)
/*      */   {
/*  421 */     for (int i = 0; i < bindings.size(); i++)
/*      */     {
/*  423 */       AdviceBinding binding = (AdviceBinding)bindings.get(i);
/*  424 */       removeCallerPointcut(binding);
/*      */     }
/*  426 */     this.adviceBindings.removeAll(bindings);
/*  427 */     rebuildInterceptors();
/*  428 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*      */   }
/*      */ 
/*      */   protected void resolveFieldPointcut(ArrayList newFieldInfos, AdviceBinding binding, boolean write)
/*      */   {
/*  433 */     for (int i = 0; i < this.advisedFields.length; i++)
/*      */     {
/*  435 */       Field field = this.advisedFields[i];
/*      */ 
/*  437 */       if (((write) || (!binding.getPointcut().matchesGet(this, field))) && ((!write) || (!binding.getPointcut().matchesSet(this, field)))) {
/*      */         continue;
/*      */       }
/*  440 */       if (AspectManager.verbose) System.err.println("[debug] field matched " + (write ? "write" : "read") + " binding: " + field);
/*  441 */       this.adviceBindings.add(binding);
/*  442 */       binding.addAdvisor(this);
/*  443 */       FieldInfo info = (FieldInfo)newFieldInfos.get(i);
/*  444 */       pointcutResolved(info, binding, new FieldJoinpoint(field));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected MethodInterceptors initializeMethodChain()
/*      */   {
/*  451 */     MethodInterceptors newInterceptors = new MethodInterceptors(this);
/*  452 */     long[] keys = this.advisedMethods.keys();
/*  453 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  455 */       MethodInfo info = new MethodInfo();
/*  456 */       Method amethod = (Method)this.advisedMethods.get(keys[i]);
/*  457 */       info.setAdvisedMethod(amethod);
/*  458 */       Method umethod = (Method)this.unadvisedMethods.get(keys[i]);
/*      */ 
/*  460 */       if (umethod == null) umethod = amethod;
/*  461 */       info.setUnadvisedMethod(umethod);
/*  462 */       info.setHash(keys[i]);
/*  463 */       info.setAdvisor(this);
/*  464 */       newInterceptors.put(keys[i], info);
/*      */       try
/*      */       {
/*  467 */         Field infoField = this.clazz.getDeclaredField(MethodExecutionTransformer.getMethodInfoFieldName(amethod.getName(), keys[i]));
/*  468 */         infoField.setAccessible(true);
/*  469 */         infoField.set(null, new WeakReference(info));
/*      */       }
/*      */       catch (NoSuchFieldException e)
/*      */       {
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/*  477 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*  480 */     return newInterceptors;
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeFieldReadChain()
/*      */   {
/*  485 */     ArrayList chain = new ArrayList(this.advisedFields.length);
/*  486 */     for (int i = 0; i < this.advisedFields.length; i++)
/*      */     {
/*  488 */       FieldInfo info = new FieldInfo();
/*  489 */       info.setAdvisedField(this.advisedFields[i]);
/*  490 */       info.setAdvisor(this);
/*  491 */       info.setIndex(i);
/*      */       try
/*      */       {
/*  495 */         info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(this.advisedFields[i].getName()), new Class[] { Object.class }));
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/*      */       }
/*      */ 
/*  504 */       chain.add(info);
/*      */       try
/*      */       {
/*  508 */         Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldReadInfoFieldName(this.advisedFields[i].getName()));
/*  509 */         infoField.setAccessible(true);
/*  510 */         infoField.set(null, new WeakReference(info));
/*      */       }
/*      */       catch (NoSuchFieldException e)
/*      */       {
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/*  518 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*      */ 
/*  522 */     return chain;
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeFieldWriteChain()
/*      */   {
/*  527 */     ArrayList chain = new ArrayList(this.advisedFields.length);
/*  528 */     for (int i = 0; i < this.advisedFields.length; i++)
/*      */     {
/*  530 */       FieldInfo info = new FieldInfo();
/*  531 */       info.setAdvisedField(this.advisedFields[i]);
/*  532 */       info.setAdvisor(this);
/*  533 */       info.setIndex(i);
/*      */       try
/*      */       {
/*  537 */         info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(this.advisedFields[i].getName()), new Class[] { Object.class, this.advisedFields[i].getType() }));
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/*      */       }
/*      */ 
/*  546 */       chain.add(info);
/*      */       try
/*      */       {
/*  550 */         Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldWriteInfoFieldName(this.advisedFields[i].getName()));
/*  551 */         infoField.setAccessible(true);
/*  552 */         infoField.set(null, new WeakReference(info));
/*      */       }
/*      */       catch (NoSuchFieldException e)
/*      */       {
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/*  560 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*      */ 
/*  564 */     return chain;
/*      */   }
/*      */ 
/*      */   protected void finalizeFieldReadChain(ArrayList newFieldInfos)
/*      */   {
/*  569 */     for (int i = 0; i < newFieldInfos.size(); i++)
/*      */     {
/*  571 */       FieldInfo info = (FieldInfo)newFieldInfos.get(i);
/*  572 */       ArrayList list = info.getInterceptorChain();
/*  573 */       Interceptor[] interceptors = null;
/*  574 */       if (list.size() > 0)
/*      */       {
/*  576 */         interceptors = applyPrecedence((Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]));
/*      */       }
/*  578 */       info.setInterceptors(interceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeFieldWriteChain(ArrayList newFieldInfos)
/*      */   {
/*  584 */     for (int i = 0; i < newFieldInfos.size(); i++)
/*      */     {
/*  586 */       FieldInfo info = (FieldInfo)newFieldInfos.get(i);
/*  587 */       ArrayList list = info.getInterceptorChain();
/*  588 */       Interceptor[] interceptors = null;
/*  589 */       if (list.size() > 0)
/*      */       {
/*  591 */         interceptors = applyPrecedence((Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]));
/*      */       }
/*  593 */       info.setInterceptors(interceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createInterceptorChains() throws Exception
/*      */   {
/*  599 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Creating chains for " + this.clazz + " " + (this.clazz != null ? this.clazz.getClassLoader() : null));
/*  600 */     MethodInterceptors newMethodInfos = initializeMethodChain();
/*  601 */     ArrayList newFieldReadInfos = initializeFieldReadChain();
/*  602 */     ArrayList newFieldWriteInfos = initializeFieldWriteChain();
/*  603 */     ArrayList newConstructorInfos = initializeConstructorChain();
/*  604 */     ArrayList newConstructionInfos = initializeConstructionChain();
/*      */ 
/*  606 */     synchronized (this.manager.getBindings())
/*      */     {
/*  608 */       Iterator it = this.manager.getBindings().values().iterator();
/*  609 */       while (it.hasNext())
/*      */       {
/*  611 */         AdviceBinding binding = (AdviceBinding)it.next();
/*  612 */         if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr());
/*  613 */         resolveMethodPointcut(newMethodInfos, binding);
/*  614 */         resolveFieldPointcut(newFieldReadInfos, binding, false);
/*  615 */         resolveFieldPointcut(newFieldWriteInfos, binding, true);
/*  616 */         resolveConstructorPointcut(newConstructorInfos, binding);
/*  617 */         resolveConstructionPointcut(newConstructionInfos, binding);
/*      */       }
/*      */     }
/*      */ 
/*  621 */     finalizeChains(newMethodInfos, newFieldReadInfos, newFieldWriteInfos, newConstructorInfos, newConstructionInfos);
/*  622 */     populateInterceptorsFromInfos();
/*      */ 
/*  624 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*      */ 
/*  626 */     if (this.interceptorChainObserver != null)
/*      */     {
/*  628 */       this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInterceptors, this.fieldWriteInterceptors, this.constructorInterceptors, this.methodInterceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeChains(MethodInterceptors newMethodInfos, ArrayList newFieldReadInfos, ArrayList newFieldWriteInfos, ArrayList newConstructorInfos, ArrayList newConstructionInfos)
/*      */   {
/*  635 */     finalizeMethodChain(newMethodInfos);
/*  636 */     finalizeFieldReadChain(newFieldReadInfos);
/*  637 */     finalizeFieldWriteChain(newFieldWriteInfos);
/*  638 */     finalizeConstructorChain(newConstructorInfos);
/*  639 */     finalizeConstructionChain(newConstructionInfos);
/*  640 */     this.fieldReadInfos = ((FieldInfo[])(FieldInfo[])newFieldReadInfos.toArray(new FieldInfo[newFieldReadInfos.size()]));
/*  641 */     this.fieldWriteInfos = ((FieldInfo[])(FieldInfo[])newFieldWriteInfos.toArray(new FieldInfo[newFieldWriteInfos.size()]));
/*  642 */     this.constructorInfos = ((ConstructorInfo[])(ConstructorInfo[])newConstructorInfos.toArray(new ConstructorInfo[newConstructorInfos.size()]));
/*  643 */     this.constructionInfos = ((ConstructionInfo[])(ConstructionInfo[])newConstructionInfos.toArray(new ConstructionInfo[newConstructionInfos.size()]));
/*      */   }
/*      */ 
/*      */   private MethodByConInfo initializeConstructorCallerInterceptorsMap(Class callingClass, int callingIndex, String calledClass, long calledMethodHash, Method calledMethod) throws Exception
/*      */   {
/*  648 */     HashMap calledClassesMap = this.methodCalledByConInterceptors[callingIndex];
/*  649 */     if (calledClassesMap == null)
/*      */     {
/*  651 */       calledClassesMap = new HashMap();
/*  652 */       this.methodCalledByConInterceptors[callingIndex] = calledClassesMap;
/*      */     }
/*  654 */     TLongObjectHashMap calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass);
/*  655 */     if (calledMethodsMap == null)
/*      */     {
/*  657 */       calledMethodsMap = new TLongObjectHashMap();
/*  658 */       calledClassesMap.put(calledClass, calledMethodsMap);
/*      */     }
/*      */ 
/*  662 */     calledMethod.setAccessible(true);
/*      */ 
/*  664 */     Class calledClazz = SecurityActions.getContextClassLoader().loadClass(calledClass);
/*  665 */     MethodByConInfo info = new MethodByConInfo(this, calledClazz, callingClass, callingIndex, calledMethod, calledMethodHash, null);
/*  666 */     calledMethodsMap.put(calledMethodHash, info);
/*  667 */     return info;
/*      */   }
/*      */ 
/*      */   private ConByConInfo initializeConCalledByConInterceptorsMap(Class callingClass, int callingIndex, String calledClass, long calledConHash, Constructor calledCon) throws Exception
/*      */   {
/*  672 */     HashMap calledClassesMap = this.conCalledByConInterceptors[callingIndex];
/*  673 */     if (calledClassesMap == null)
/*      */     {
/*  675 */       calledClassesMap = new HashMap();
/*  676 */       this.conCalledByConInterceptors[callingIndex] = calledClassesMap;
/*      */     }
/*  678 */     TLongObjectHashMap calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass);
/*  679 */     if (calledMethodsMap == null)
/*      */     {
/*  681 */       calledMethodsMap = new TLongObjectHashMap();
/*  682 */       calledClassesMap.put(calledClass, calledMethodsMap);
/*      */     }
/*  684 */     ConByConInfo info = createConByConInfo(callingClass, callingIndex, calledClass, calledCon, calledConHash);
/*  685 */     calledMethodsMap.put(calledConHash, info);
/*  686 */     return info;
/*      */   }
/*      */ 
/*      */   private ConByConInfo createConByConInfo(Class callingClass, int callingIndex, String calledClass, Constructor calledCon, long calledConHash)
/*      */     throws Exception
/*      */   {
/*  693 */     calledCon.setAccessible(true);
/*      */ 
/*  695 */     Class calledClazz = SecurityActions.getContextClassLoader().loadClass(calledClass);
/*      */     try
/*      */     {
/*  699 */       int index = calledClass.lastIndexOf('.');
/*  700 */       String baseClassName = calledClass.substring(index + 1);
/*  701 */       Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
/*  702 */       return new ConByConInfo(this, calledClazz, callingClass, callingIndex, calledCon, calledConHash, wrapper, null);
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/*  706 */     return new ConByConInfo(this, calledClazz, callingClass, callingIndex, calledCon, calledConHash, null, null);
/*      */   }
/*      */ 
/*      */   protected void rebuildCallerInterceptors()
/*      */     throws Exception
/*      */   {
/*  712 */     if (this.methodByMethodData != null)
/*      */     {
/*  714 */       getMethodByMethodData().rebuildCallerInterceptors();
/*      */     }
/*  716 */     for (int i = 0; i < this.methodCalledByConInterceptors.length; i++)
/*      */     {
/*  718 */       HashMap calledClasses = this.methodCalledByConInterceptors[i];
/*  719 */       if (calledClasses != null) {
/*  720 */         Iterator classesIterator = calledClasses.entrySet().iterator();
/*  721 */         while (classesIterator.hasNext())
/*      */         {
/*  723 */           Map.Entry entry = (Map.Entry)classesIterator.next();
/*  724 */           String cname = (String)entry.getKey();
/*  725 */           TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
/*  726 */           long[] calledKeys = calledMethods.keys();
/*  727 */           for (int j = 0; j < calledKeys.length; j++)
/*      */           {
/*  729 */             long calledHash = calledKeys[j];
/*  730 */             ArrayList bindings = getConstructorCallerBindings(i, cname, calledHash);
/*  731 */             bindConstructorCallerInterceptorChain(bindings, i, cname, calledHash);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  735 */     if (this.conByMethodData != null)
/*      */     {
/*  737 */       getConByMethodData().rebuildCallerInterceptors();
/*      */     }
/*  739 */     for (int i = 0; i < this.conCalledByConInterceptors.length; i++)
/*      */     {
/*  741 */       HashMap calledClasses = this.conCalledByConInterceptors[i];
/*  742 */       if (calledClasses != null) {
/*  743 */         Iterator classesIterator = calledClasses.entrySet().iterator();
/*  744 */         while (classesIterator.hasNext())
/*      */         {
/*  746 */           Map.Entry entry = (Map.Entry)classesIterator.next();
/*  747 */           String cname = (String)entry.getKey();
/*  748 */           TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
/*  749 */           long[] calledKeys = calledMethods.keys();
/*  750 */           for (int j = 0; j < calledKeys.length; j++)
/*      */           {
/*  752 */             long calledHash = calledKeys[j];
/*  753 */             ArrayList bindings = getConCalledByConBindings(i, cname, calledHash);
/*  754 */             bindConCalledByConInterceptorChain(bindings, i, cname, calledHash);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private ArrayList getConstructorCallerBindings(int callingIndex, String cname, long calledHash) {
/*  762 */     HashMap calledClasses = this.methodCalledByConBindings[callingIndex];
/*  763 */     TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
/*  764 */     return (ArrayList)calledMethods.get(calledHash);
/*      */   }
/*      */ 
/*      */   private ArrayList getConCalledByConBindings(int callingIndex, String cname, long calledHash)
/*      */   {
/*  769 */     HashMap calledClasses = this.conCalledByConBindings[callingIndex];
/*  770 */     TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
/*  771 */     return (ArrayList)calledMethods.get(calledHash);
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info)
/*      */   {
/*  776 */     ArrayList list = info.getInterceptorChain();
/*  777 */     Interceptor[] interceptors = null;
/*  778 */     if (list.size() > 0)
/*      */     {
/*  780 */       interceptors = (Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]);
/*      */     }
/*  782 */     info.setInterceptors(interceptors);
/*      */   }
/*      */ 
/*      */   protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info)
/*      */   {
/*  787 */     ArrayList list = info.getInterceptorChain();
/*  788 */     Interceptor[] interceptors = null;
/*  789 */     if (list.size() > 0)
/*      */     {
/*  791 */       interceptors = (Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]);
/*      */     }
/*  793 */     info.setInterceptors(interceptors);
/*      */   }
/*      */ 
/*      */   private void bindConCalledByConInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash)
/*      */   {
/*  798 */     ConByConInfo info = getConCalledByCon(callingIndex, cname, calledHash);
/*  799 */     info.clear();
/*  800 */     Iterator it = bindings.iterator();
/*  801 */     while (it.hasNext())
/*      */     {
/*  803 */       AdviceBinding binding = (AdviceBinding)it.next();
/*  804 */       pointcutResolved(info, binding, new ConstructorCalledByConstructorJoinpoint(info.getCallingConstructor(), info.getConstructor()));
/*      */     }
/*  806 */     finalizeConCalledByConInterceptorChain(info);
/*      */   }
/*      */ 
/*      */   protected void finalizeConCalledByConInterceptorChain(ConByConInfo info)
/*      */   {
/*  811 */     ArrayList list = info.getInterceptorChain();
/*  812 */     Interceptor[] interceptors = null;
/*  813 */     if (list.size() > 0)
/*      */     {
/*  815 */       interceptors = (Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]);
/*      */     }
/*  817 */     info.setInterceptors(interceptors);
/*      */   }
/*      */ 
/*      */   private void bindConstructorCallerInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash)
/*      */   {
/*  822 */     MethodByConInfo info = getConstructorCallerMethodInfo(callingIndex, cname, calledHash);
/*  823 */     info.clear();
/*  824 */     Iterator it = bindings.iterator();
/*  825 */     while (it.hasNext())
/*      */     {
/*  827 */       AdviceBinding binding = (AdviceBinding)it.next();
/*  828 */       pointcutResolved(info, binding, new MethodCalledByConstructorJoinpoint(info.getCallingConstructor(), info.getMethod()));
/*      */     }
/*  830 */     finalizeMethodCalledByConInterceptorChain(info);
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info)
/*      */   {
/*  835 */     ArrayList list = info.getInterceptorChain();
/*  836 */     Interceptor[] interceptors = null;
/*  837 */     if (list.size() > 0)
/*      */     {
/*  839 */       interceptors = (Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]);
/*      */     }
/*  841 */     info.setInterceptors(interceptors);
/*      */   }
/*      */ 
/*      */   protected void rebuildInterceptors()
/*      */   {
/*  846 */     if (this.initialized)
/*      */     {
/*  848 */       if (System.getSecurityManager() == null)
/*      */       {
/*  850 */         RebuildInterceptorsAction.NON_PRIVILEGED.rebuildInterceptors(this);
/*      */       }
/*      */       else
/*      */       {
/*  854 */         RebuildInterceptorsAction.PRIVILEGED.rebuildInterceptors(this);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doRebuildInterceptors()
/*      */   {
/*      */     try
/*      */     {
/*  863 */       this.adviceBindings.clear();
/*  864 */       createInterceptorChains();
/*  865 */       rebuildCallerInterceptors();
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/*  869 */       throw new RuntimeException(ex);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void bindClassMetaData(ClassMetaDataBinding data)
/*      */   {
/*      */     try {
/*  876 */       ClassMetaDataLoader loader = data.getLoader();
/*  877 */       Object[] objs = this.advisedMethods.getValues();
/*  878 */       Method[] methods = new Method[objs.length];
/*  879 */       Field[] fields = this.advisedFields;
/*      */ 
/*  881 */       if (fields == null) fields = new Field[0];
/*  882 */       Constructor[] cons = this.constructors;
/*      */ 
/*  884 */       if (cons == null) cons = new Constructor[0];
/*  885 */       for (int i = 0; i < objs.length; i++) methods[i] = ((Method)objs[i]);
/*  886 */       loader.bind(this, data, methods, fields, cons);
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/*  891 */       ex.printStackTrace();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void rebindClassMetaData()
/*      */   {
/*  897 */     this.defaultMetaData.clear();
/*  898 */     this.methodMetaData.clear();
/*  899 */     this.fieldMetaData.clear();
/*  900 */     this.constructorMetaData.clear();
/*  901 */     this.classMetaData.clear();
/*      */ 
/*  903 */     for (int i = 0; i < this.classMetaDataBindings.size(); i++)
/*      */     {
/*  905 */       ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
/*  906 */       bindClassMetaData(data);
/*      */     }
/*      */ 
/*  909 */     deployAnnotationOverrides();
/*      */   }
/*      */ 
/*      */   public synchronized void addClassMetaData(ClassMetaDataBinding data)
/*      */   {
/*  915 */     initClassMetaDataBindingsList();
/*  916 */     this.classMetaDataBindings.add(data);
/*  917 */     if (this.clazz == null) return;
/*      */ 
/*  919 */     bindClassMetaData(data);
/*      */ 
/*  921 */     this.adviceBindings.clear();
/*  922 */     this.doesHaveAspects = false;
/*  923 */     rebuildInterceptors();
/*      */   }
/*      */ 
/*      */   public synchronized void removeClassMetaData(ClassMetaDataBinding data)
/*      */   {
/*  928 */     if (this.classMetaDataBindings.remove(data))
/*      */     {
/*  930 */       if (this.clazz == null) return;
/*  931 */       rebindClassMetaData();
/*      */ 
/*  933 */       this.adviceBindings.clear();
/*  934 */       this.doesHaveAspects = false;
/*  935 */       rebuildInterceptors();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void initializeEmptyConstructorCallerChain(int callingIndex, String calledClass, long calledMethodHash)
/*      */     throws Exception
/*      */   {
/*  943 */     HashMap callingCon = this.methodCalledByConBindings[callingIndex];
/*  944 */     if (callingCon == null)
/*      */     {
/*  946 */       callingCon = new HashMap();
/*  947 */       this.methodCalledByConBindings[callingIndex] = callingCon;
/*      */     }
/*  949 */     TLongObjectHashMap classMap = (TLongObjectHashMap)callingCon.get(calledClass);
/*  950 */     if (classMap == null)
/*      */     {
/*  952 */       classMap = new TLongObjectHashMap();
/*  953 */       callingCon.put(calledClass, classMap);
/*      */     }
/*  955 */     ArrayList bindings = (ArrayList)classMap.get(calledMethodHash);
/*  956 */     if (bindings == null)
/*      */     {
/*  958 */       bindings = new ArrayList();
/*  959 */       classMap.put(calledMethodHash, bindings);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void initializeConCalledByConEmptyChain(int callingIndex, String calledClass, long calledConHash) throws Exception
/*      */   {
/*  965 */     HashMap callingCon = this.conCalledByConBindings[callingIndex];
/*  966 */     if (callingCon == null)
/*      */     {
/*  968 */       callingCon = new HashMap();
/*  969 */       this.conCalledByConBindings[callingIndex] = callingCon;
/*      */     }
/*  971 */     TLongObjectHashMap classMap = (TLongObjectHashMap)callingCon.get(calledClass);
/*  972 */     if (classMap == null)
/*      */     {
/*  974 */       classMap = new TLongObjectHashMap();
/*  975 */       callingCon.put(calledClass, classMap);
/*      */     }
/*  977 */     ArrayList bindings = (ArrayList)classMap.get(calledConHash);
/*  978 */     if (bindings == null)
/*      */     {
/*  980 */       bindings = new ArrayList();
/*  981 */       classMap.put(calledConHash, bindings);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addConstructorCallerPointcut(int callingIndex, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception
/*      */   {
/*  987 */     if (AspectManager.verbose) System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
/*  988 */     this.adviceBindings.add(binding);
/*  989 */     binding.addAdvisor(this);
/*  990 */     HashMap callingCon = this.methodCalledByConBindings[callingIndex];
/*  991 */     if (callingCon == null)
/*      */     {
/*  993 */       callingCon = new HashMap();
/*  994 */       this.methodCalledByConBindings[callingIndex] = callingCon;
/*      */     }
/*  996 */     TLongObjectHashMap classMap = (TLongObjectHashMap)callingCon.get(calledClass);
/*  997 */     if (classMap == null)
/*      */     {
/*  999 */       classMap = new TLongObjectHashMap();
/* 1000 */       callingCon.put(calledClass, classMap);
/*      */     }
/* 1002 */     ArrayList bindings = (ArrayList)classMap.get(calledMethodHash);
/* 1003 */     boolean createdBindings = false;
/* 1004 */     if (bindings == null)
/*      */     {
/* 1006 */       bindings = new ArrayList();
/* 1007 */       classMap.put(calledMethodHash, bindings);
/* 1008 */       createdBindings = true;
/*      */     }
/* 1010 */     if (!bindings.contains(binding)) bindings.add(binding);
/*      */ 
/* 1013 */     ArrayList backrefs = (ArrayList)this.backrefMethodCalledByConstructorBindings.get(binding.getName());
/* 1014 */     if (backrefs == null)
/*      */     {
/* 1016 */       backrefs = new ArrayList();
/* 1017 */       this.backrefMethodCalledByConstructorBindings.put(binding.getName(), backrefs);
/* 1018 */       backrefs.add(bindings);
/*      */     }
/* 1020 */     else if (createdBindings) { backrefs.add(bindings); }
/*      */   }
/*      */ 
/*      */   private void addConstructorCalledByConPointcut(int callingIndex, String calledClass, long calledConHash, AdviceBinding binding) throws Exception
/*      */   {
/* 1025 */     if (AspectManager.verbose) System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
/* 1026 */     this.adviceBindings.add(binding);
/* 1027 */     binding.addAdvisor(this);
/* 1028 */     HashMap callingCon = this.conCalledByConBindings[callingIndex];
/* 1029 */     if (callingCon == null)
/*      */     {
/* 1031 */       callingCon = new HashMap();
/* 1032 */       this.conCalledByConBindings[callingIndex] = callingCon;
/*      */     }
/* 1034 */     TLongObjectHashMap classMap = (TLongObjectHashMap)callingCon.get(calledClass);
/* 1035 */     if (classMap == null)
/*      */     {
/* 1037 */       classMap = new TLongObjectHashMap();
/* 1038 */       callingCon.put(calledClass, classMap);
/*      */     }
/* 1040 */     ArrayList bindings = (ArrayList)classMap.get(calledConHash);
/* 1041 */     boolean createdBindings = false;
/* 1042 */     if (bindings == null)
/*      */     {
/* 1044 */       bindings = new ArrayList();
/* 1045 */       classMap.put(calledConHash, bindings);
/* 1046 */       createdBindings = true;
/*      */     }
/* 1048 */     if (!bindings.contains(binding)) bindings.add(binding);
/*      */ 
/* 1051 */     ArrayList backrefs = (ArrayList)this.backrefConCalledByConstructorBindings.get(binding.getName());
/* 1052 */     if (backrefs == null)
/*      */     {
/* 1054 */       backrefs = new ArrayList();
/* 1055 */       this.backrefConCalledByConstructorBindings.put(binding.getName(), backrefs);
/* 1056 */       backrefs.add(bindings);
/*      */     }
/* 1058 */     else if (createdBindings) { backrefs.add(bindings); }
/*      */   }
/*      */ 
/*      */   private void removeCallerPointcut(AdviceBinding binding)
/*      */   {
/* 1063 */     getMethodByMethodData().removeCallerPointcut(binding);
/*      */   }
/*      */ 
/*      */   public static String notAdvisedMethodName(String className, String methodName)
/*      */   {
/* 1072 */     return className.replace('.', '$') + "$" + methodName + "$aop";
/*      */   }
/*      */ 
/*      */   public static boolean isWithoutAdvisement(String name)
/*      */   {
/* 1081 */     return name.endsWith("$aop");
/*      */   }
/*      */ 
/*      */   public static boolean isAdvisable(Method method)
/*      */   {
/* 1090 */     int modifiers = method.getModifiers();
/* 1091 */     return (!isWithoutAdvisement(method.getName())) && (!Modifier.isAbstract(modifiers)) && (!Modifier.isNative(modifiers)) && ((!method.getName().equals("_getAdvisor")) || (method.getParameterTypes().length != 0) || (!method.getReturnType().equals(Advisor.class))) && ((!method.getName().equals("_getClassAdvisor")) || (method.getParameterTypes().length != 0) || (!method.getReturnType().equals(Advisor.class))) && ((!method.getName().equals("_getInstanceAdvisor")) || (method.getParameterTypes().length != 0) || (!method.getReturnType().equals(InstanceAdvisor.class))) && ((!method.getName().equals("_setInstanceAdvisor")) || (method.getParameterTypes().length != 1) || (!method.getParameterTypes()[0].equals(InstanceAdvisor.class)));
/*      */   }
/*      */ 
/*      */   private void populateFieldTable(ArrayList fields, Class superclass)
/*      */     throws Exception
/*      */   {
/* 1112 */     if (superclass == null) return;
/* 1113 */     if (superclass.equals(Object.class)) return;
/*      */ 
/* 1115 */     populateFieldTable(fields, superclass.getSuperclass());
/*      */ 
/* 1119 */     ArrayList temp = new ArrayList();
/* 1120 */     Field[] declaredFields = superclass.getDeclaredFields();
/* 1121 */     for (int i = 0; i < declaredFields.length; i++)
/*      */     {
/* 1123 */       if (!Advisable.isAdvisable(declaredFields[i])) {
/*      */         continue;
/*      */       }
/* 1126 */       declaredFields[i].setAccessible(true);
/* 1127 */       temp.add(declaredFields[i]);
/*      */     }
/*      */ 
/* 1130 */     Collections.sort(temp, FieldComparator.INSTANCE);
/* 1131 */     fields.addAll(temp);
/*      */   }
/*      */ 
/*      */   protected void createFieldTable()
/*      */     throws Exception
/*      */   {
/* 1139 */     ArrayList fields = new ArrayList();
/*      */ 
/* 1141 */     populateFieldTable(fields, this.clazz);
/*      */ 
/* 1143 */     this.advisedFields = ((Field[])(Field[])fields.toArray(new Field[fields.size()]));
/*      */   }
/*      */ 
/*      */   protected void addDeclaredMethods(Class superclass)
/*      */     throws Exception
/*      */   {
/* 1149 */     Method[] declaredMethods = superclass.getDeclaredMethods();
/* 1150 */     for (int i = 0; i < declaredMethods.length; i++)
/*      */     {
/* 1152 */       if (!isAdvisable(declaredMethods[i]))
/*      */         continue;
/* 1154 */       long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 1155 */       this.advisedMethods.put(hash, declaredMethods[i]);
/*      */       try
/*      */       {
/* 1158 */         Method m = declaredMethods[i];
/* 1159 */         Method un = superclass.getDeclaredMethod(notAdvisedMethodName(superclass.getName(), m.getName()), m.getParameterTypes());
/*      */ 
/* 1162 */         un.setAccessible(true);
/* 1163 */         this.unadvisedMethods.put(hash, un);
/*      */       }
/*      */       catch (NoSuchMethodException ignored)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void populateMethodTables(Class superclass)
/*      */     throws Exception
/*      */   {
/* 1180 */     if (superclass == null) return;
/* 1181 */     if (superclass.equals(Object.class)) return;
/*      */ 
/* 1183 */     populateMethodTables(superclass.getSuperclass());
/*      */ 
/* 1186 */     Advisor superAdvisor = this.manager.getAnyAdvisorIfAdvised(superclass);
/* 1187 */     if ((superAdvisor != null) && ((superAdvisor instanceof ClassAdvisor)))
/*      */     {
/* 1189 */       TLongObjectHashMap superHash = ((ClassAdvisor)superAdvisor).getUnadvisedMethods();
/* 1190 */       long[] keys = superHash.keys();
/* 1191 */       for (int i = 0; i < keys.length; i++)
/*      */       {
/* 1193 */         this.unadvisedMethods.put(keys[i], superHash.get(keys[i]));
/*      */       }
/*      */     }
/* 1196 */     addDeclaredMethods(superclass);
/*      */   }
/*      */ 
/*      */   protected void createMethodTables()
/*      */     throws Exception
/*      */   {
/* 1202 */     initAdvisedMethodsMap();
/* 1203 */     populateMethodTables(this.clazz.getSuperclass());
/* 1204 */     addDeclaredMethods(this.clazz);
/*      */   }
/*      */ 
/*      */   protected void createConstructorTables() throws Exception
/*      */   {
/* 1209 */     this.constructors = this.clazz.getDeclaredConstructors();
/* 1210 */     this.methodCalledByConBindings = new HashMap[this.constructors.length];
/* 1211 */     this.methodCalledByConInterceptors = new HashMap[this.constructors.length];
/*      */ 
/* 1213 */     this.conCalledByConBindings = new HashMap[this.constructors.length];
/* 1214 */     this.conCalledByConInterceptors = new HashMap[this.constructors.length];
/* 1215 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/* 1217 */       this.constructors[i].setAccessible(true);
/*      */     }
/* 1219 */     Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
/*      */   }
/*      */ 
/*      */   public MethodByMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */   {
/* 1224 */     return getMethodByMethodData().resolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
/*      */   }
/*      */ 
/*      */   public WeakReference resolveCallerMethodInfoAsWeakReference(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */   {
/* 1230 */     return new WeakReference(resolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash));
/*      */   }
/*      */ 
/*      */   public ConByMethodInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash)
/*      */   {
/* 1235 */     return getConByMethodData().resolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
/*      */   }
/*      */ 
/*      */   public WeakReference resolveCallerConstructorInfoAsWeakReference(long callingMethodHash, String calledClass, long calledConHash)
/*      */   {
/* 1241 */     return new WeakReference(resolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash));
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public MethodByConInfo resolveConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
/* 1247 */     return resolveConstructorCallerMethodInfo(getClazz(), callingIndex, calledClass, calledMethodHash);
/*      */   }
/*      */ 
/*      */   public MethodByConInfo resolveConstructorCallerMethodInfo(Class callingClass, int callingIndex, String calledClass, long calledMethodHash)
/*      */   {
/* 1252 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1254 */       return ResolveConstructorCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledMethodHash);
/*      */     }
/*      */ 
/* 1258 */     return ResolveConstructorCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledMethodHash);
/*      */   }
/*      */ 
/*      */   private MethodByConInfo doResolveConstructorCallerMethodInfo(Class callingClass, int callingIndex, String calledClass, long calledMethodHash)
/*      */   {
/*      */     try
/*      */     {
/* 1266 */       Constructor callingConstructor = this.constructors[callingIndex];
/* 1267 */       if (callingConstructor == null) throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
/*      */ 
/* 1269 */       Class called = SecurityActions.getContextClassLoader().loadClass(calledClass);
/* 1270 */       Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
/* 1271 */       if (calledMethod == null) throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
/*      */ 
/* 1273 */       boolean matched = false;
/*      */ 
/* 1275 */       synchronized (this.manager.getBindings())
/*      */       {
/* 1277 */         Iterator it = this.manager.getBindings().values().iterator();
/* 1278 */         while (it.hasNext())
/*      */         {
/* 1280 */           AdviceBinding binding = (AdviceBinding)it.next();
/* 1281 */           if (binding.getPointcut().matchesCall(this, callingConstructor, called, calledMethod))
/*      */           {
/* 1283 */             addConstructorCallerPointcut(callingIndex, calledClass, calledMethodHash, binding);
/* 1284 */             matched = true;
/*      */           }
/*      */         }
/*      */       }
/* 1288 */       if (!matched) initializeEmptyConstructorCallerChain(callingIndex, calledClass, calledMethodHash);
/* 1289 */       MethodByConInfo info = initializeConstructorCallerInterceptorsMap(callingClass, callingIndex, calledClass, calledMethodHash, calledMethod);
/* 1290 */       ArrayList bindings = getConstructorCallerBindings(callingIndex, calledClass, calledMethodHash);
/* 1291 */       bindConstructorCallerInterceptorChain(bindings, callingIndex, calledClass, calledMethodHash);
/* 1292 */       return info;
/*      */     }
/*      */     catch (Exception x) {
/*      */     }
/* 1296 */     throw new RuntimeException(x);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public WeakReference resolveConstructorCallerMethodInfoAsWeakReference(int callingIndex, String calledClass, long calledMethodHash)
/*      */   {
/* 1304 */     return new WeakReference(resolveConstructorCallerMethodInfo(callingIndex, calledClass, calledMethodHash));
/*      */   }
/*      */ 
/*      */   public WeakReference resolveConstructorCallerMethodInfoAsWeakReference(Class callingClass, int callingIndex, String calledClass, long calledMethodHash)
/*      */   {
/* 1310 */     return new WeakReference(resolveConstructorCallerMethodInfo(callingClass, callingIndex, calledClass, calledMethodHash));
/*      */   }
/*      */ 
/*      */   public ConByConInfo resolveConstructorCallerConstructorInfo(int callingIndex, String calledClass, long calledConHash)
/*      */   {
/* 1315 */     return resolveConstructorCallerConstructorInfo(getClazz(), callingIndex, calledClass, calledConHash);
/*      */   }
/*      */ 
/*      */   public ConByConInfo resolveConstructorCallerConstructorInfo(Class callingClass, int callingIndex, String calledClass, long calledConHash)
/*      */   {
/* 1320 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1322 */       return ResolveConstructorCallerConstructorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledConHash);
/*      */     }
/*      */ 
/* 1326 */     return ResolveConstructorCallerConstructorInfoAction.PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledConHash);
/*      */   }
/*      */ 
/*      */   private ConByConInfo doResolveConstructorCallerConstructorInfo(Class callingClass, int callingIndex, String calledClass, long calledConHash)
/*      */   {
/*      */     try
/*      */     {
/* 1334 */       Constructor callingConstructor = this.constructors[callingIndex];
/* 1335 */       if (callingConstructor == null) throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
/*      */ 
/* 1337 */       Class called = SecurityActions.getContextClassLoader().loadClass(calledClass);
/* 1338 */       Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
/* 1339 */       if (calledCon == null) throw new RuntimeException("Unable to figure out calledcon of a caller pointcut");
/*      */ 
/* 1341 */       boolean matched = false;
/* 1342 */       synchronized (this.manager.getBindings())
/*      */       {
/* 1344 */         Iterator it = this.manager.getBindings().values().iterator();
/* 1345 */         while (it.hasNext())
/*      */         {
/* 1347 */           AdviceBinding binding = (AdviceBinding)it.next();
/* 1348 */           if (binding.getPointcut().matchesCall(this, callingConstructor, called, calledCon))
/*      */           {
/* 1350 */             addConstructorCalledByConPointcut(callingIndex, calledClass, calledConHash, binding);
/* 1351 */             matched = true;
/*      */           }
/*      */         }
/*      */       }
/* 1355 */       if (!matched) initializeConCalledByConEmptyChain(callingIndex, calledClass, calledConHash);
/* 1356 */       ConByConInfo info = initializeConCalledByConInterceptorsMap(callingClass, callingIndex, calledClass, calledConHash, calledCon);
/* 1357 */       ArrayList bindings = getConCalledByConBindings(callingIndex, calledClass, calledConHash);
/* 1358 */       bindConCalledByConInterceptorChain(bindings, callingIndex, calledClass, calledConHash);
/* 1359 */       return info;
/*      */     }
/*      */     catch (Exception x) {
/*      */     }
/* 1363 */     throw new RuntimeException(x);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public WeakReference resolveConstructorCallerConstructorInfoAsWeakReference(int callingIndex, String calledClass, long calledConHash)
/*      */   {
/* 1371 */     return new WeakReference(resolveConstructorCallerConstructorInfo(callingIndex, calledClass, calledConHash));
/*      */   }
/*      */ 
/*      */   public WeakReference resolveConstructorCallerConstructorInfoAsWeakReference(Class callingClass, int callingIndex, String calledClass, long calledConHash)
/*      */   {
/* 1377 */     return new WeakReference(resolveConstructorCallerConstructorInfo(callingClass, callingIndex, calledClass, calledConHash));
/*      */   }
/*      */ 
/*      */   public Object invokeWithoutAdvisement(Object target, long methodHash, Object[] arguments)
/*      */     throws Throwable
/*      */   {
/*      */     try
/*      */     {
/* 1391 */       Method method = (Method)this.unadvisedMethods.get(methodHash);
/* 1392 */       return method.invoke(target, arguments);
/*      */     }
/*      */     catch (InvocationTargetException e) {
/*      */     }
/* 1396 */     throw e.getTargetException();
/*      */   }
/*      */ 
/*      */   public Object invokeNewWithoutAdvisement(Object[] arguments, Constructor constructor)
/*      */     throws Throwable
/*      */   {
/*      */     try
/*      */     {
/* 1404 */       return constructor.newInstance(arguments);
/*      */     }
/*      */     catch (InstantiationException in)
/*      */     {
/* 1408 */       throw new RuntimeException("failed to call constructor", in);
/*      */     }
/*      */     catch (IllegalAccessException ill)
/*      */     {
/* 1412 */       throw new RuntimeException("illegal access", ill);
/*      */     }
/*      */     catch (InvocationTargetException ite) {
/*      */     }
/* 1416 */     throw ite.getCause();
/*      */   }
/*      */ 
/*      */   public Object invokeMethod(long methodHash, Object[] arguments)
/*      */     throws Throwable
/*      */   {
/* 1423 */     return invokeMethod(null, methodHash, arguments);
/*      */   }
/*      */ 
/*      */   public Object invokeMethod(Object target, long methodHash, Object[] arguments) throws Throwable
/*      */   {
/* 1428 */     InstanceAdvisor advisor = null;
/* 1429 */     if (target != null)
/*      */     {
/* 1431 */       InstanceAdvised advised = (InstanceAdvised)target;
/* 1432 */       advisor = advised._getInstanceAdvisor();
/*      */     }
/* 1434 */     MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
/* 1435 */     return invokeMethod(advisor, target, methodHash, arguments, info);
/*      */   }
/*      */ 
/*      */   public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments)
/*      */     throws Throwable
/*      */   {
/* 1442 */     MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
/* 1443 */     if ((info == null) && (logger.isDebugEnabled()))
/*      */     {
/* 1445 */       logger.debug("info is null for hash: " + methodHash + " of " + this.clazz.getName());
/*      */     }
/* 1447 */     return invokeMethod(instanceAdvisor, target, methodHash, arguments, info);
/*      */   }
/*      */ 
/*      */   public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments, MethodInfo info)
/*      */     throws Throwable
/*      */   {
/* 1453 */     Interceptor[] aspects = info.getInterceptors();
/* 1454 */     if ((instanceAdvisor != null) && (instanceAdvisor.hasInterceptors()))
/*      */     {
/* 1456 */       aspects = instanceAdvisor.getInterceptors(aspects);
/*      */     }
/* 1458 */     MethodInvocation invocation = new MethodInvocation(info, aspects);
/*      */ 
/* 1460 */     invocation.setArguments(arguments);
/* 1461 */     invocation.setTargetObject(target);
/* 1462 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeCaller(long callingMethodHash, Object target, Object[] args, CallerMethodInfo info, Object callingObject)
/*      */     throws Throwable
/*      */   {
/* 1471 */     return invokeCaller((MethodByMethodInfo)info, callingObject, target, args);
/*      */   }
/*      */ 
/*      */   public Object invokeCaller(MethodByMethodInfo info, Object callingObject, Object target, Object[] args) throws Throwable
/*      */   {
/* 1476 */     MethodCalledByMethodInvocation invocation = new MethodCalledByMethodInvocation(info, callingObject, target, args, info.getInterceptors());
/* 1477 */     invocation.setTargetObject(target);
/* 1478 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConCalledByMethod(long callingMethodHash, Object[] args, CallerConstructorInfo info, Object callingObject)
/*      */     throws Throwable
/*      */   {
/* 1487 */     return invokeConCalledByMethod((ConByMethodInfo)info, callingObject, args);
/*      */   }
/*      */ 
/*      */   public Object invokeConCalledByMethod(ConByMethodInfo info, Object callingObject, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1493 */     ConstructorCalledByMethodInvocation invocation = new ConstructorCalledByMethodInvocation(info, callingObject, args, info.getInterceptors());
/* 1494 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConstructorCaller(int callingIndex, Object target, Object[] args, CallerMethodInfo info)
/*      */     throws Throwable
/*      */   {
/* 1503 */     return invokeConstructorCaller((MethodByConInfo)info, null, target, args);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConstructorCaller(int callingIndex, Object callingObject, Object target, Object[] args, CallerMethodInfo info)
/*      */     throws Throwable
/*      */   {
/* 1512 */     return invokeConstructorCaller((MethodByConInfo)info, callingObject, target, args);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConstructorCaller(MethodByConInfo info, Object target, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1526 */     return invokeConstructorCaller(info, null, target, args);
/*      */   }
/*      */ 
/*      */   public Object invokeConstructorCaller(MethodByConInfo info, Object callingObject, Object target, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1532 */     MethodCalledByConstructorInvocation invocation = new MethodCalledByConstructorInvocation(info, callingObject, target, args, info.getInterceptors());
/* 1533 */     invocation.setTargetObject(target);
/* 1534 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConCalledByCon(int callingIndex, Object[] args, CallerConstructorInfo info)
/*      */     throws Throwable
/*      */   {
/* 1543 */     return invokeConCalledByCon((ConByConInfo)info, null, args);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConCalledByCon(int callingIndex, Object callingObject, Object[] args, CallerConstructorInfo info)
/*      */     throws Throwable
/*      */   {
/* 1552 */     return invokeConCalledByCon((ConByConInfo)info, callingObject, args);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Object invokeConCalledByCon(ConByConInfo info, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1566 */     return invokeConCalledByCon(info, null, args);
/*      */   }
/*      */ 
/*      */   public Object invokeConCalledByCon(ConByConInfo info, Object callingObject, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1572 */     ConstructorCalledByConstructorInvocation invocation = new ConstructorCalledByConstructorInvocation(info, callingObject, args, info.getInterceptors());
/* 1573 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private MethodByConInfo getConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash)
/*      */   {
/* 1578 */     HashMap calledClasses = this.methodCalledByConInterceptors[callingIndex];
/* 1579 */     TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
/* 1580 */     MethodByConInfo info = (MethodByConInfo)calledMethods.get(calledMethodHash);
/* 1581 */     return info;
/*      */   }
/*      */ 
/*      */   private ConByConInfo getConCalledByCon(int callingIndex, String calledClass, long calledConHash)
/*      */   {
/* 1586 */     HashMap calledClasses = this.conCalledByConInterceptors[callingIndex];
/* 1587 */     TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
/* 1588 */     ConByConInfo info = (ConByConInfo)calledMethods.get(calledConHash);
/* 1589 */     return info;
/*      */   }
/*      */ 
/*      */   public Object invokeNew(Object[] args, int idx)
/*      */     throws Throwable
/*      */   {
/* 1595 */     Interceptor[] cInterceptors = this.constructorInfos[idx].getInterceptors();
/* 1596 */     if (cInterceptors == null) cInterceptors = new Interceptor[0];
/* 1597 */     ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
/*      */ 
/* 1599 */     invocation.setAdvisor(this);
/* 1600 */     invocation.setArguments(args);
/* 1601 */     invocation.setConstructor(this.constructors[idx]);
/* 1602 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public Object invokeRead(Object target, int index)
/*      */     throws Throwable
/*      */   {
/* 1612 */     Interceptor[] aspects = this.fieldReadInfos[index].getInterceptors();
/* 1613 */     if (aspects == null) aspects = new Interceptor[0];
/*      */ 
/* 1615 */     if (target != null)
/*      */     {
/* 1617 */       InstanceAdvised advised = (InstanceAdvised)target;
/* 1618 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/* 1619 */       if ((advisor != null) && (advisor.hasInterceptors()))
/*      */       {
/* 1621 */         aspects = advisor.getInterceptors(aspects);
/*      */       }
/*      */     }
/* 1624 */     FieldReadInvocation invocation = new FieldReadInvocation(this.advisedFields[index], index, aspects);
/* 1625 */     invocation.setAdvisor(this);
/* 1626 */     invocation.setTargetObject(target);
/* 1627 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public Object invokeWrite(Object target, int index, Object value)
/*      */     throws Throwable
/*      */   {
/* 1637 */     Interceptor[] aspects = this.fieldWriteInfos[index].getInterceptors();
/* 1638 */     if (aspects == null) aspects = new Interceptor[0];
/*      */ 
/* 1640 */     if (target != null)
/*      */     {
/* 1642 */       InstanceAdvised advised = (InstanceAdvised)target;
/* 1643 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/* 1644 */       if ((advisor != null) && (advisor.hasInterceptors()))
/*      */       {
/* 1646 */         aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
/*      */       }
/*      */     }
/* 1649 */     FieldWriteInvocation invocation = new FieldWriteInvocation(this.advisedFields[index], index, value, aspects);
/* 1650 */     invocation.setAdvisor(this);
/* 1651 */     invocation.setTargetObject(target);
/* 1652 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public Object invoke(Invocation invocation)
/*      */     throws Throwable
/*      */   {
/* 1661 */     if ((invocation instanceof FieldWriteInvocation))
/*      */     {
/* 1663 */       FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
/* 1664 */       Object target = fieldInvocation.getTargetObject();
/* 1665 */       Object val = fieldInvocation.getValue();
/* 1666 */       Field field = fieldInvocation.getField();
/* 1667 */       field.set(target, val);
/* 1668 */       return null;
/*      */     }
/* 1670 */     if ((invocation instanceof FieldReadInvocation))
/*      */     {
/* 1672 */       FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
/* 1673 */       Object target = fieldInvocation.getTargetObject();
/* 1674 */       Field field = fieldInvocation.getField();
/* 1675 */       return field.get(target);
/*      */     }
/* 1677 */     if ((invocation instanceof MethodInvocation))
/*      */     {
/* 1679 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 1680 */       return invokeWithoutAdvisement(methodInvocation.getTargetObject(), methodInvocation.getMethodHash(), methodInvocation.getArguments());
/*      */     }
/*      */ 
/* 1684 */     if ((invocation instanceof ConstructorInvocation))
/*      */     {
/* 1686 */       ConstructorInvocation cInvocation = (ConstructorInvocation)invocation;
/* 1687 */       Object[] arguments = cInvocation.getArguments();
/* 1688 */       Constructor constructor = cInvocation.getConstructor();
/* 1689 */       return invokeNewWithoutAdvisement(arguments, constructor);
/*      */     }
/* 1691 */     throw new IllegalStateException("Unknown Invocation type: " + invocation.getClass().getName());
/*      */   }
/*      */ 
/*      */   public void cleanup()
/*      */   {
/* 1697 */     super.cleanup();
/* 1698 */     if (this.methodByMethodData != null)
/*      */     {
/* 1700 */       this.methodByMethodData.cleanup();
/* 1701 */       this.methodByMethodData = null;
/*      */     }
/* 1703 */     if (this.conByMethodData != null)
/*      */     {
/* 1705 */       this.conByMethodData.cleanup();
/* 1706 */       this.conByMethodData = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected InterceptorChainObserver getInterceptorChainObserver()
/*      */   {
/* 1718 */     return this.interceptorChainObserver;
/*      */   }
/*      */ 
/*      */   protected void setInterceptorChainObserver(InterceptorChainObserver observer)
/*      */   {
/* 1727 */     if (observer != null)
/*      */     {
/* 1729 */       observer.initialInterceptorChains(this.clazz, this.fieldReadInterceptors, this.fieldWriteInterceptors, this.constructorInterceptors, this.methodInterceptors);
/*      */     }
/*      */ 
/* 1732 */     this.interceptorChainObserver = observer;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   protected void populateInterceptorsFromInfos() {
/* 1738 */     super.populateInterceptorsFromInfos();
/* 1739 */     this.fieldReadInterceptors = new Interceptor[this.fieldReadInfos.length][];
/* 1740 */     for (int i = 0; i < this.fieldReadInfos.length; i++)
/*      */     {
/* 1742 */       this.fieldReadInterceptors[i] = this.fieldReadInfos[i].getInterceptors();
/*      */     }
/* 1744 */     this.fieldWriteInterceptors = new Interceptor[this.fieldWriteInfos.length][];
/* 1745 */     for (int i = 0; i < this.fieldWriteInfos.length; i++)
/*      */     {
/* 1747 */       this.fieldWriteInterceptors[i] = this.fieldWriteInfos[i].getInterceptors();
/*      */     }
/* 1749 */     this.constructionInterceptors = new Interceptor[this.constructionInfos.length][];
/* 1750 */     for (int i = 0; i < this.constructionInfos.length; i++)
/*      */     {
/* 1752 */       this.constructionInterceptors[i] = this.constructionInfos[i].getInterceptors();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected MethodByMethodData getMethodByMethodData()
/*      */   {
/* 1759 */     if (this.methodByMethodData == null)
/*      */     {
/* 1761 */       lockWrite();
/*      */       try
/*      */       {
/* 1764 */         if (this.methodByMethodData == null)
/*      */         {
/* 1766 */           this.methodByMethodData = new MethodByMethodData(null);
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1771 */         unlockWrite();
/*      */       }
/*      */     }
/* 1774 */     return this.methodByMethodData;
/*      */   }
/*      */ 
/*      */   protected ConByMethodData getConByMethodData()
/*      */   {
/* 1779 */     if (this.conByMethodData == null)
/*      */     {
/* 1781 */       lockWrite();
/*      */       try
/*      */       {
/* 1784 */         if (this.conByMethodData == null)
/*      */         {
/* 1786 */           this.conByMethodData = new ConByMethodData(null);
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1791 */         unlockWrite();
/*      */       }
/*      */     }
/* 1794 */     return this.conByMethodData;
/*      */   }
/*      */ 
/*      */   private class ConByMethodData
/*      */   {
/* 2251 */     private volatile TLongObjectHashMap conCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
/* 2252 */     private volatile HashMap backrefConCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/* 2253 */     private volatile TLongObjectHashMap conCalledByMethodInterceptors = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
/*      */ 
/*      */     private ConByMethodData() {
/*      */     }
/* 2257 */     public TLongObjectHashMap getConCalledByMethodInterceptors() { return this.conCalledByMethodInterceptors;
/*      */     }
/*      */ 
/*      */     public ArrayList getConCalledByMethodBindings(long callingHash, String cname, long calledHash)
/*      */     {
/* 2262 */       HashMap calledClasses = (HashMap)this.conCalledByMethodBindings.get(callingHash);
/* 2263 */       TLongObjectHashMap calledCons = (TLongObjectHashMap)calledClasses.get(cname);
/* 2264 */       return (ArrayList)calledCons.get(calledHash);
/*      */     }
/*      */ 
/*      */     public void rebuildCallerInterceptors() throws Exception
/*      */     {
/* 2269 */       long[] callingKeys = this.conCalledByMethodInterceptors.keys();
/* 2270 */       for (int i = 0; i < callingKeys.length; i++)
/*      */       {
/* 2272 */         long callingHash = callingKeys[i];
/* 2273 */         HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingHash);
/* 2274 */         Iterator classesIterator = calledClasses.entrySet().iterator();
/* 2275 */         while (classesIterator.hasNext())
/*      */         {
/* 2277 */           Map.Entry entry = (Map.Entry)classesIterator.next();
/* 2278 */           String cname = (String)entry.getKey();
/* 2279 */           TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
/* 2280 */           long[] calledKeys = calledMethods.keys();
/* 2281 */           for (int j = 0; j < calledKeys.length; j++)
/*      */           {
/* 2283 */             long calledHash = calledKeys[j];
/* 2284 */             ArrayList bindings = getConCalledByMethodBindings(callingHash, cname, calledHash);
/* 2285 */             bindConCalledByMethodInterceptorChain(bindings, callingHash, cname, calledHash);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public ConByMethodInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash)
/*      */     {
/* 2294 */       if ((this.conCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) || (this.backrefConCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP) || (this.conCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP))
/*      */       {
/* 2298 */         ClassAdvisor.this.lockWrite();
/*      */         try
/*      */         {
/* 2301 */           if (this.conCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */           {
/* 2303 */             this.conCalledByMethodBindings = new TLongObjectHashMap();
/*      */           }
/* 2305 */           if (this.backrefConCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */           {
/* 2307 */             this.backrefConCalledByMethodBindings = new HashMap();
/*      */           }
/* 2309 */           if (this.conCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */           {
/* 2311 */             this.conCalledByMethodInterceptors = new TLongObjectHashMap();
/*      */           }
/*      */         }
/*      */         finally
/*      */         {
/* 2316 */           ClassAdvisor.this.unlockWrite();
/*      */         }
/*      */       }
/*      */ 
/* 2320 */       if (System.getSecurityManager() == null)
/*      */       {
/* 2322 */         return ClassAdvisor.ResolveCallerConstuctorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
/*      */       }
/*      */ 
/* 2326 */       return ClassAdvisor.ResolveCallerConstuctorInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
/*      */     }
/*      */ 
/*      */     private ConByMethodInfo doResolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash)
/*      */     {
/*      */       try
/*      */       {
/* 2334 */         Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingMethodHash);
/* 2335 */         if (callingMethod == null) throw new RuntimeException("Unable to figure out calling method of a constructor caller pointcut");
/*      */ 
/* 2337 */         Class called = SecurityActions.getContextClassLoader().loadClass(calledClass);
/* 2338 */         Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
/* 2339 */         if (calledCon == null) throw new RuntimeException("Unable to figure out calledcon of a constructor caller pointcut");
/*      */ 
/* 2341 */         boolean matched = false;
/* 2342 */         synchronized (ClassAdvisor.this.manager.getBindings())
/*      */         {
/* 2344 */           Iterator it = ClassAdvisor.this.manager.getBindings().values().iterator();
/* 2345 */           while (it.hasNext())
/*      */           {
/* 2347 */             AdviceBinding binding = (AdviceBinding)it.next();
/* 2348 */             if (binding.getPointcut().matchesCall(ClassAdvisor.this, callingMethod, called, calledCon))
/*      */             {
/* 2350 */               addConstructorCalledByMethodPointcut(callingMethodHash, calledClass, calledConHash, binding);
/* 2351 */               matched = true;
/*      */             }
/*      */           }
/*      */         }
/* 2355 */         if (!matched) initializeConCalledByMethodEmptyChain(callingMethodHash, calledClass, calledConHash);
/* 2356 */         ConByMethodInfo info = initializeConCalledByMethodInterceptorsMap(callingMethod, callingMethodHash, calledClass, calledConHash, calledCon);
/* 2357 */         ArrayList bindings = getConCalledByMethodBindings(callingMethodHash, calledClass, calledConHash);
/* 2358 */         bindConCalledByMethodInterceptorChain(bindings, callingMethodHash, calledClass, calledConHash);
/* 2359 */         return info;
/*      */       }
/*      */       catch (Exception x) {
/*      */       }
/* 2363 */       throw new RuntimeException(x);
/*      */     }
/*      */ 
/*      */     private void addConstructorCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding)
/*      */       throws Exception
/*      */     {
/* 2369 */       if (AspectManager.verbose) System.err.println("method call matched binding " + binding.getPointcut().getExpr());
/* 2370 */       ClassAdvisor.this.adviceBindings.add(binding);
/* 2371 */       binding.addAdvisor(ClassAdvisor.this);
/* 2372 */       HashMap callingMethod = (HashMap)this.conCalledByMethodBindings.get(callingMethodHash);
/* 2373 */       if (callingMethod == null)
/*      */       {
/* 2375 */         callingMethod = new HashMap();
/* 2376 */         this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
/*      */       }
/* 2378 */       TLongObjectHashMap classMap = (TLongObjectHashMap)callingMethod.get(calledClass);
/* 2379 */       if (classMap == null)
/*      */       {
/* 2381 */         classMap = new TLongObjectHashMap();
/* 2382 */         callingMethod.put(calledClass, classMap);
/*      */       }
/* 2384 */       ArrayList bindings = (ArrayList)classMap.get(calledMethodHash);
/* 2385 */       boolean createdBindings = false;
/* 2386 */       if (bindings == null)
/*      */       {
/* 2388 */         bindings = new ArrayList();
/* 2389 */         classMap.put(calledMethodHash, bindings);
/* 2390 */         createdBindings = true;
/*      */       }
/* 2392 */       if (!bindings.contains(binding)) bindings.add(binding);
/*      */ 
/* 2395 */       ArrayList backrefs = (ArrayList)this.backrefConCalledByMethodBindings.get(binding.getName());
/* 2396 */       if (backrefs == null)
/*      */       {
/* 2398 */         backrefs = new ArrayList();
/* 2399 */         this.backrefConCalledByMethodBindings.put(binding.getName(), backrefs);
/* 2400 */         backrefs.add(bindings);
/*      */       }
/* 2402 */       else if (createdBindings) { backrefs.add(bindings); }
/*      */     }
/*      */ 
/*      */     private ConByMethodInfo initializeConCalledByMethodInterceptorsMap(Method callingMethod, long callingMethodHash, String calledClass, long calledConHash, Constructor calledCon) throws Exception
/*      */     {
/* 2407 */       HashMap calledClassesMap = (HashMap)this.conCalledByMethodInterceptors.get(callingMethodHash);
/* 2408 */       if (calledClassesMap == null)
/*      */       {
/* 2410 */         calledClassesMap = new HashMap();
/* 2411 */         this.conCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
/*      */       }
/* 2413 */       TLongObjectHashMap calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass);
/* 2414 */       if (calledMethodsMap == null)
/*      */       {
/* 2416 */         calledMethodsMap = new TLongObjectHashMap();
/* 2417 */         calledClassesMap.put(calledClass, calledMethodsMap);
/*      */       }
/*      */ 
/* 2420 */       ConByMethodInfo info = createConByMethodInfo(calledClass, callingMethod, callingMethodHash, calledCon, calledConHash);
/* 2421 */       calledMethodsMap.put(calledConHash, info);
/* 2422 */       return info;
/*      */     }
/*      */ 
/*      */     private void initializeConCalledByMethodEmptyChain(long callingMethodHash, String calledClass, long calledConHash) throws Exception
/*      */     {
/* 2427 */       HashMap callingMethod = (HashMap)this.conCalledByMethodBindings.get(callingMethodHash);
/* 2428 */       if (callingMethod == null)
/*      */       {
/* 2430 */         callingMethod = new HashMap();
/* 2431 */         this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
/*      */       }
/* 2433 */       TLongObjectHashMap classMap = (TLongObjectHashMap)callingMethod.get(calledClass);
/* 2434 */       if (classMap == null)
/*      */       {
/* 2436 */         classMap = new TLongObjectHashMap();
/* 2437 */         callingMethod.put(calledClass, classMap);
/*      */       }
/* 2439 */       ArrayList bindings = (ArrayList)classMap.get(calledConHash);
/* 2440 */       if (bindings == null)
/*      */       {
/* 2442 */         bindings = new ArrayList();
/* 2443 */         classMap.put(calledConHash, bindings);
/*      */       }
/*      */     }
/*      */ 
/*      */     private ConByMethodInfo getConCalledByMethod(long callingMethodHash, String calledClass, long calledConHash)
/*      */     {
/* 2449 */       HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingMethodHash);
/* 2450 */       TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
/* 2451 */       ConByMethodInfo info = (ConByMethodInfo)calledMethods.get(calledConHash);
/* 2452 */       return info;
/*      */     }
/*      */ 
/*      */     private ConByMethodInfo createConByMethodInfo(String calledClass, Method callingMethod, long callingMethodHash, Constructor calledCon, long calledConHash)
/*      */       throws Exception
/*      */     {
/* 2458 */       calledCon.setAccessible(true);
/*      */ 
/* 2461 */       Class calledClazz = SecurityActions.getContextClassLoader().loadClass(calledClass);
/*      */       try
/*      */       {
/* 2464 */         int index = calledClass.lastIndexOf('.');
/* 2465 */         String baseClassName = calledClass.substring(index + 1);
/* 2466 */         Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
/* 2467 */         return new ConByMethodInfo(ClassAdvisor.this, calledClazz, callingMethod, callingMethodHash, calledCon, calledConHash, wrapper, null);
/*      */       }
/*      */       catch (NoSuchMethodException e) {
/*      */       }
/* 2471 */       return new ConByMethodInfo(ClassAdvisor.this, calledClazz, callingMethod, callingMethodHash, calledCon, calledConHash, null, null);
/*      */     }
/*      */ 
/*      */     private void bindConCalledByMethodInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash)
/*      */       throws Exception
/*      */     {
/* 2477 */       ConByMethodInfo info = getConCalledByMethod(callingHash, cname, calledHash);
/* 2478 */       info.clear();
/* 2479 */       Iterator it = bindings.iterator();
/* 2480 */       while (it.hasNext())
/*      */       {
/* 2482 */         AdviceBinding binding = (AdviceBinding)it.next();
/* 2483 */         ClassAdvisor.this.pointcutResolved(info, binding, new ConstructorCalledByMethodJoinpoint(info.getCallingMethod(), info.getConstructor()));
/*      */       }
/* 2485 */       ClassAdvisor.this.finalizeConCalledByMethodInterceptorChain(info);
/*      */     }
/*      */ 
/*      */     public void cleanup()
/*      */     {
/* 2490 */       this.conCalledByMethodBindings.clear();
/* 2491 */       this.conCalledByMethodInterceptors.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   private class MethodByMethodData
/*      */   {
/* 1994 */     private volatile TLongObjectHashMap methodCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
/* 1995 */     private volatile HashMap backrefMethodCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/* 1996 */     private volatile TLongObjectHashMap methodCalledByMethodInterceptors = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
/*      */ 
/*      */     private MethodByMethodData() {
/*      */     }
/*      */     public TLongObjectHashMap getMethodCalledByMethodInterceptors() {
/* 2001 */       return this.methodCalledByMethodInterceptors;
/*      */     }
/*      */ 
/*      */     public TLongObjectHashMap getMethodCalledByMethodBindings()
/*      */     {
/* 2007 */       return this.methodCalledByMethodBindings;
/*      */     }
/*      */ 
/*      */     public void rebuildCallerInterceptors()
/*      */       throws Exception
/*      */     {
/* 2013 */       long[] callingKeys = this.methodCalledByMethodInterceptors.keys();
/* 2014 */       for (int i = 0; i < callingKeys.length; i++)
/*      */       {
/* 2016 */         long callingHash = callingKeys[i];
/* 2017 */         HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingHash);
/* 2018 */         Iterator classesIterator = calledClasses.entrySet().iterator();
/* 2019 */         while (classesIterator.hasNext())
/*      */         {
/* 2021 */           Map.Entry entry = (Map.Entry)classesIterator.next();
/* 2022 */           String cname = (String)entry.getKey();
/* 2023 */           TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
/* 2024 */           long[] calledKeys = calledMethods.keys();
/* 2025 */           for (int j = 0; j < calledKeys.length; j++)
/*      */           {
/* 2027 */             long calledHash = calledKeys[j];
/* 2028 */             ArrayList bindings = getCallerBindings(callingHash, cname, calledHash);
/* 2029 */             Method calling = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingHash);
/* 2030 */             bindCallerInterceptorChain(bindings, callingHash, cname, calledHash, calling);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public void removeCallerPointcut(AdviceBinding binding)
/*      */     {
/* 2039 */       ArrayList backrefs = (ArrayList)this.backrefMethodCalledByMethodBindings.get(binding.getName());
/* 2040 */       if (backrefs == null) return;
/* 2041 */       for (int i = 0; i < backrefs.size(); i++)
/*      */       {
/* 2043 */         ArrayList ref = (ArrayList)backrefs.get(i);
/* 2044 */         ref.remove(binding);
/*      */       }
/*      */     }
/*      */ 
/*      */     public MethodByMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */     {
/* 2051 */       if ((this.methodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) || (this.backrefMethodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP) || (this.methodCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP))
/*      */       {
/* 2055 */         ClassAdvisor.this.lockWrite();
/*      */         try
/*      */         {
/* 2058 */           if (this.methodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */           {
/* 2060 */             this.methodCalledByMethodBindings = new TLongObjectHashMap();
/*      */           }
/* 2062 */           if (this.backrefMethodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */           {
/* 2064 */             this.backrefMethodCalledByMethodBindings = new HashMap();
/*      */           }
/* 2066 */           if (this.methodCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */           {
/* 2068 */             this.methodCalledByMethodInterceptors = new TLongObjectHashMap();
/*      */           }
/*      */         }
/*      */         finally
/*      */         {
/* 2073 */           ClassAdvisor.this.unlockWrite();
/*      */         }
/*      */       }
/*      */ 
/* 2077 */       if (System.getSecurityManager() == null)
/*      */       {
/* 2079 */         return ClassAdvisor.ResolveCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
/*      */       }
/*      */ 
/* 2083 */       return ClassAdvisor.ResolveCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
/*      */     }
/*      */ 
/*      */     private MethodByMethodInfo doResolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */     {
/*      */       try
/*      */       {
/* 2092 */         Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingMethodHash);
/* 2093 */         if (callingMethod == null) throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
/*      */ 
/* 2095 */         Class called = SecurityActions.getContextClassLoader().loadClass(calledClass);
/* 2096 */         Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
/* 2097 */         if (calledMethod == null) throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
/*      */ 
/* 2099 */         Iterator it = ClassAdvisor.this.manager.getBindings().values().iterator();
/* 2100 */         boolean matched = false;
/* 2101 */         while (it.hasNext())
/*      */         {
/* 2103 */           AdviceBinding binding = (AdviceBinding)it.next();
/* 2104 */           if (binding.getPointcut().matchesCall(ClassAdvisor.this, callingMethod, called, calledMethod))
/*      */           {
/* 2106 */             addMethodCalledByMethodPointcut(callingMethodHash, calledClass, calledMethodHash, binding);
/* 2107 */             matched = true;
/*      */           }
/*      */         }
/* 2110 */         if (!matched) initializeEmptyCallerChain(callingMethodHash, calledClass, calledMethodHash);
/* 2111 */         MethodByMethodInfo info = initializeCallerInterceptorsMap(callingMethodHash, calledClass, calledMethodHash, callingMethod, calledMethod);
/* 2112 */         ArrayList bindings = getCallerBindings(callingMethodHash, calledClass, calledMethodHash);
/* 2113 */         bindCallerInterceptorChain(bindings, callingMethodHash, calledClass, calledMethodHash, callingMethod);
/* 2114 */         return info;
/*      */       }
/*      */       catch (Exception x) {
/*      */       }
/* 2118 */       throw new RuntimeException(x);
/*      */     }
/*      */ 
/*      */     private void addMethodCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding)
/*      */       throws Exception
/*      */     {
/* 2125 */       if (AspectManager.verbose) System.err.println("method call matched binding " + binding.getPointcut().getExpr());
/* 2126 */       ClassAdvisor.this.adviceBindings.add(binding);
/* 2127 */       binding.addAdvisor(ClassAdvisor.this);
/* 2128 */       HashMap callingMethod = (HashMap)this.methodCalledByMethodBindings.get(callingMethodHash);
/* 2129 */       if (callingMethod == null)
/*      */       {
/* 2131 */         callingMethod = new HashMap();
/* 2132 */         this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
/*      */       }
/* 2134 */       TLongObjectHashMap classMap = (TLongObjectHashMap)callingMethod.get(calledClass);
/* 2135 */       if (classMap == null)
/*      */       {
/* 2137 */         classMap = new TLongObjectHashMap();
/* 2138 */         callingMethod.put(calledClass, classMap);
/*      */       }
/* 2140 */       ArrayList bindings = (ArrayList)classMap.get(calledMethodHash);
/* 2141 */       boolean createdBindings = false;
/* 2142 */       if (bindings == null)
/*      */       {
/* 2144 */         bindings = new ArrayList();
/* 2145 */         classMap.put(calledMethodHash, bindings);
/* 2146 */         createdBindings = true;
/*      */       }
/* 2148 */       if (!bindings.contains(binding)) bindings.add(binding);
/*      */ 
/* 2151 */       ArrayList backrefs = (ArrayList)this.backrefMethodCalledByMethodBindings.get(binding.getName());
/* 2152 */       if (backrefs == null)
/*      */       {
/* 2154 */         backrefs = new ArrayList();
/* 2155 */         this.backrefMethodCalledByMethodBindings.put(binding.getName(), backrefs);
/* 2156 */         backrefs.add(bindings);
/*      */       }
/* 2158 */       else if (createdBindings) { backrefs.add(bindings); }
/*      */     }
/*      */ 
/*      */     private void initializeEmptyCallerChain(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */       throws Exception
/*      */     {
/* 2164 */       HashMap callingMethod = (HashMap)this.methodCalledByMethodBindings.get(callingMethodHash);
/* 2165 */       if (callingMethod == null)
/*      */       {
/* 2167 */         callingMethod = new HashMap();
/* 2168 */         this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
/*      */       }
/* 2170 */       TLongObjectHashMap classMap = (TLongObjectHashMap)callingMethod.get(calledClass);
/* 2171 */       if (classMap == null)
/*      */       {
/* 2173 */         classMap = new TLongObjectHashMap();
/* 2174 */         callingMethod.put(calledClass, classMap);
/*      */       }
/* 2176 */       ArrayList bindings = (ArrayList)classMap.get(calledMethodHash);
/* 2177 */       if (bindings == null)
/*      */       {
/* 2179 */         bindings = new ArrayList();
/* 2180 */         classMap.put(calledMethodHash, bindings);
/*      */       }
/*      */     }
/*      */ 
/*      */     private MethodByMethodInfo initializeCallerInterceptorsMap(long callingMethodHash, String calledClass, long calledMethodHash, Method callingMethod, Method calledMethod)
/*      */       throws Exception
/*      */     {
/* 2187 */       HashMap calledClassesMap = (HashMap)this.methodCalledByMethodInterceptors.get(callingMethodHash);
/* 2188 */       if (calledClassesMap == null)
/*      */       {
/* 2190 */         calledClassesMap = new HashMap();
/* 2191 */         this.methodCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
/*      */       }
/* 2193 */       TLongObjectHashMap calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass);
/* 2194 */       if (calledMethodsMap == null)
/*      */       {
/* 2196 */         calledMethodsMap = new TLongObjectHashMap();
/* 2197 */         calledClassesMap.put(calledClass, calledMethodsMap);
/*      */       }
/*      */ 
/* 2200 */       calledMethod.setAccessible(true);
/*      */ 
/* 2203 */       Class calledClazz = SecurityActions.getContextClassLoader().loadClass(calledClass);
/* 2204 */       MethodByMethodInfo info = new MethodByMethodInfo(ClassAdvisor.this, calledClazz, calledMethod, callingMethod, callingMethodHash, calledMethodHash, null);
/* 2205 */       calledMethodsMap.put(calledMethodHash, info);
/* 2206 */       return info;
/*      */     }
/*      */ 
/*      */     private ArrayList getCallerBindings(long callingHash, String cname, long calledHash)
/*      */     {
/* 2212 */       HashMap calledClasses = (HashMap)this.methodCalledByMethodBindings.get(callingHash);
/* 2213 */       TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
/* 2214 */       return (ArrayList)calledMethods.get(calledHash);
/*      */     }
/*      */ 
/*      */     private void bindCallerInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash, Method calling)
/*      */     {
/* 2220 */       MethodByMethodInfo info = getCallerMethodInfo(callingHash, cname, calledHash);
/* 2221 */       info.clear();
/* 2222 */       Iterator it = bindings.iterator();
/* 2223 */       while (it.hasNext())
/*      */       {
/* 2225 */         AdviceBinding binding = (AdviceBinding)it.next();
/* 2226 */         ClassAdvisor.this.pointcutResolved(info, binding, new MethodCalledByMethodJoinpoint(info.getCallingMethod(), info.getMethod()));
/*      */       }
/* 2228 */       ClassAdvisor.this.finalizeMethodCalledByMethodInterceptorChain(info);
/*      */     }
/*      */ 
/*      */     private MethodByMethodInfo getCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash)
/*      */     {
/* 2234 */       HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingMethodHash);
/* 2235 */       TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
/* 2236 */       MethodByMethodInfo info = (MethodByMethodInfo)calledMethods.get(calledMethodHash);
/* 2237 */       return info;
/*      */     }
/*      */ 
/*      */     public void cleanup()
/*      */     {
/* 2242 */       this.methodCalledByMethodBindings.clear();
/* 2243 */       this.backrefMethodCalledByMethodBindings.clear();
/* 2244 */       this.methodCalledByMethodInterceptors.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   static abstract interface RebuildInterceptorsAction
/*      */   {
/* 1956 */     public static final RebuildInterceptorsAction PRIVILEGED = new RebuildInterceptorsAction()
/*      */     {
/*      */       public void rebuildInterceptors(ClassAdvisor advisor)
/*      */       {
/*      */         try
/*      */         {
/* 1962 */           AccessController.doPrivileged(new PrivilegedExceptionAction(advisor)
/*      */           {
/*      */             public Object run()
/*      */             {
/* 1966 */               this.val$advisor.doRebuildInterceptors();
/* 1967 */               return null;
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1973 */           Exception ex = e.getException();
/* 1974 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1976 */             throw ((RuntimeException)ex);
/*      */           }
/* 1978 */           throw new RuntimeException(ex);
/*      */         }
/*      */       }
/* 1956 */     };
/*      */ 
/* 1983 */     public static final RebuildInterceptorsAction NON_PRIVILEGED = new RebuildInterceptorsAction()
/*      */     {
/*      */       public void rebuildInterceptors(ClassAdvisor advisor)
/*      */       {
/* 1987 */         advisor.doRebuildInterceptors();
/*      */       }
/* 1983 */     };
/*      */ 
/*      */     public abstract void rebuildInterceptors(ClassAdvisor paramClassAdvisor);
/*      */   }
/*      */ 
/*      */   static abstract interface ResolveConstructorCallerConstructorInfoAction
/*      */   {
/* 1918 */     public static final ResolveConstructorCallerConstructorInfoAction PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction()
/*      */     {
/*      */       public ConByConInfo resolveInfo(ClassAdvisor advisor, Class callingClass, int callingIndex, String calledClass, long calledConHash) {
/*      */         Exception ex;
/*      */         try {
/* 1924 */           return (ConByConInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(advisor, callingClass, callingIndex, calledClass, calledConHash)
/*      */           {
/*      */             public Object run() throws Exception
/*      */             {
/* 1928 */               return this.val$advisor.doResolveConstructorCallerConstructorInfo(this.val$callingClass, this.val$callingIndex, this.val$calledClass, this.val$calledConHash);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1934 */           ex = e.getException();
/* 1935 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1937 */             throw ((RuntimeException)ex);
/*      */           }
/*      */         }
/* 1939 */         throw new RuntimeException(ex);
/*      */       }
/* 1918 */     };
/*      */ 
/* 1944 */     public static final ResolveConstructorCallerConstructorInfoAction NON_PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction()
/*      */     {
/*      */       public ConByConInfo resolveInfo(ClassAdvisor advisor, Class callingClass, int callingIndex, String calledClass, long calledConHash)
/*      */       {
/* 1948 */         return advisor.doResolveConstructorCallerConstructorInfo(callingClass, callingIndex, calledClass, calledConHash);
/*      */       }
/* 1944 */     };
/*      */ 
/*      */     public abstract ConByConInfo resolveInfo(ClassAdvisor paramClassAdvisor, Class paramClass, int paramInt, String paramString, long paramLong);
/*      */   }
/*      */ 
/*      */   static abstract interface ResolveConstructorCallerMethodInfoAction
/*      */   {
/* 1879 */     public static final ResolveConstructorCallerMethodInfoAction PRIVILEGED = new ResolveConstructorCallerMethodInfoAction()
/*      */     {
/*      */       public MethodByConInfo resolveInfo(ClassAdvisor advisor, Class callingClass, int callingIndex, String calledClass, long calledMethodHash) {
/*      */         Exception ex;
/*      */         try {
/* 1885 */           return (MethodByConInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(advisor, callingClass, callingIndex, calledClass, calledMethodHash)
/*      */           {
/*      */             public Object run() throws Exception
/*      */             {
/* 1889 */               return this.val$advisor.doResolveConstructorCallerMethodInfo(this.val$callingClass, this.val$callingIndex, this.val$calledClass, this.val$calledMethodHash);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1895 */           ex = e.getException();
/* 1896 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1898 */             throw ((RuntimeException)ex);
/*      */           }
/*      */         }
/* 1900 */         throw new RuntimeException(ex);
/*      */       }
/* 1879 */     };
/*      */ 
/* 1905 */     public static final ResolveConstructorCallerMethodInfoAction NON_PRIVILEGED = new ResolveConstructorCallerMethodInfoAction()
/*      */     {
/*      */       public MethodByConInfo resolveInfo(ClassAdvisor advisor, Class callingClass, int callingIndex, String calledClass, long calledMethodHash)
/*      */       {
/* 1909 */         return advisor.doResolveConstructorCallerMethodInfo(callingClass, callingIndex, calledClass, calledMethodHash);
/*      */       }
/* 1905 */     };
/*      */ 
/*      */     public abstract MethodByConInfo resolveInfo(ClassAdvisor paramClassAdvisor, Class paramClass, int paramInt, String paramString, long paramLong);
/*      */   }
/*      */ 
/*      */   static abstract interface ResolveCallerMethodInfoAction
/*      */   {
/* 1840 */     public static final ResolveCallerMethodInfoAction PRIVILEGED = new ResolveCallerMethodInfoAction()
/*      */     {
/*      */       public MethodByMethodInfo resolveInfo(ClassAdvisor.MethodByMethodData data, long callingMethodHash, String calledClass, long calledMethodHash) {
/*      */         Exception ex;
/*      */         try {
/* 1846 */           return (MethodByMethodInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(data, callingMethodHash, calledClass, calledMethodHash)
/*      */           {
/*      */             public Object run() throws Exception
/*      */             {
/* 1850 */               return this.val$data.doResolveCallerMethodInfo(this.val$callingMethodHash, this.val$calledClass, this.val$calledMethodHash);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1856 */           ex = e.getException();
/* 1857 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1859 */             throw ((RuntimeException)ex);
/*      */           }
/*      */         }
/* 1861 */         throw new RuntimeException(ex);
/*      */       }
/* 1840 */     };
/*      */ 
/* 1866 */     public static final ResolveCallerMethodInfoAction NON_PRIVILEGED = new ResolveCallerMethodInfoAction()
/*      */     {
/*      */       public MethodByMethodInfo resolveInfo(ClassAdvisor.MethodByMethodData data, long callingMethodHash, String calledClass, long calledMethodHash)
/*      */       {
/* 1870 */         return data.doResolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
/*      */       }
/* 1866 */     };
/*      */ 
/*      */     public abstract MethodByMethodInfo resolveInfo(ClassAdvisor.MethodByMethodData paramMethodByMethodData, long paramLong1, String paramString, long paramLong2);
/*      */   }
/*      */ 
/*      */   static abstract interface ResolveCallerConstuctorInfoAction
/*      */   {
/* 1801 */     public static final ResolveCallerConstuctorInfoAction PRIVILEGED = new ResolveCallerConstuctorInfoAction()
/*      */     {
/*      */       public ConByMethodInfo resolveInfo(ClassAdvisor.ConByMethodData data, long callingMethodHash, String calledClass, long calledConHash) {
/*      */         Exception ex;
/*      */         try {
/* 1807 */           return (ConByMethodInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(data, callingMethodHash, calledClass, calledConHash)
/*      */           {
/*      */             public Object run() throws Exception
/*      */             {
/* 1811 */               return this.val$data.doResolveCallerConstructorInfo(this.val$callingMethodHash, this.val$calledClass, this.val$calledConHash);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1817 */           ex = e.getException();
/* 1818 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1820 */             throw ((RuntimeException)ex);
/*      */           }
/*      */         }
/* 1822 */         throw new RuntimeException(ex);
/*      */       }
/* 1801 */     };
/*      */ 
/* 1827 */     public static final ResolveCallerConstuctorInfoAction NON_PRIVILEGED = new ResolveCallerConstuctorInfoAction()
/*      */     {
/*      */       public ConByMethodInfo resolveInfo(ClassAdvisor.ConByMethodData data, long callingMethodHash, String calledClass, long calledConHash)
/*      */       {
/* 1831 */         return data.doResolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
/*      */       }
/* 1827 */     };
/*      */ 
/*      */     public abstract ConByMethodInfo resolveInfo(ClassAdvisor.ConByMethodData paramConByMethodData, long paramLong1, String paramString, long paramLong2);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ClassAdvisor
 * JD-Core Version:    0.6.0
 */