/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class SimpleNode
/*     */   implements Node
/*     */ {
/*     */   protected Node parent;
/*     */   protected Node[] children;
/*     */   protected int id;
/*     */   protected AnnotationParser parser;
/*     */ 
/*     */   public SimpleNode(int i)
/*     */   {
/*  32 */     this.id = i;
/*     */   }
/*     */ 
/*     */   public SimpleNode(AnnotationParser p, int i) {
/*  36 */     this(i);
/*  37 */     this.parser = p;
/*     */   }
/*     */   public void jjtOpen() {
/*     */   }
/*     */ 
/*     */   public void jjtClose() {
/*     */   }
/*     */ 
/*     */   public void jjtSetParent(Node n) {
/*  46 */     this.parent = n; } 
/*  47 */   public Node jjtGetParent() { return this.parent; }
/*     */ 
/*     */   public void jjtAddChild(Node n, int i) {
/*  50 */     if (this.children == null) {
/*  51 */       this.children = new Node[i + 1];
/*  52 */     } else if (i >= this.children.length) {
/*  53 */       Node[] c = new Node[i + 1];
/*  54 */       System.arraycopy(this.children, 0, c, 0, this.children.length);
/*  55 */       this.children = c;
/*     */     }
/*  57 */     this.children[i] = n;
/*     */   }
/*     */ 
/*     */   public Node jjtGetChild(int i) {
/*  61 */     return this.children[i];
/*     */   }
/*     */ 
/*     */   public int jjtGetNumChildren() {
/*  65 */     return this.children == null ? 0 : this.children.length;
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(AnnotationParserVisitor visitor, Object data)
/*     */   {
/*  70 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public Object childrenAccept(AnnotationParserVisitor visitor, Object data)
/*     */   {
/*  79 */     if (this.children != null) {
/*  80 */       for (int i = 0; i < this.children.length; i++) {
/*  81 */         this.children[i].jjtAccept(visitor, data);
/*     */       }
/*     */     }
/*  84 */     return data;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  93 */     return AnnotationParserTreeConstants.jjtNodeName[this.id]; } 
/*  94 */   public String toString(String prefix) { return prefix + toString();
/*     */   }
/*     */ 
/*     */   public void dump(String prefix)
/*     */   {
/* 100 */     System.out.println(toString(prefix));
/* 101 */     if (this.children != null)
/* 102 */       for (int i = 0; i < this.children.length; i++) {
/* 103 */         SimpleNode n = (SimpleNode)this.children[i];
/* 104 */         if (n != null)
/* 105 */           n.dump(prefix + " ");
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.SimpleNode
 * JD-Core Version:    0.6.0
 */