/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ public class ParseException extends Exception
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected boolean specialConstructor;
/*     */   public Token currentToken;
/*     */   public int[][] expectedTokenSequences;
/*     */   public String[] tokenImage;
/* 166 */   protected String eol = System.getProperty("line.separator", "\n");
/*     */ 
/*     */   public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal)
/*     */   {
/*  58 */     super("");
/*  59 */     this.specialConstructor = true;
/*  60 */     this.currentToken = currentTokenVal;
/*  61 */     this.expectedTokenSequences = expectedTokenSequencesVal;
/*  62 */     this.tokenImage = tokenImageVal;
/*     */   }
/*     */ 
/*     */   public ParseException()
/*     */   {
/*  77 */     this.specialConstructor = false;
/*     */   }
/*     */ 
/*     */   public ParseException(String message) {
/*  81 */     super(message);
/*  82 */     this.specialConstructor = false;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 124 */     if (!this.specialConstructor) {
/* 125 */       return super.getMessage();
/*     */     }
/* 127 */     String expected = "";
/* 128 */     int maxSize = 0;
/* 129 */     for (int i = 0; i < this.expectedTokenSequences.length; i++) {
/* 130 */       if (maxSize < this.expectedTokenSequences[i].length) {
/* 131 */         maxSize = this.expectedTokenSequences[i].length;
/*     */       }
/* 133 */       for (int j = 0; j < this.expectedTokenSequences[i].length; j++) {
/* 134 */         expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
/*     */       }
/* 136 */       if (this.expectedTokenSequences[i][(this.expectedTokenSequences[i].length - 1)] != 0) {
/* 137 */         expected = expected + "...";
/*     */       }
/* 139 */       expected = expected + this.eol + "    ";
/*     */     }
/* 141 */     String retval = "Encountered \"";
/* 142 */     Token tok = this.currentToken.next;
/* 143 */     for (int i = 0; i < maxSize; i++) {
/* 144 */       if (i != 0) retval = retval + " ";
/* 145 */       if (tok.kind == 0) {
/* 146 */         retval = retval + this.tokenImage[0];
/* 147 */         break;
/*     */       }
/* 149 */       retval = retval + add_escapes(tok.image);
/* 150 */       tok = tok.next;
/*     */     }
/* 152 */     retval = retval + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
/* 153 */     retval = retval + "." + this.eol;
/* 154 */     if (this.expectedTokenSequences.length == 1)
/* 155 */       retval = retval + "Was expecting:" + this.eol + "    ";
/*     */     else {
/* 157 */       retval = retval + "Was expecting one of:" + this.eol + "    ";
/*     */     }
/* 159 */     retval = retval + expected;
/* 160 */     return retval;
/*     */   }
/*     */ 
/*     */   protected String add_escapes(String str)
/*     */   {
/* 177 */     StringBuffer retval = new StringBuffer();
/*     */ 
/* 179 */     for (int i = 0; i < str.length(); i++) {
/* 180 */       switch (str.charAt(i))
/*     */       {
/*     */       case '\000':
/* 183 */         break;
/*     */       case '\b':
/* 185 */         retval.append("\\b");
/* 186 */         break;
/*     */       case '\t':
/* 188 */         retval.append("\\t");
/* 189 */         break;
/*     */       case '\n':
/* 191 */         retval.append("\\n");
/* 192 */         break;
/*     */       case '\f':
/* 194 */         retval.append("\\f");
/* 195 */         break;
/*     */       case '\r':
/* 197 */         retval.append("\\r");
/* 198 */         break;
/*     */       case '"':
/* 200 */         retval.append("\\\"");
/* 201 */         break;
/*     */       case '\'':
/* 203 */         retval.append("\\'");
/* 204 */         break;
/*     */       case '\\':
/* 206 */         retval.append("\\\\");
/* 207 */         break;
/*     */       default:
/*     */         char ch;
/* 209 */         if (((ch = str.charAt(i)) < ' ') || (ch > '~')) {
/* 210 */           String s = "0000" + Integer.toString(ch, 16);
/* 211 */           retval.append("\\u" + s.substring(s.length() - 4, s.length()));
/*     */         } else {
/* 213 */           retval.append(ch);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 218 */     return retval.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.ParseException
 * JD-Core Version:    0.6.0
 */