/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class AnnotationParserTester
/*     */   implements AnnotationParserVisitor
/*     */ {
/*  28 */   private int indent = 0;
/*     */ 
/*     */   private String indentString()
/*     */   {
/*  32 */     StringBuffer sb = new StringBuffer();
/*  33 */     for (int i = 0; i < this.indent; i++)
/*     */     {
/*  35 */       sb.append(" ");
/*     */     }
/*  37 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSingleMemberValue node, Object data)
/*     */   {
/*  42 */     System.out.println(indentString() + node);
/*  43 */     this.indent += 1;
/*  44 */     data = node.childrenAccept(this, data);
/*  45 */     this.indent -= 1;
/*  46 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/*  51 */     System.out.println(indentString() + node + ": acceptor not unimplemented in subclass?");
/*     */ 
/*  53 */     this.indent += 1;
/*  54 */     data = node.childrenAccept(this, data);
/*  55 */     this.indent -= 1;
/*  56 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/*  61 */     System.out.println(indentString() + node);
/*  62 */     this.indent += 1;
/*  63 */     data = node.childrenAccept(this, data);
/*  64 */     this.indent -= 1;
/*  65 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnnotation node, Object data)
/*     */   {
/*  70 */     System.out.println(indentString() + node);
/*  71 */     this.indent += 1;
/*  72 */     data = node.childrenAccept(this, data);
/*  73 */     this.indent -= 1;
/*  74 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePairs node, Object data)
/*     */   {
/*  79 */     System.out.println(indentString() + node);
/*  80 */     this.indent += 1;
/*  81 */     data = node.childrenAccept(this, data);
/*  82 */     this.indent -= 1;
/*  83 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePair node, Object data)
/*     */   {
/*  88 */     System.out.println(indentString() + node);
/*  89 */     this.indent += 1;
/*  90 */     data = node.childrenAccept(this, data);
/*  91 */     this.indent -= 1;
/*  92 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValueArrayInitializer node, Object data)
/*     */   {
/*  97 */     System.out.println(indentString() + node);
/*  98 */     this.indent += 1;
/*  99 */     data = node.childrenAccept(this, data);
/* 100 */     this.indent -= 1;
/* 101 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIdentifier node, Object data)
/*     */   {
/* 106 */     System.out.println(indentString() + node);
/* 107 */     this.indent += 1;
/* 108 */     data = node.childrenAccept(this, data);
/* 109 */     this.indent -= 1;
/* 110 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTString node, Object data)
/*     */   {
/* 115 */     System.out.println(indentString() + node);
/* 116 */     this.indent += 1;
/* 117 */     data = node.childrenAccept(this, data);
/* 118 */     this.indent -= 1;
/* 119 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTChar node, Object data)
/*     */   {
/* 124 */     System.out.println(indentString() + node);
/* 125 */     this.indent += 1;
/* 126 */     data = node.childrenAccept(this, data);
/* 127 */     this.indent -= 1;
/* 128 */     return data;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 135 */     System.out.println("Reading from stdin");
/* 136 */     AnnotationParser t = new AnnotationParser(System.in);
/*     */     try
/*     */     {
/* 140 */       ASTStart n = t.Start();
/* 141 */       AnnotationParserVisitor v = new AnnotationParserTester();
/* 142 */       n.jjtAccept(v, null);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 146 */       System.out.println("Oops.");
/* 147 */       System.out.println(e.getMessage());
/* 148 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.AnnotationParserTester
 * JD-Core Version:    0.6.0
 */