/*    */ package org.jboss.annotation.factory;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Map;
/*    */ 
/*    */ public class SimpleAnnotationValidator
/*    */   implements AnnotationValidator
/*    */ {
/*    */   public void validate(Map map, Class annotation)
/*    */   {
/* 42 */     ArrayList notAssignedAttributes = null;
/* 43 */     Method[] methods = getDeclaredMethods(annotation);
/* 44 */     for (int i = 0; i < methods.length; i++)
/*    */     {
/* 46 */       if (map.get(methods[i].getName()) != null)
/*    */         continue;
/* 48 */       if (notAssignedAttributes == null)
/*    */       {
/* 50 */         notAssignedAttributes = new ArrayList();
/*    */       }
/* 52 */       notAssignedAttributes.add(methods[i].getName());
/*    */     }
/*    */ 
/* 56 */     if (notAssignedAttributes != null)
/*    */     {
/* 58 */       throw new AnnotationValidationException("Unable to fill in default attributes for " + annotation + " " + notAssignedAttributes);
/*    */     }
/*    */   }
/*    */ 
/*    */   private Method[] getDeclaredMethods(Class clazz)
/*    */   {
/* 64 */     return (Method[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*    */     {
/*    */       public Method[] run()
/*    */       {
/* 68 */         return this.val$clazz.getDeclaredMethods();
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.SimpleAnnotationValidator
 * JD-Core Version:    0.6.0
 */