/*     */ package javax.xml.ws.wsaddressing;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.spi.Provider;
/*     */ import javax.xml.ws.spi.Provider21;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class W3CEndpointReferenceBuilder
/*     */ {
/*     */   private String address;
/*     */   private List<Element> referenceParameters;
/*     */   private List<Element> metadata;
/*     */   private QName serviceName;
/*     */   private QName endpointName;
/*     */   private String wsdlDocumentLocation;
/*     */ 
/*     */   public W3CEndpointReferenceBuilder()
/*     */   {
/*  68 */     this.referenceParameters = new ArrayList();
/*  69 */     this.metadata = new ArrayList();
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder address(String address)
/*     */   {
/*  89 */     this.address = address;
/*  90 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder serviceName(QName serviceName)
/*     */   {
/* 110 */     this.serviceName = serviceName;
/* 111 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder endpointName(QName endpointName)
/*     */   {
/* 136 */     if (this.serviceName == null) {
/* 137 */       throw new IllegalStateException("The W3CEndpointReferenceBuilder's serviceName must be set before setting the endpointName: " + endpointName);
/*     */     }
/*     */ 
/* 140 */     this.endpointName = endpointName;
/* 141 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder wsdlDocumentLocation(String wsdlDocumentLocation)
/*     */   {
/* 158 */     this.wsdlDocumentLocation = wsdlDocumentLocation;
/* 159 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder referenceParameter(Element referenceParameter)
/*     */   {
/* 178 */     if (referenceParameter == null)
/* 179 */       throw new IllegalArgumentException("The referenceParameter cannot be null.");
/* 180 */     this.referenceParameters.add(referenceParameter);
/* 181 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReferenceBuilder metadata(Element metadataElement)
/*     */   {
/* 200 */     if (metadataElement == null)
/* 201 */       throw new IllegalArgumentException("The metadataElement cannot be null.");
/* 202 */     this.metadata.add(metadataElement);
/* 203 */     return this;
/*     */   }
/*     */ 
/*     */   public W3CEndpointReference build()
/*     */   {
/* 252 */     return ((Provider21)Provider.provider()).createW3CEndpointReference(this.address, this.serviceName, this.endpointName, this.metadata, this.wsdlDocumentLocation, this.referenceParameters);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder
 * JD-Core Version:    0.6.0
 */