/*     */ package javax.xml.ws.wsaddressing;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.JAXBException;
/*     */ import javax.xml.bind.Marshaller;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import javax.xml.bind.annotation.XmlAnyAttribute;
/*     */ import javax.xml.bind.annotation.XmlAnyElement;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlRootElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.bind.annotation.XmlValue;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.ws.core.jaxws.JAXBContextFactory;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @XmlRootElement(name="EndpointReference", namespace="http://www.w3.org/2005/08/addressing")
/*     */ @XmlType(name="EndpointReferenceType", namespace="http://www.w3.org/2005/08/addressing")
/*     */ public final class W3CEndpointReference extends EndpointReference
/*     */ {
/*  71 */   private static final JAXBContext w3cjc = getW3CJaxbContext();
/*     */ 
/*     */   @XmlElement(name="Address", namespace="http://www.w3.org/2005/08/addressing")
/*     */   private Address address;
/*     */ 
/*     */   @XmlElement(name="ReferenceParameters", namespace="http://www.w3.org/2005/08/addressing")
/*     */   private Elements referenceParameters;
/*     */ 
/*     */   @XmlElement(name="Metadata", namespace="http://www.w3.org/2005/08/addressing")
/*     */   private Elements metadata;
/*     */ 
/*     */   @XmlAnyAttribute
/*     */   Map<QName, String> attributes;
/*     */ 
/*     */   @XmlAnyElement
/*     */   List<Element> elements;
/*     */   protected static final String NS = "http://www.w3.org/2005/08/addressing";
/*     */ 
/*     */   protected W3CEndpointReference() {  } 
/*     */   public W3CEndpointReference(Source source) { try { W3CEndpointReference epr = (W3CEndpointReference)w3cjc.createUnmarshaller().unmarshal(source, W3CEndpointReference.class).getValue();
/*  92 */       this.address = epr.address;
/*  93 */       this.metadata = epr.metadata;
/*  94 */       this.referenceParameters = epr.referenceParameters;
/*     */     } catch (JAXBException e) {
/*  96 */       throw new WebServiceException("Error unmarshalling W3CEndpointReference ", e);
/*     */     } catch (ClassCastException e) {
/*  98 */       throw new WebServiceException("Source did not contain W3CEndpointReference", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeTo(Result result)
/*     */   {
/*     */     try
/*     */     {
/* 107 */       Marshaller marshaller = w3cjc.createMarshaller();
/* 108 */       marshaller.setProperty("jaxb.fragment", Boolean.valueOf(true));
/* 109 */       marshaller.marshal(this, result);
/*     */     } catch (JAXBException e) {
/* 111 */       throw new WebServiceException("Error marshalling W3CEndpointReference. ", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static JAXBContext getW3CJaxbContext() {
/* 116 */     return JAXBContextFactory.newInstance().createContext(new Class[] { W3CEndpointReference.class });
/*     */   }
/*     */ 
/*     */   private static class Elements
/*     */   {
/*     */ 
/*     */     @XmlAnyElement
/*     */     List<Element> elements;
/*     */ 
/*     */     @XmlAnyAttribute
/*     */     Map<QName, String> attributes;
/*     */   }
/*     */ 
/*     */   private static class Address
/*     */   {
/*     */ 
/*     */     @XmlValue
/*     */     String uri;
/*     */ 
/*     */     @XmlAnyAttribute
/*     */     Map<QName, String> attributes;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.wsaddressing.W3CEndpointReference
 * JD-Core Version:    0.6.0
 */