/*     */ package javax.xml.ws.spi;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Properties;
/*     */ 
/*     */ abstract class ProviderLoader
/*     */ {
/*     */   public static Provider loadProvider(String defaultFactory)
/*     */   {
/*  73 */     Object factory = null;
/*  74 */     String factoryName = null;
/*  75 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/*  78 */     String propertyName = "javax.xml.ws.spi.Provider";
/*  79 */     String filename = "META-INF/services/" + propertyName;
/*  80 */     InputStream inStream = loader.getResourceAsStream(filename);
/*  81 */     if (inStream != null)
/*     */     {
/*     */       try
/*     */       {
/*  85 */         BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
/*  86 */         factoryName = br.readLine();
/*  87 */         br.close();
/*  88 */         if (factoryName != null)
/*     */         {
/*  90 */           Class factoryClass = loader.loadClass(factoryName);
/*  91 */           factory = factoryClass.newInstance();
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  96 */         throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 102 */     if (factory == null)
/*     */     {
/* 104 */       PrivilegedAction action = new PropertyAccessAction("java.home");
/* 105 */       String javaHome = (String)AccessController.doPrivileged(action);
/* 106 */       File jaxmFile = new File(javaHome + "/lib/jaxws.properties");
/* 107 */       if (jaxmFile.exists())
/*     */       {
/*     */         try
/*     */         {
/* 111 */           action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
/* 112 */           Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
/* 113 */           factoryName = jaxmProperties.getProperty(propertyName);
/* 114 */           if (factoryName != null)
/*     */           {
/* 117 */             Class factoryClass = loader.loadClass(factoryName);
/* 118 */             factory = factoryClass.newInstance();
/*     */           }
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 123 */           throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 129 */     if (factory == null)
/*     */     {
/* 131 */       PrivilegedAction action = new PropertyAccessAction(propertyName);
/* 132 */       factoryName = (String)AccessController.doPrivileged(action);
/* 133 */       if (factoryName != null)
/*     */       {
/*     */         try
/*     */         {
/* 138 */           Class factoryClass = loader.loadClass(factoryName);
/* 139 */           factory = factoryClass.newInstance();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 143 */           throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 149 */     if ((factory == null) && (defaultFactory != null))
/*     */     {
/*     */       try
/*     */       {
/* 154 */         Class factoryClass = loader.loadClass(defaultFactory);
/* 155 */         factory = factoryClass.newInstance();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 159 */         throw new IllegalStateException("Failed to load: " + defaultFactory, t);
/*     */       }
/*     */     }
/*     */ 
/* 163 */     return (Provider)factory;
/*     */   }
/*     */ 
/*     */   private static class PropertyFileAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String filename;
/*     */ 
/*     */     PropertyFileAccessAction(String filename)
/*     */     {
/* 187 */       this.filename = filename;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*     */       try
/*     */       {
/* 194 */         InputStream inStream = new FileInputStream(this.filename);
/* 195 */         Properties props = new Properties();
/* 196 */         props.load(inStream);
/* 197 */         return props;
/*     */       }
/*     */       catch (IOException ex) {
/*     */       }
/* 201 */       throw new SecurityException("Cannot load properties: " + this.filename, ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PropertyAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String name;
/*     */ 
/*     */     PropertyAccessAction(String name)
/*     */     {
/* 172 */       this.name = name;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 177 */       return System.getProperty(this.name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.spi.ProviderLoader
 * JD-Core Version:    0.6.0
 */