/*     */ package javax.xml.rpc.handler;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class HandlerInfo
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -6735139577513563610L;
/*     */   private Class handlerClass;
/*  44 */   private Map configMap = new HashMap();
/*     */   private QName[] headers;
/*     */ 
/*     */   public HandlerInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public HandlerInfo(Class handlerClass, Map config, QName[] headers)
/*     */   {
/*  61 */     this.handlerClass = handlerClass;
/*  62 */     this.headers = headers;
/*  63 */     if (config != null)
/*  64 */       this.configMap.putAll(config);
/*     */   }
/*     */ 
/*     */   public Class getHandlerClass()
/*     */   {
/*  73 */     return this.handlerClass;
/*     */   }
/*     */ 
/*     */   public void setHandlerClass(Class handlerClass)
/*     */   {
/*  82 */     this.handlerClass = handlerClass;
/*     */   }
/*     */ 
/*     */   public Map getHandlerConfig()
/*     */   {
/*  91 */     return new HashMap(this.configMap);
/*     */   }
/*     */ 
/*     */   public void setHandlerConfig(Map config)
/*     */   {
/* 100 */     this.configMap.clear();
/* 101 */     if (config != null)
/* 102 */       this.configMap.putAll(config);
/*     */   }
/*     */ 
/*     */   public QName[] getHeaders()
/*     */   {
/* 111 */     return this.headers;
/*     */   }
/*     */ 
/*     */   public void setHeaders(QName[] qnames)
/*     */   {
/* 120 */     this.headers = qnames;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 127 */     List hlist = this.headers != null ? Arrays.asList(this.headers) : null;
/* 128 */     return "[class=" + this.handlerClass.getName() + ",headers=" + hlist + ",config=" + this.configMap + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.rpc.handler.HandlerInfo
 * JD-Core Version:    0.6.0
 */