/*     */ package javax.xml.rpc;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Properties;
/*     */ import java.util.logging.Logger;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public abstract class ServiceFactory
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(ServiceFactory.class.getName());
/*     */   private static ServiceFactory factory;
/*     */   public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";
/*     */   private static final String DEFAULT_SERVICE_FACTORY = "org.jboss.ws.core.jaxrpc.client.ServiceFactoryImpl";
/*  57 */   private static final String[] alternativeFactories = new String[0];
/*     */ 
/*     */   public static ServiceFactory newInstance()
/*     */     throws ServiceException
/*     */   {
/*  74 */     if (factory == null)
/*     */     {
/*  76 */       PrivilegedAction action = new PropertyAccessAction("javax.xml.rpc.ServiceFactory", "org.jboss.ws.core.jaxrpc.client.ServiceFactoryImpl");
/*  77 */       String factoryName = (String)AccessController.doPrivileged(action);
/*     */ 
/*  79 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/*  84 */           Class factoryClass = loader.loadClass(factoryName);
/*  85 */           factory = (ServiceFactory)factoryClass.newInstance();
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/*  90 */           if (!factoryName.equals("org.jboss.ws.core.jaxrpc.client.ServiceFactoryImpl")) {
/*  91 */             throw e;
/*     */           }
/*  93 */           for (int i = 0; i < alternativeFactories.length; i++)
/*     */           {
/*  95 */             factoryName = alternativeFactories[i];
/*     */             try
/*     */             {
/*  98 */               Class factoryClass = loader.loadClass(factoryName);
/*  99 */               return (ServiceFactory)factoryClass.newInstance();
/*     */             }
/*     */             catch (ClassNotFoundException e1)
/*     */             {
/* 103 */               log.severe("Cannot load factory: " + factoryName);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 110 */         throw new ServiceException("Failed to create factory: " + factoryName, e);
/*     */       }
/*     */     }
/*     */ 
/* 114 */     if (factory == null) {
/* 115 */       throw new ServiceException("Cannot find ServiceFactory implementation");
/*     */     }
/* 117 */     return factory;
/*     */   }
/*     */ 
/*     */   public abstract Service createService(URL paramURL, QName paramQName)
/*     */     throws ServiceException;
/*     */ 
/*     */   public abstract Service createService(QName paramQName)
/*     */     throws ServiceException;
/*     */ 
/*     */   public abstract Service loadService(Class paramClass)
/*     */     throws ServiceException;
/*     */ 
/*     */   public abstract Service loadService(URL paramURL, Class paramClass, Properties paramProperties)
/*     */     throws ServiceException;
/*     */ 
/*     */   public abstract Service loadService(URL paramURL, QName paramQName, Properties paramProperties)
/*     */     throws ServiceException;
/*     */ 
/*     */   private static class PropertyAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String name;
/*     */     private String defaultValue;
/*     */ 
/*     */     PropertyAccessAction(String name, String defaultValue)
/*     */     {
/* 183 */       this.name = name;
/* 184 */       this.defaultValue = defaultValue;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 189 */       return System.getProperty(this.name, this.defaultValue);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.rpc.ServiceFactory
 * JD-Core Version:    0.6.0
 */