/*    */ package javax.xml.registry;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Properties;
/*    */ 
/*    */ public abstract class ConnectionFactory
/*    */ {
/*    */   private static final String SYS_PROP_NAME = "javax.xml.registry.ConnectionFactoryClass";
/*    */ 
/*    */   public static ConnectionFactory newInstance()
/*    */     throws JAXRException
/*    */   {
/* 63 */     String factoryName = null;
/* 64 */     ConnectionFactory factory = null;
/*    */     try
/*    */     {
/* 67 */       String defaultName = null;
/* 68 */       factoryName = System.getProperty("javax.xml.registry.ConnectionFactoryClass", defaultName);
/* 69 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 70 */       Class factoryClass = loader.loadClass(factoryName);
/* 71 */       factory = (ConnectionFactory)factoryClass.newInstance();
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 75 */       throw new JAXRException("Failed to create instance of: " + factoryName, e);
/*    */     }
/* 77 */     return factory;
/*    */   }
/*    */ 
/*    */   public abstract Connection createConnection()
/*    */     throws JAXRException;
/*    */ 
/*    */   public abstract FederatedConnection createFederatedConnection(Collection paramCollection)
/*    */     throws JAXRException;
/*    */ 
/*    */   public abstract Properties getProperties()
/*    */     throws JAXRException;
/*    */ 
/*    */   public abstract void setProperties(Properties paramProperties)
/*    */     throws JAXRException;
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.registry.ConnectionFactory
 * JD-Core Version:    0.6.0
 */