/*      */ package javax.servlet.http;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.util.ResourceBundle;
/*      */ import javax.servlet.ServletOutputStream;
/*      */ 
/*      */ class NoBodyOutputStream extends ServletOutputStream
/*      */ {
/*      */   private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
/*  989 */   private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
/*      */ 
/*  992 */   private int contentLength = 0;
/*      */ 
/*      */   int getContentLength()
/*      */   {
/*  999 */     return this.contentLength;
/*      */   }
/*      */ 
/*      */   public void write(int b) {
/* 1003 */     this.contentLength += 1;
/*      */   }
/*      */ 
/*      */   public void write(byte[] buf, int offset, int len)
/*      */     throws IOException
/*      */   {
/* 1009 */     if (len >= 0) {
/* 1010 */       this.contentLength += len;
/*      */     }
/*      */     else
/*      */     {
/* 1015 */       String msg = lStrings.getString("err.io.negativelength");
/* 1016 */       throw new IOException("negative length");
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.NoBodyOutputStream
 * JD-Core Version:    0.6.0
 */