/*     */ package javax.servlet.http;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.ResourceBundle;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.servlet.ServletInputStream;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class HttpUtils
/*     */ {
/*     */   private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
/*  39 */   private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
/*     */ 
/*     */   public static Hashtable parseQueryString(String s)
/*     */   {
/*  89 */     String[] valArray = null;
/*     */ 
/*  91 */     if (s == null) {
/*  92 */       throw new IllegalArgumentException();
/*     */     }
/*  94 */     Hashtable ht = new Hashtable();
/*  95 */     StringBuffer sb = new StringBuffer();
/*  96 */     StringTokenizer st = new StringTokenizer(s, "&");
/*  97 */     while (st.hasMoreTokens()) {
/*  98 */       String pair = st.nextToken();
/*  99 */       int pos = pair.indexOf('=');
/* 100 */       if (pos == -1)
/*     */       {
/* 103 */         throw new IllegalArgumentException();
/*     */       }
/* 105 */       String key = parseName(pair.substring(0, pos), sb);
/* 106 */       String val = parseName(pair.substring(pos + 1, pair.length()), sb);
/* 107 */       if (ht.containsKey(key)) {
/* 108 */         String[] oldVals = (String[])(String[])ht.get(key);
/* 109 */         valArray = new String[oldVals.length + 1];
/* 110 */         for (int i = 0; i < oldVals.length; i++)
/* 111 */           valArray[i] = oldVals[i];
/* 112 */         valArray[oldVals.length] = val;
/*     */       } else {
/* 114 */         valArray = new String[1];
/* 115 */         valArray[0] = val;
/*     */       }
/* 117 */       ht.put(key, valArray);
/*     */     }
/* 119 */     return ht;
/*     */   }
/*     */ 
/*     */   public static Hashtable parsePostData(int len, ServletInputStream in)
/*     */   {
/* 172 */     if (len <= 0) {
/* 173 */       return new Hashtable();
/*     */     }
/* 175 */     if (in == null) {
/* 176 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/* 182 */     byte[] postedBytes = new byte[len];
/*     */     try {
/* 184 */       int offset = 0;
/*     */       do
/*     */       {
/* 187 */         int inputLen = in.read(postedBytes, offset, len - offset);
/* 188 */         if (inputLen <= 0) {
/* 189 */           String msg = lStrings.getString("err.io.short_read");
/* 190 */           throw new IllegalArgumentException(msg);
/*     */         }
/* 192 */         offset += inputLen;
/* 193 */       }while (len - offset > 0);
/*     */     }
/*     */     catch (IOException e) {
/* 196 */       throw new IllegalArgumentException(e.getMessage());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 205 */       String postedBody = new String(postedBytes, 0, len, "8859_1");
/* 206 */       return parseQueryString(postedBody);
/*     */     }
/*     */     catch (UnsupportedEncodingException e) {
/*     */     }
/* 210 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ 
/*     */   private static String parseName(String s, StringBuffer sb)
/*     */   {
/* 222 */     sb.setLength(0);
/* 223 */     for (int i = 0; i < s.length(); i++) {
/* 224 */       char c = s.charAt(i);
/* 225 */       switch (c) {
/*     */       case '+':
/* 227 */         sb.append(' ');
/* 228 */         break;
/*     */       case '%':
/*     */         try {
/* 231 */           sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
/*     */ 
/* 233 */           i += 2;
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 237 */           throw new IllegalArgumentException();
/*     */         } catch (StringIndexOutOfBoundsException e) {
/* 239 */           String rest = s.substring(i);
/* 240 */           sb.append(rest);
/* 241 */           if (rest.length() == 2) {
/* 242 */             i++;
/*     */           }
/*     */         }
/*     */ 
/*     */       default:
/* 247 */         sb.append(c);
/*     */       }
/*     */     }
/*     */ 
/* 251 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static StringBuffer getRequestURL(HttpServletRequest req)
/*     */   {
/* 281 */     StringBuffer url = new StringBuffer();
/* 282 */     String scheme = req.getScheme();
/* 283 */     int port = req.getServerPort();
/* 284 */     String urlPath = req.getRequestURI();
/*     */ 
/* 289 */     url.append(scheme);
/* 290 */     url.append("://");
/* 291 */     url.append(req.getServerName());
/* 292 */     if (((scheme.equals("http")) && (port != 80)) || ((scheme.equals("https")) && (port != 443)))
/*     */     {
/* 294 */       url.append(':');
/* 295 */       url.append(req.getServerPort());
/*     */     }
/*     */ 
/* 301 */     url.append(urlPath);
/* 302 */     return url;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.HttpUtils
 * JD-Core Version:    0.6.0
 */