/*     */ package javax.servlet;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.Locale;
/*     */ 
/*     */ public class ServletResponseWrapper
/*     */   implements ServletResponse
/*     */ {
/*     */   private ServletResponse response;
/*     */ 
/*     */   public ServletResponseWrapper(ServletResponse response)
/*     */   {
/*  48 */     if (response == null) {
/*  49 */       throw new IllegalArgumentException("Response cannot be null");
/*     */     }
/*  51 */     this.response = response;
/*     */   }
/*     */ 
/*     */   public ServletResponse getResponse()
/*     */   {
/*  59 */     return this.response;
/*     */   }
/*     */ 
/*     */   public void setResponse(ServletResponse response)
/*     */   {
/*  69 */     if (response == null) {
/*  70 */       throw new IllegalArgumentException("Response cannot be null");
/*     */     }
/*  72 */     this.response = response;
/*     */   }
/*     */ 
/*     */   public void setCharacterEncoding(String charset)
/*     */   {
/*  83 */     this.response.setCharacterEncoding(charset);
/*     */   }
/*     */ 
/*     */   public String getCharacterEncoding()
/*     */   {
/*  92 */     return this.response.getCharacterEncoding();
/*     */   }
/*     */ 
/*     */   public ServletOutputStream getOutputStream()
/*     */     throws IOException
/*     */   {
/* 102 */     return this.response.getOutputStream();
/*     */   }
/*     */ 
/*     */   public PrintWriter getWriter()
/*     */     throws IOException
/*     */   {
/* 112 */     return this.response.getWriter();
/*     */   }
/*     */ 
/*     */   public void setContentLength(int len)
/*     */   {
/* 121 */     this.response.setContentLength(len);
/*     */   }
/*     */ 
/*     */   public void setContentType(String type)
/*     */   {
/* 130 */     this.response.setContentType(type);
/*     */   }
/*     */ 
/*     */   public String getContentType()
/*     */   {
/* 141 */     return this.response.getContentType();
/*     */   }
/*     */ 
/*     */   public void setBufferSize(int size)
/*     */   {
/* 149 */     this.response.setBufferSize(size);
/*     */   }
/*     */ 
/*     */   public int getBufferSize()
/*     */   {
/* 157 */     return this.response.getBufferSize();
/*     */   }
/*     */ 
/*     */   public void flushBuffer()
/*     */     throws IOException
/*     */   {
/* 166 */     this.response.flushBuffer();
/*     */   }
/*     */ 
/*     */   public boolean isCommitted()
/*     */   {
/* 174 */     return this.response.isCommitted();
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 183 */     this.response.reset();
/*     */   }
/*     */ 
/*     */   public void resetBuffer()
/*     */   {
/* 192 */     this.response.resetBuffer();
/*     */   }
/*     */ 
/*     */   public void setLocale(Locale loc)
/*     */   {
/* 201 */     this.response.setLocale(loc);
/*     */   }
/*     */ 
/*     */   public Locale getLocale()
/*     */   {
/* 209 */     return this.response.getLocale();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.ServletResponseWrapper
 * JD-Core Version:    0.6.0
 */