/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ class URLPatternSpec
/*     */ {
/*     */   URLPattern urlPattern;
/*     */   HashSet urlPatternList;
/*     */ 
/*     */   URLPatternSpec(String spec)
/*     */   {
/*  76 */     if (spec == null) {
/*  77 */       this.urlPattern = new URLPattern("/");
/*  78 */     } else if (spec.indexOf(':') > 0)
/*     */     {
/*  80 */       StringTokenizer tokenizer = new StringTokenizer(spec, ":");
/*  81 */       this.urlPatternList = new HashSet();
/*  82 */       while (tokenizer.hasMoreTokens())
/*     */       {
/*  84 */         String pattern = tokenizer.nextToken();
/*  85 */         URLPattern p = new URLPattern(pattern);
/*  86 */         if (this.urlPattern == null) {
/*  87 */           this.urlPattern = p;
/*     */         }
/*     */         else
/*     */         {
/*  91 */           if (p.matches(this.urlPattern))
/*     */           {
/*  96 */             String msg = "1: URLPatternList item: " + pattern + " matches: " + this.urlPattern.getPattern();
/*     */ 
/*  98 */             throw new IllegalArgumentException(msg);
/*     */           }
/* 100 */           if (this.urlPattern.isPrefix())
/*     */           {
/* 107 */             if ((!p.isPrefix()) && (!p.isExact()))
/*     */             {
/* 109 */               String msg = "2: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
/*     */ 
/* 111 */               throw new IllegalArgumentException(msg);
/*     */             }
/*     */           }
/* 114 */           else if (this.urlPattern.isExtension())
/*     */           {
/* 120 */             if ((!p.isPrefix()) && (!p.isExact()))
/*     */             {
/* 122 */               String msg = "3: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
/*     */ 
/* 124 */               throw new IllegalArgumentException(msg);
/*     */             }
/*     */           }
/* 127 */           else if (this.urlPattern.isDefault())
/*     */           {
/* 133 */             if (p.isDefault())
/*     */             {
/* 135 */               String msg = "4: URLPatternList item: " + pattern + " cannot be the default pattern";
/*     */ 
/* 137 */               throw new IllegalArgumentException(msg);
/*     */             }
/*     */           }
/* 140 */           else if (this.urlPattern.isExact())
/*     */           {
/* 145 */             String msg = "5: URLPatternList item: " + pattern + " is not allowed in an exact pattern";
/*     */ 
/* 147 */             throw new IllegalArgumentException(msg);
/*     */           }
/* 149 */           this.urlPatternList.add(p);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 155 */       this.urlPattern = new URLPattern(spec);
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean implies(URLPatternSpec spec)
/*     */   {
/* 192 */     boolean implies = this.urlPattern.matches(spec.urlPattern);
/* 193 */     if (implies)
/*     */     {
/* 199 */       if (this.urlPatternList != null)
/*     */       {
/* 201 */         Iterator iter = this.urlPatternList.iterator();
/* 202 */         while (iter.hasNext())
/*     */         {
/* 204 */           URLPattern p = (URLPattern)iter.next();
/* 205 */           if (p.matches(spec.urlPattern)) {
/* 206 */             return false;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 216 */       if ((this.urlPatternList != null) && (spec.urlPatternList != null))
/*     */       {
/* 218 */         Iterator iter = this.urlPatternList.iterator();
/* 219 */         while (iter.hasNext())
/*     */         {
/* 221 */           URLPattern p = (URLPattern)iter.next();
/* 222 */           boolean hasMatch = false;
/* 223 */           Iterator iter2 = spec.urlPatternList.iterator();
/* 224 */           while (iter2.hasNext())
/*     */           {
/* 226 */             URLPattern p2 = (URLPattern)iter2.next();
/* 227 */             if (p.matches(p2))
/*     */             {
/* 229 */               hasMatch = true;
/* 230 */               break;
/*     */             }
/*     */           }
/* 233 */           if (!hasMatch)
/* 234 */             return false;
/*     */         }
/*     */       }
/*     */     }
/* 238 */     return implies;
/*     */   }
/*     */ 
/*     */   int hash()
/*     */   {
/* 243 */     int hashCode = this.urlPattern.hashCode();
/* 244 */     if (this.urlPatternList != null)
/* 245 */       hashCode += this.urlPatternList.hashCode();
/* 246 */     return hashCode;
/*     */   }
/*     */ 
/*     */   boolean equals(URLPatternSpec spec)
/*     */   {
/* 251 */     if (this.urlPattern.equals(spec.urlPattern) == true)
/*     */     {
/* 253 */       if ((this.urlPatternList == null) || (this.urlPatternList.equals(spec.urlPatternList)))
/*     */       {
/* 255 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 259 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.URLPatternSpec
 * JD-Core Version:    0.6.0
 */