/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.security.SecurityPermission;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public final class PolicyContext
/*     */ {
/*  78 */   private static SecurityPermission setPolicy = new SecurityPermission("setPolicy");
/*  79 */   private static SecurityPermission getPolicy = new SecurityPermission("getPolicy");
/*  80 */   private static ThreadLocal handlerDataLocal = new ThreadLocal();
/*  81 */   private static ThreadLocal contextIDLocal = new ThreadLocal();
/*  82 */   private static Map handlerMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public static Object getContext(String key)
/*     */     throws PolicyContextException
/*     */   {
/* 106 */     if ((key == null) || (!handlerMap.containsKey(key)))
/* 107 */       throw new IllegalArgumentException("No PolicyContextHandler for key=" + key);
/* 108 */     SecurityManager sm = System.getSecurityManager();
/* 109 */     if (sm != null) {
/* 110 */       sm.checkPermission(getPolicy);
/*     */     }
/* 112 */     PolicyContextHandler handler = (PolicyContextHandler)handlerMap.get(key);
/* 113 */     if (!handler.supports(key))
/* 114 */       throw new IllegalArgumentException("PolicyContextHandler does not support key=" + key);
/* 115 */     Object data = handlerDataLocal.get();
/* 116 */     Object context = handler.getContext(key, data);
/* 117 */     return context;
/*     */   }
/*     */ 
/*     */   public static String getContextID()
/*     */   {
/* 130 */     String contextID = (String)contextIDLocal.get();
/* 131 */     return contextID;
/*     */   }
/*     */ 
/*     */   public static Set getHandlerKeys()
/*     */   {
/* 143 */     return handlerMap.keySet();
/*     */   }
/*     */ 
/*     */   public static void registerHandler(String key, PolicyContextHandler handler, boolean replace)
/*     */     throws PolicyContextException
/*     */   {
/* 175 */     if (key == null)
/* 176 */       throw new IllegalArgumentException("The key may not be null");
/* 177 */     if (handler == null)
/* 178 */       throw new IllegalArgumentException("The handler may not be null");
/* 179 */     SecurityManager sm = System.getSecurityManager();
/* 180 */     if (sm != null)
/* 181 */       sm.checkPermission(setPolicy);
/* 182 */     if ((!replace) && (handlerMap.containsKey(key) == true))
/*     */     {
/* 184 */       String msg = "Handler for key=" + key + ", exists, handler: " + handlerMap.get(key);
/* 185 */       throw new IllegalArgumentException(msg);
/*     */     }
/*     */ 
/* 188 */     handlerMap.put(key, handler);
/*     */   }
/*     */ 
/*     */   public static void setContextID(String contextID)
/*     */   {
/* 204 */     SecurityManager sm = System.getSecurityManager();
/* 205 */     if (sm != null)
/* 206 */       sm.checkPermission(setPolicy);
/* 207 */     contextIDLocal.set(contextID);
/*     */   }
/*     */ 
/*     */   public static void setHandlerData(Object data)
/*     */   {
/* 225 */     SecurityManager sm = System.getSecurityManager();
/* 226 */     if (sm != null)
/* 227 */       sm.checkPermission(setPolicy);
/* 228 */     handlerDataLocal.set(data);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.PolicyContext
 * JD-Core Version:    0.6.0
 */