/*     */ package javax.resource.spi.work;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.util.EventObject;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public class WorkEvent extends EventObject
/*     */ {
/*     */   static final long serialVersionUID;
/*     */   private static final ObjectStreamField[] serialPersistentFields;
/*     */   private static final int TYPE_IDX = 0;
/*     */   private static final int WORK_IDX = 1;
/*     */   private static final int EXCPEPTION_IDX = 2;
/*     */   private static final int DURATION_IDX = 2;
/*     */   public static final int WORK_ACCEPTED = 1;
/*     */   public static final int WORK_REJECTED = 2;
/*     */   public static final int WORK_STARTED = 3;
/*     */   public static final int WORK_COMPLETED = 4;
/*     */   private int type;
/*     */   private Work work;
/*     */   private WorkException e;
/*     */   private long startDuration;
/*     */ 
/*     */   public WorkEvent(Object source, int type, Work work, WorkException e)
/*     */   {
/* 112 */     this(source, type, work, e, 0L);
/*     */   }
/*     */ 
/*     */   public WorkEvent(Object source, int type, Work work, WorkException e, long startDuration)
/*     */   {
/* 126 */     super(source);
/* 127 */     this.type = type;
/* 128 */     this.work = work;
/* 129 */     this.e = e;
/* 130 */     this.startDuration = startDuration;
/*     */   }
/*     */ 
/*     */   public int getType()
/*     */   {
/* 140 */     return this.type;
/*     */   }
/*     */ 
/*     */   public Work getWork()
/*     */   {
/* 150 */     return this.work;
/*     */   }
/*     */ 
/*     */   public WorkException getException()
/*     */   {
/* 160 */     return this.e;
/*     */   }
/*     */ 
/*     */   public long getStartDuration()
/*     */   {
/* 170 */     return this.startDuration;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 177 */     ObjectInputStream.GetField fields = ois.readFields();
/* 178 */     String name = serialPersistentFields[0].getName();
/* 179 */     this.type = fields.get(name, 0);
/* 180 */     name = serialPersistentFields[1].getName();
/* 181 */     this.work = ((Work)fields.get(name, null));
/* 182 */     name = serialPersistentFields[2].getName();
/* 183 */     this.e = ((WorkException)fields.get(name, null));
/* 184 */     name = serialPersistentFields[2].getName();
/* 185 */     this.startDuration = fields.get(name, 0L);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 192 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 193 */     String name = serialPersistentFields[0].getName();
/* 194 */     fields.put(name, this.type);
/* 195 */     name = serialPersistentFields[1].getName();
/* 196 */     fields.put(name, this.work);
/* 197 */     name = serialPersistentFields[2].getName();
/* 198 */     fields.put(name, this.e);
/* 199 */     name = serialPersistentFields[2].getName();
/* 200 */     fields.put(name, this.startDuration);
/* 201 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  62 */     if (SerialVersion.version == 0)
/*     */     {
/*  64 */       serialVersionUID = 6971276136970053051L;
/*  65 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("work", Work.class), new ObjectStreamField("e", WorkException.class), new ObjectStreamField("startDuration", Long.TYPE) };
/*     */     }
/*     */     else
/*     */     {
/*  79 */       serialVersionUID = -3063612635015047218L;
/*  80 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("work", Work.class), new ObjectStreamField("exception", WorkException.class), new ObjectStreamField("startDuration", Long.TYPE) };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.resource.spi.work.WorkEvent
 * JD-Core Version:    0.6.0
 */