/*     */ package javax.resource.spi.security;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ 
/*     */ public final class PasswordCredential
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -1770833344350711674L;
/*     */   private String userName;
/*     */   private char[] password;
/*  43 */   private ManagedConnectionFactory mcf = null;
/*     */ 
/*     */   public PasswordCredential(String userName, char[] password)
/*     */   {
/*  53 */     this.userName = userName;
/*  54 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/*  64 */     return this.userName;
/*     */   }
/*     */ 
/*     */   public char[] getPassword()
/*     */   {
/*  74 */     return this.password;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactory getManagedConnectionFactory()
/*     */   {
/*  85 */     return this.mcf;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactory(ManagedConnectionFactory mcf)
/*     */   {
/*  96 */     this.mcf = mcf;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 101 */     if (this == other)
/* 102 */       return true;
/* 103 */     if ((other == null) || (getClass() != other.getClass()))
/* 104 */       return false;
/* 105 */     PasswordCredential otherCredential = (PasswordCredential)other;
/* 106 */     if ((this.userName == null) && (this.userName != otherCredential.userName))
/* 107 */       return false;
/* 108 */     return (this.userName.equals(otherCredential.userName)) && (Arrays.equals(this.password, otherCredential.password));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 113 */     return this.userName.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.resource.spi.security.PasswordCredential
 * JD-Core Version:    0.6.0
 */