/*     */ package javax.persistence;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import javax.persistence.spi.PersistenceProvider;
/*     */ 
/*     */ public class Persistence
/*     */ {
/*     */   public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
/*  25 */   protected static final Set<PersistenceProvider> providers = new HashSet();
/*     */ 
/*  97 */   private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");
/*     */ 
/*     */   public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName)
/*     */   {
/*  34 */     return createEntityManagerFactory(persistenceUnitName, null);
/*     */   }
/*     */ 
/*     */   public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties)
/*     */   {
/*  46 */     EntityManagerFactory emf = null;
/*     */ 
/*  48 */     if (providers.size() == 0) {
/*  49 */       findAllProviders();
/*     */     }
/*  51 */     for (PersistenceProvider provider : providers) {
/*  52 */       emf = provider.createEntityManagerFactory(persistenceUnitName, properties);
/*  53 */       if (emf != null) break;
/*     */     }
/*  55 */     if (emf == null) {
/*  56 */       throw new PersistenceException("No Persistence provider for EntityManager named " + persistenceUnitName);
/*     */     }
/*  58 */     return emf;
/*     */   }
/*     */ 
/*     */   private static void findAllProviders()
/*     */   {
/*     */     try
/*     */     {
/*  65 */       loader = Thread.currentThread().getContextClassLoader();
/*  66 */       Enumeration resources = loader.getResources("META-INF/services/" + PersistenceProvider.class.getName());
/*  67 */       Set names = new HashSet();
/*  68 */       while (resources.hasMoreElements()) {
/*  69 */         URL url = (URL)resources.nextElement();
/*  70 */         InputStream is = url.openStream();
/*     */         try {
/*  72 */           names.addAll(providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
/*     */         }
/*     */         finally {
/*  75 */           is.close();
/*     */         }
/*     */       }
/*  78 */       for (String s : names) {
/*  79 */         Class providerClass = loader.loadClass(s);
/*  80 */         providers.add((PersistenceProvider)providerClass.newInstance());
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */       ClassLoader loader;
/*  84 */       throw new PersistenceException(e);
/*     */     }
/*     */     catch (InstantiationException e) {
/*  87 */       throw new PersistenceException(e);
/*     */     }
/*     */     catch (IllegalAccessException e) {
/*  90 */       throw new PersistenceException(e);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*  93 */       throw new PersistenceException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Set<String> providerNamesFromReader(BufferedReader reader)
/*     */     throws IOException
/*     */   {
/* 100 */     Set names = new HashSet();
/*     */     String line;
/* 102 */     while ((line = reader.readLine()) != null) {
/* 103 */       line = line.trim();
/* 104 */       Matcher m = nonCommentPattern.matcher(line);
/* 105 */       if (m.find()) {
/* 106 */         names.add(m.group().trim());
/*     */       }
/*     */     }
/* 109 */     return names;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.persistence.Persistence
 * JD-Core Version:    0.6.0
 */