/*    */ package javax.jms;
/*    */ 
/*    */ public class QueueRequestor
/*    */ {
/* 33 */   private QueueSession queueSession = null;
/*    */ 
/* 35 */   private QueueSender requestSender = null;
/*    */ 
/* 37 */   private QueueReceiver replyReceiver = null;
/*    */ 
/* 39 */   private TemporaryQueue replyQueue = null;
/*    */ 
/*    */   public QueueRequestor(QueueSession session, Queue queue) throws JMSException
/*    */   {
/* 43 */     this.queueSession = session;
/*    */ 
/* 45 */     this.requestSender = this.queueSession.createSender(queue);
/* 46 */     this.replyQueue = this.queueSession.createTemporaryQueue();
/* 47 */     this.replyReceiver = this.queueSession.createReceiver(this.replyQueue);
/*    */   }
/*    */ 
/*    */   public Message request(Message message) throws JMSException
/*    */   {
/* 52 */     message.setJMSReplyTo(this.replyQueue);
/* 53 */     message.setJMSDeliveryMode(1);
/* 54 */     this.requestSender.send(message);
/* 55 */     return this.replyReceiver.receive();
/*    */   }
/*    */ 
/*    */   public void close() throws JMSException
/*    */   {
/*    */     try
/*    */     {
/* 62 */       this.replyReceiver.close();
/*    */     }
/*    */     catch (JMSException ignored)
/*    */     {
/*    */     }
/*    */     try
/*    */     {
/* 69 */       this.replyQueue.delete();
/*    */     }
/*    */     catch (JMSException ignored)
/*    */     {
/*    */     }
/* 74 */     this.queueSession.close();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.jms.QueueRequestor
 * JD-Core Version:    0.6.0
 */