/*     */ package javax.enterprise.deploy.shared.factories;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.enterprise.deploy.spi.DeploymentManager;
/*     */ import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
/*     */ import javax.enterprise.deploy.spi.factories.DeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class DeploymentFactoryManager
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(DeploymentFactoryManager.class);
/*     */ 
/*  65 */   private static final DeploymentFactoryManager instance = new DeploymentFactoryManager();
/*     */ 
/*  70 */   private Set deploymentFactories = Collections.synchronizedSet(new HashSet());
/*     */ 
/*     */   public static DeploymentFactoryManager getInstance()
/*     */   {
/*  84 */     return instance;
/*     */   }
/*     */ 
/*     */   public DeploymentFactory[] getDeploymentFactories()
/*     */   {
/*  94 */     DeploymentFactory[] template = new DeploymentFactory[0];
/*  95 */     return (DeploymentFactory[])(DeploymentFactory[])this.deploymentFactories.toArray(template);
/*     */   }
/*     */ 
/*     */   public DeploymentManager getDeploymentManager(String uri, String userName, String password)
/*     */     throws DeploymentManagerCreationException
/*     */   {
/*     */     Set clone;
/* 110 */     synchronized (this.deploymentFactories)
/*     */     {
/* 112 */       clone = new HashSet(this.deploymentFactories);
/*     */     }
/* 114 */     for (Iterator i = clone.iterator(); i.hasNext(); )
/*     */     {
/* 116 */       DeploymentFactory factory = (DeploymentFactory)i.next();
/* 117 */       if (factory.handlesURI(uri))
/* 118 */         return factory.getDeploymentManager(uri, userName, password);
/*     */     }
/* 120 */     throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
/*     */   }
/*     */ 
/*     */   public void registerDeploymentFactory(DeploymentFactory factory)
/*     */   {
/* 130 */     this.deploymentFactories.add(factory);
/*     */   }
/*     */ 
/*     */   public DeploymentManager getDisconnectedDeploymentManager(String uri)
/*     */     throws DeploymentManagerCreationException
/*     */   {
/*     */     Set clone;
/* 143 */     synchronized (this.deploymentFactories)
/*     */     {
/* 145 */       clone = new HashSet(this.deploymentFactories);
/*     */     }
/* 147 */     for (Iterator i = clone.iterator(); i.hasNext(); )
/*     */     {
/* 149 */       DeploymentFactory factory = (DeploymentFactory)i.next();
/* 150 */       if (factory.handlesURI(uri))
/* 151 */         return factory.getDisconnectedDeploymentManager(uri);
/*     */     }
/* 153 */     throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.enterprise.deploy.shared.factories.DeploymentFactoryManager
 * JD-Core Version:    0.6.0
 */