/*     */ package com.arjuna.common.util.concurrency;
/*     */ 
/*     */ public class Rendezvous
/*     */ {
/*  56 */   private int size = 0;
/*     */ 
/*  61 */   private int counter = 0;
/*     */ 
/*  63 */   private Barrier barrier = null;
/*     */ 
/*  65 */   private Object[] locks = null;
/*     */ 
/*  67 */   private Object[] tokensIn = null;
/*     */ 
/*  69 */   private Object[] tokensOut = null;
/*     */ 
/*  71 */   private RendezvousFunction func = null;
/*     */ 
/*     */   public Rendezvous(int size)
/*     */   {
/*  75 */     this.size = size;
/*  76 */     if (size < 2)
/*  77 */       throw new IllegalArgumentException("size must be a minimum of 2!");
/*  78 */     this.barrier = new Barrier(size);
/*  79 */     this.locks = new Object[size];
/*  80 */     this.tokensIn = new Object[size];
/*  81 */     this.tokensOut = new Object[size];
/*  82 */     for (int i = 0; i < size; i++)
/*  83 */       this.locks[i] = new Object();
/*  84 */     this.func = new Rotator();
/*     */   }
/*     */ 
/*     */   public Object enter(int id, Object o)
/*     */   {
/*  89 */     if ((id < 0) || (id >= this.size)) {
/*  90 */       throw new IllegalArgumentException("the id must be within the range 0 =< id < size : " + id);
/*     */     }
/*     */ 
/*  93 */     synchronized (this.locks[id])
/*     */     {
/*  95 */       this.tokensIn[id] = o;
/*  96 */       this.barrier.enter();
/*  97 */       synchronized (this)
/*     */       {
/*  99 */         this.counter += 1;
/* 100 */         if (this.counter == this.size)
/*     */         {
/* 102 */           this.func.rendezvousFunction(this.tokensIn, this.tokensOut);
/* 103 */           this.counter = 0;
/* 104 */           notifyAll();
/*     */         }
/* 106 */         if (this.counter != 0)
/*     */         {
/*     */           try
/*     */           {
/* 110 */             wait();
/*     */           }
/*     */           catch (InterruptedException ie)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 118 */       return this.tokensOut[id];
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRendezvousFunction(RendezvousFunction func)
/*     */   {
/* 124 */     this.func = func;
/*     */   }
/*     */ 
/*     */   public static class Rotator
/*     */     implements Rendezvous.RendezvousFunction
/*     */   {
/*     */     public void rendezvousFunction(Object[] inObjects, Object[] outObjects)
/*     */     {
/*  47 */       int length = inObjects.length;
/*  48 */       for (int i = 0; i < length; i++)
/*     */       {
/*  50 */         outObjects[((i + i) % length)] = inObjects[i];
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface RendezvousFunction
/*     */   {
/*     */     public abstract void rendezvousFunction(Object[] paramArrayOfObject1, Object[] paramArrayOfObject2);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.concurrency.Rendezvous
 * JD-Core Version:    0.6.0
 */