/*    */ package com.arjuna.common.util;
/*    */ 
/*    */ public class VersionCheck
/*    */ {
/* 55 */   private static final String CLASS_VERSION = System.getProperty("java.class.version", "44.0");
/* 56 */   private static final boolean IS_JDK_11 = ("46.0".compareTo(CLASS_VERSION) > 0) && ("45.3".compareTo(CLASS_VERSION) <= 0);
/* 57 */   private static final boolean IS_JDK_12 = ("47.0".compareTo(CLASS_VERSION) > 0) && ("46.0".compareTo(CLASS_VERSION) <= 0);
/* 58 */   private static final boolean IS_JDK_13 = ("48.0".compareTo(CLASS_VERSION) > 0) && ("47.0".compareTo(CLASS_VERSION) <= 0);
/* 59 */   private static final boolean IS_JDK_14 = ("49.0".compareTo(CLASS_VERSION) > 0) && ("48.0".compareTo(CLASS_VERSION) <= 0);
/* 60 */   private static final boolean IS_JDK_13_OR_BELOW = (IS_JDK_11) || (IS_JDK_12) || (IS_JDK_13);
/* 61 */   private static final boolean IS_JDK_14_OR_ABOVE = "48.0".compareTo(CLASS_VERSION) <= 0;
/*    */ 
/*    */   public static final boolean isJDK11only()
/*    */   {
/* 66 */     return IS_JDK_11;
/*    */   }
/*    */ 
/*    */   public static final boolean isJDK12only()
/*    */   {
/* 71 */     return IS_JDK_12;
/*    */   }
/*    */ 
/*    */   public static final boolean isJDK13only()
/*    */   {
/* 76 */     return IS_JDK_13;
/*    */   }
/*    */ 
/*    */   public static final boolean isJDK14only()
/*    */   {
/* 81 */     return IS_JDK_14;
/*    */   }
/*    */ 
/*    */   public static final boolean isJDK13orBelow()
/*    */   {
/* 86 */     return IS_JDK_13_OR_BELOW;
/*    */   }
/*    */ 
/*    */   public static final boolean isJDK14orAbove()
/*    */   {
/* 91 */     return IS_JDK_14_OR_ABOVE;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.VersionCheck
 * JD-Core Version:    0.6.0
 */