/*     */ package com.arjuna.ats.txoj;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.StateManagerAttribute;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.txoj.lockstore.LockStore;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ class CadaverLockRecord extends LockRecord
/*     */ {
/*     */   private LockStore cadaverLockStore;
/*     */   private String objectTypeName;
/*     */   private boolean doRelease;
/*     */ 
/*     */   public CadaverLockRecord(LockStore store, LockManager lm, BasicAction currAct)
/*     */   {
/*  75 */     super(lm, currAct);
/*     */ 
/*  77 */     this.cadaverLockStore = store;
/*  78 */     this.objectTypeName = new String(lm.type());
/*     */ 
/*  80 */     if (((StateManagerAttribute)lm.attributes()).objectModel == 0)
/*     */     {
/*  82 */       this.doRelease = false;
/*     */     }
/*     */     else {
/*  85 */       this.doRelease = true;
/*     */     }
/*  87 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  89 */       txojLogger.aitLogger.debug(1L, 4L, 10L, "CadaverLockRecord::CadaverLockRecord(" + store + ", " + (lm != null ? lm.get_uid() : Uid.nullUid()) + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean propagateOnAbort()
/*     */   {
/* 103 */     return true;
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 114 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 116 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 121 */     if (this.doRelease)
/*     */     {
/* 123 */       CadaverLockManager manager = new CadaverLockManager(order(), this.objectTypeName);
/*     */ 
/* 125 */       if (this.actionHandle == null)
/*     */       {
/* 127 */         if (txojLogger.aitLoggerI18N.isFatalEnabled())
/*     */         {
/* 129 */           txojLogger.aitLoggerI18N.fatal("CadaverLockRecord_1");
/*     */         }
/*     */ 
/* 132 */         throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_1"));
/*     */       }
/*     */ 
/* 135 */       return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
/*     */     }
/*     */ 
/* 138 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 143 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 145 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 150 */     if (this.doRelease)
/*     */     {
/* 158 */       if (this.actionHandle == null)
/*     */       {
/* 160 */         if (txojLogger.aitLoggerI18N.isFatalEnabled())
/*     */         {
/* 162 */           txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_2");
/*     */         }
/*     */ 
/* 165 */         throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_2"));
/*     */       }
/*     */ 
/* 168 */       CadaverLockManager manager = new CadaverLockManager(order(), this.objectTypeName);
/*     */ 
/* 170 */       return manager.propagate(this.actionHandle.get_uid(), this.actionHandle.parent().get_uid()) ? 7 : 8;
/*     */     }
/*     */ 
/* 173 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 178 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 180 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 185 */     if (this.doRelease)
/*     */     {
/* 187 */       if (this.actionHandle == null)
/*     */       {
/* 189 */         if (txojLogger.aitLoggerI18N.isFatalEnabled())
/*     */         {
/* 191 */           txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_3");
/*     */         }
/*     */ 
/* 194 */         throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_3"));
/*     */       }
/*     */ 
/* 197 */       CadaverLockManager manager = new CadaverLockManager(order(), this.objectTypeName);
/*     */ 
/* 199 */       return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
/*     */     }
/*     */ 
/* 202 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 207 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 209 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 214 */     if (this.doRelease)
/*     */     {
/* 216 */       if (this.actionHandle == null)
/*     */       {
/* 218 */         if (txojLogger.aitLoggerI18N.isFatalEnabled())
/*     */         {
/* 220 */           txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_4");
/*     */         }
/*     */ 
/* 223 */         throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_4"));
/*     */       }
/*     */ 
/* 226 */       CadaverLockManager manager = new CadaverLockManager(order(), this.objectTypeName);
/*     */ 
/* 228 */       return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
/*     */     }
/*     */ 
/* 231 */     return 7;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 236 */     strm.println("CadaverLockRecord : ");
/* 237 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 242 */     return "/StateManager/AbstractRecord/LockRecord/CadaverLockRecord";
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord ar)
/*     */   {
/* 247 */     return (order().equals(ar.order())) && (ar.typeIs() == 121);
/*     */   }
/*     */ 
/*     */   public void replace(AbstractRecord ar)
/*     */   {
/* 259 */     LockRecord lr = (LockRecord)ar;
/*     */ 
/* 261 */     this.objectTypeName = lr.lockType();
/*     */   }
/*     */ 
/*     */   protected CadaverLockRecord()
/*     */   {
/* 268 */     this.cadaverLockStore = null;
/* 269 */     this.objectTypeName = null;
/* 270 */     this.doRelease = false;
/*     */ 
/* 272 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 274 */       txojLogger.aitLogger.debug(1L, 2L, 10L, "CadaverLockRecord::CadaverLockRecord ()");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.CadaverLockRecord
 * JD-Core Version:    0.6.0
 */