/*     */ package com.arjuna.ats.jta.utils;
/*     */ 
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class XAHelper
/*     */ {
/*     */   public static String printXAErrorCode(XAException e)
/*     */   {
/*  54 */     if (e == null)
/*     */     {
/*  56 */       return jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.nullexception");
/*     */     }
/*     */ 
/*  60 */     switch (e.errorCode)
/*     */     {
/*     */     case 100:
/*  63 */       return "XAException.XA_RBROLLBACK";
/*     */     case 101:
/*  65 */       return "XAException.XA_RBCOMMFAIL";
/*     */     case 102:
/*  67 */       return "XAException.XA_RBDEADLOCK";
/*     */     case 103:
/*  69 */       return "XAException.XA_RBINTEGRITY";
/*     */     case 104:
/*  71 */       return "XAException.XA_RBOTHER";
/*     */     case 105:
/*  73 */       return "XAException.XA_RBPROTO";
/*     */     case 106:
/*  75 */       return "XAException.XA_RBTIMEOUT";
/*     */     case 107:
/*  77 */       return "XAException.XA_RBTRANSIENT";
/*     */     case 9:
/*  79 */       return "XAException.XA_NOMIGRATE";
/*     */     case 8:
/*  81 */       return "XAException.XA_HEURHAZ";
/*     */     case 7:
/*  83 */       return "XAException.XA_HEURCOM";
/*     */     case 6:
/*  85 */       return "XAException.XA_HEURRB";
/*     */     case 5:
/*  87 */       return "XAException.XA_HEURMIX";
/*     */     case 3:
/*  89 */       return "XAException.XA_RDONLY";
/*     */     case -3:
/*  91 */       return "XAException.XAER_RMERR";
/*     */     case -4:
/*  93 */       return "XAException.XAER_NOTA";
/*     */     case -5:
/*  95 */       return "XAException.XAER_INVAL";
/*     */     case -6:
/*  97 */       return "XAException.XAER_PROTO";
/*     */     case -7:
/*  99 */       return "XAException.XAER_RMFAIL";
/*     */     case -8:
/* 101 */       return "XAException.XAER_DUPID";
/*     */     case -9:
/* 103 */       return "XAException.XAER_OUTSIDE";
/*     */     case 4:
/* 105 */       return "XAException.XA_RETRY";
/*     */     }
/* 107 */     return jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.unknownerrorcode") + e.errorCode;
/*     */   }
/*     */ 
/*     */   public static boolean sameXID(Xid x1, Xid x2)
/*     */   {
/* 127 */     if (x1 == x2) {
/* 128 */       return true;
/*     */     }
/*     */ 
/* 131 */     if (x1.getFormatId() == x2.getFormatId())
/*     */     {
/* 133 */       byte[] gtrid1 = x1.getGlobalTransactionId();
/* 134 */       byte[] gtrid2 = x2.getGlobalTransactionId();
/*     */ 
/* 136 */       if (gtrid1.length == gtrid2.length)
/*     */       {
/* 138 */         for (int i = 0; i < gtrid1.length; i++)
/*     */         {
/* 140 */           if (gtrid1[i] != gtrid2[i])
/* 141 */             return false;
/*     */         }
/*     */       }
/*     */       else {
/* 145 */         return false;
/*     */       }
/* 147 */       byte[] bqual1 = x1.getBranchQualifier();
/* 148 */       int bqual1Len = bqual1 == null ? 0 : bqual1.length;
/* 149 */       byte[] bqual2 = x2.getBranchQualifier();
/* 150 */       int bqual2Len = bqual2 == null ? 0 : bqual2.length;
/*     */ 
/* 152 */       if (bqual1Len == bqual2Len)
/*     */       {
/* 154 */         for (int i = 0; i < bqual1Len; i++)
/*     */         {
/* 156 */           if (bqual1[i] != bqual2[i])
/* 157 */             return false;
/*     */         }
/*     */       }
/*     */       else {
/* 161 */         return false;
/*     */       }
/* 163 */       return true;
/*     */     }
/*     */ 
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public static String xidToString(Xid xid)
/*     */   {
/* 177 */     String globalTranId = new String(xid.getGlobalTransactionId());
/*     */ 
/* 180 */     byte[] qualifier = xid.getBranchQualifier();
/*     */ 
/* 182 */     if ((qualifier != null) && (qualifier.length > 0))
/*     */     {
/* 184 */       String branchQualifier = new String(qualifier);
/*     */ 
/* 186 */       return new String("< " + xid.getFormatId() + ", " + globalTranId + ", " + branchQualifier + " >");
/*     */     }
/*     */ 
/* 191 */     return new String("< " + xid.getFormatId() + ", " + globalTranId + " >");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jta.utils.XAHelper
 * JD-Core Version:    0.6.0
 */